/*
 * Decompiled with CFR 0.152.
 */
package net.norevy.optileaves.configuration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraftforge.fml.loading.FMLPaths;
import net.norevy.optileaves.common.OptiLeavesMod;

public class Configuration {
    public static final Configuration INSTANCE = new Configuration();
    private static final String CONFIG_FILENAME = "optileaves.json";
    public boolean enabled = true;
    public boolean useCache = true;
    public int depth = 2;
    public boolean debug = true;
    private final Path configFile = FMLPaths.CONFIGDIR.get().resolve("optileaves.json");
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    private Configuration() {
    }

    public void load() {
        try {
            if (Files.notExists(this.configFile, new LinkOption[0])) {
                this.save();
                return;
            }
            String json = Files.readString(this.configFile);
            JsonObject jsonObject = (JsonObject)this.gson.fromJson(json, JsonObject.class);
            if (jsonObject != null) {
                if (jsonObject.has("enabled")) {
                    this.enabled = jsonObject.get("enabled").getAsBoolean();
                }
                if (jsonObject.has("useCache")) {
                    this.useCache = jsonObject.get("useCache").getAsBoolean();
                }
                if (jsonObject.has("depth")) {
                    this.depth = Math.max(1, Math.min(jsonObject.get("depth").getAsInt(), 10));
                }
                if (jsonObject.has("debug")) {
                    this.debug = jsonObject.get("debug").getAsBoolean();
                }
            }
        }
        catch (IOException e) {
            OptiLeavesMod.getLogger().error("Failed to load config", (Throwable)e);
        }
    }

    public void save() {
        try {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("enabled", Boolean.valueOf(this.enabled));
            jsonObject.addProperty("useCache", Boolean.valueOf(this.useCache));
            jsonObject.addProperty("depth", (Number)this.depth);
            jsonObject.addProperty("debug", Boolean.valueOf(this.debug));
            Files.createDirectories(this.configFile.getParent(), new FileAttribute[0]);
            Files.writeString(this.configFile, (CharSequence)this.gson.toJson((JsonElement)jsonObject), new OpenOption[0]);
        }
        catch (IOException e) {
            OptiLeavesMod.getLogger().error("Failed to save config", (Throwable)e);
        }
    }
}

