/*
 * Decompiled with CFR 0.152.
 */
package net.norevy.optileaves.mixins.invalidation;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.norevy.optileaves.configuration.Configuration;
import net.norevy.optileaves.util.LeafCullCache;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelChunk.class})
public abstract class LevelChunkMixin {
    @Shadow
    public abstract Level getLevel();

    @Inject(method={"setBlockState"}, at={@At(value="RETURN")})
    public void optileaves$onSetBlockState(BlockPos pos, BlockState state, boolean isMoving, CallbackInfoReturnable<BlockState> cir) {
        if (!Configuration.INSTANCE.useCache) {
            return;
        }
        if (this.getLevel().isClientSide && cir.getReturnValue() != null) {
            LeafCullCache.invalidateAround(pos);
        }
    }
}

