/*
 * Decompiled with CFR 0.152.
 */
package net.norevy.optileaves.mixins.renderer;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.norevy.optileaves.common.OptiLeavesMod;
import net.norevy.optileaves.configuration.Configuration;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Block.class})
public class RenderVisibilityMixin {
    @Inject(method={"shouldRenderFace"}, at={@At(value="HEAD")}, cancellable=true)
    private static void optileaves$onShouldRenderFace(BlockState state, BlockGetter level, BlockPos pos, Direction face, BlockPos relativePos, CallbackInfoReturnable<Boolean> cir) {
        if (!Configuration.INSTANCE.enabled) {
            return;
        }
        if (!(state.getBlock() instanceof LeavesBlock)) {
            return;
        }
        boolean shouldCull = OptiLeavesMod.shouldCullSide(level, pos, face);
        if (shouldCull) {
            cir.setReturnValue((Object)false);
            return;
        }
    }
}

