/*
 * Decompiled with CFR 0.152.
 */
package net.norevy.optileaves.util;

import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.ModList;
import net.norevy.optileaves.common.OptiLeavesMod;
import net.norevy.optileaves.configuration.Configuration;

public class Compat {
    private static boolean isEmbeddiumLoaded;
    private static boolean isRubidiumLoaded;

    public static void init() {
        isEmbeddiumLoaded = ModList.get().isLoaded("embeddium");
        isRubidiumLoaded = ModList.get().isLoaded("rubidium");
        if (isEmbeddiumLoaded) {
            OptiLeavesMod.getLogger().info("[OptiLeaves] Embeddium detected.");
        }
        if (isRubidiumLoaded) {
            OptiLeavesMod.getLogger().info("[OptiLeaves] Rubidium detected.");
        }
    }

    public static boolean isSodiumLoaded() {
        return isEmbeddiumLoaded || isRubidiumLoaded;
    }

    public static boolean isFancyLeaves() {
        block3: {
            try {
                Minecraft mc = Minecraft.getInstance();
                if (mc != null && mc.options != null) {
                    GraphicsStatus graphics = (GraphicsStatus)mc.options.graphicsMode().get();
                    return graphics == GraphicsStatus.FANCY || graphics == GraphicsStatus.FABULOUS;
                }
            }
            catch (Exception e) {
                if (!Configuration.INSTANCE.debug) break block3;
                OptiLeavesMod.getLogger().warn("[OptiLeaves] Could not determine graphics mode, defaulting to fancy");
            }
        }
        return true;
    }
}

