/*
 * Decompiled with CFR 0.152.
 */
package net.norevy.optileaves.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.norevy.optileaves.common.OptiLeavesMod;
import net.norevy.optileaves.configuration.Configuration;

public class LeafCullCache {
    private static final ConcurrentHashMap<Long, ChunkCache> CHUNK_CACHE = new ConcurrentHashMap();
    private static int effectiveDepth = 2;
    public static long hits = 0L;
    public static long misses = 0L;
    public static long invalidations = 0L;

    public static void setEffectiveDepth(int depth) {
        if (effectiveDepth != depth) {
            effectiveDepth = depth;
            LeafCullCache.clearAll();
        }
    }

    public static void clearAll() {
        CHUNK_CACHE.clear();
        hits = 0L;
        misses = 0L;
        invalidations = 0L;
    }

    public static void removeChunk(long chunkPos) {
        CHUNK_CACHE.remove(chunkPos);
    }

    public static void invalidateAround(BlockPos pos) {
        LeafCullCache.invalidatePos(pos);
        for (Direction dir : Direction.values()) {
            BlockPos.MutableBlockPos tmp = new BlockPos.MutableBlockPos();
            for (int i = 1; i <= effectiveDepth; ++i) {
                tmp.set((Vec3i)pos).move(dir, i);
                LeafCullCache.invalidatePos((BlockPos)tmp);
            }
        }
    }

    private static void invalidatePos(BlockPos pos) {
        int sectionY;
        SectionCache sectionCache;
        ++invalidations;
        long chunkKey = ChunkPos.asLong((BlockPos)pos);
        ChunkCache chunkCache = CHUNK_CACHE.get(chunkKey);
        if (chunkCache != null && (sectionCache = (SectionCache)chunkCache.sections.get(sectionY = pos.getY() >> 4)) != null) {
            int index = pos.getX() & 0xF | (pos.getZ() & 0xF) << 4 | (pos.getY() & 0xF) << 8;
            sectionCache.states[index] = 0;
        }
    }

    public static boolean shouldCull(BlockGetter view, BlockPos pos, Direction facing) {
        int shift;
        if (!Configuration.INSTANCE.useCache) {
            return OptiLeavesMod.computeShouldCullSide(view, pos, facing, effectiveDepth);
        }
        long chunkKey = ChunkPos.asLong((BlockPos)pos);
        ChunkCache chunkCache = CHUNK_CACHE.computeIfAbsent(chunkKey, k -> new ChunkCache());
        int sectionY = pos.getY() >> 4;
        SectionCache sectionCache = chunkCache.getOrCreateSection(sectionY);
        int index = pos.getX() & 0xF | (pos.getZ() & 0xF) << 4 | (pos.getY() & 0xF) << 8;
        int state = sectionCache.states[index] >> (shift = facing.ordinal() * 2) & 3;
        if (state != 0) {
            ++hits;
            return state == 2;
        }
        ++misses;
        boolean result = OptiLeavesMod.computeShouldCullSide(view, pos, facing, effectiveDepth);
        int cleanMask = ~(3 << shift);
        int val = result ? 2 : 1;
        sectionCache.states[index] = (short)(sectionCache.states[index] & cleanMask | val << shift);
        return result;
    }

    private static class ChunkCache {
        final Int2ObjectMap<SectionCache> sections = new Int2ObjectOpenHashMap();

        private ChunkCache() {
        }

        SectionCache getOrCreateSection(int y) {
            return (SectionCache)this.sections.computeIfAbsent(y, k -> new SectionCache());
        }
    }

    private static class SectionCache {
        final short[] states = new short[4096];

        private SectionCache() {
        }
    }
}

