/*
 * Decompiled with CFR 0.152.
 */
package net.norevy.optileaves.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraftforge.fml.loading.FMLPaths;

public class optileavesConfig {
    private static final Logger LOGGER = Logger.getLogger("OptiLeaves-Config");
    private static final String CONFIG_FILENAME = "optileaves.json";
    private static final String KEY_ENABLED = "enabled";
    private static final String KEY_DEPTH = "depth";
    private static final String KEY_DEBUG = "debug";
    public static final optileavesConfig INSTANCE = new optileavesConfig();
    public final Path configFile = FMLPaths.CONFIGDIR.get().resolve("optileaves.json");
    private final Gson gson;
    public boolean enabled;
    public int depth;
    public boolean debug;

    private optileavesConfig() {
        LOGGER.fine("Config file path: " + String.valueOf(this.configFile));
        this.gson = this.createGsonInstance();
        this.initializeDefaults();
    }

    private Gson createGsonInstance() {
        return new GsonBuilder().setPrettyPrinting().serializeNulls().create();
    }

    private void initializeDefaults() {
        this.enabled = true;
        this.depth = 2;
        this.debug = false;
        System.out.println("[OptiLeaves] Config initialized with defaults: enabled=" + this.enabled + ", depth=" + this.depth + ", debug=" + this.debug);
    }

    public void save() {
        try {
            LOGGER.info("Saving configuration");
            System.out.println("[OptiLeaves] Saving configuration to " + String.valueOf(this.configFile));
            Files.createDirectories(this.configFile.getParent(), new FileAttribute[0]);
            Files.deleteIfExists(this.configFile);
            JsonObject config = new JsonObject();
            config.addProperty(KEY_ENABLED, Boolean.valueOf(this.enabled));
            config.addProperty(KEY_DEPTH, (Number)this.depth);
            config.addProperty(KEY_DEBUG, Boolean.valueOf(this.debug));
            Files.writeString(this.configFile, (CharSequence)this.gson.toJson((JsonElement)config), new OpenOption[0]);
            System.out.println("[OptiLeaves] Configuration saved successfully");
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to save configuration", e);
            System.err.println("[OptiLeaves] Error saving configuration: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void load() {
        try {
            if (!Files.exists(this.configFile, LinkOption.NOFOLLOW_LINKS)) {
                LOGGER.info("No configuration file found, creating default");
                System.out.println("[OptiLeaves] Configuration file not found, creating default");
                this.save();
                return;
            }
            LOGGER.info("Loading configuration from " + String.valueOf(this.configFile));
            System.out.println("[OptiLeaves] Loading configuration from " + String.valueOf(this.configFile));
            String json = Files.readString(this.configFile);
            JsonObject config = (JsonObject)this.gson.fromJson(json, JsonObject.class);
            if (config != null) {
                if (config.has(KEY_ENABLED)) {
                    this.enabled = config.get(KEY_ENABLED).getAsBoolean();
                }
                if (config.has(KEY_DEPTH)) {
                    int configDepth = config.get(KEY_DEPTH).getAsInt();
                    this.depth = Math.max(1, Math.min(configDepth, 10));
                }
                if (config.has(KEY_DEBUG)) {
                    this.debug = config.get(KEY_DEBUG).getAsBoolean();
                }
            }
            System.out.println("[OptiLeaves] Configuration loaded: enabled=" + this.enabled + ", depth=" + this.depth + ", debug=" + this.debug);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to load configuration, using defaults", e);
            System.err.println("[OptiLeaves] Error loading configuration: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

