/*
 * Decompiled with CFR 0.152.
 */
package com.udpsendtofailed.ourinventory;

import com.udpsendtofailed.ourinventory.CollectiveState;
import com.udpsendtofailed.ourinventory.IPlayerInventory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OurInventory
implements ModInitializer {
    public static final String MOD_ID = "ourinventory";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"ourinventory");
    public static CollectiveState THE_COLLECTIVE = new CollectiveState();
    public static final ConcurrentHashMap<UUID, IPlayerInventory.SavedInventory> originalInventories = new ConcurrentHashMap();

    public void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTING.register(this::load);
        ServerLifecycleEvents.BEFORE_SAVE.register((server, flush, force) -> this.save(server));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.method_32311();
            originalInventories.put(player.method_5667(), ((IPlayerInventory)player.method_31548()).ourinventory$save());
            ((IPlayerInventory)player.method_31548()).ourinventory$updateFrom(THE_COLLECTIVE);
            LOGGER.info("Player {} has connected to the shared inventory.", (Object)player.method_5477().getString());
        });
    }

    private void save(MinecraftServer server) {
        try {
            class_2487 root = new class_2487();
            root.method_10566("collective", (class_2520)THE_COLLECTIVE.toNbt((class_7225.class_7874)server.method_30611()));
            Path path = server.method_27050(class_5218.field_24188).resolve("ourinventory.dat");
            class_2507.method_30614((class_2487)root, (Path)path);
        }
        catch (Exception e) {
            LOGGER.error("Failed to save shared inventory data", (Throwable)e);
        }
    }

    private void load(MinecraftServer server) {
        Path path = server.method_27050(class_5218.field_24188).resolve("ourinventory.dat");
        if (!Files.exists(path, new LinkOption[0])) {
            THE_COLLECTIVE = new CollectiveState();
            return;
        }
        try {
            class_2487 nbt = class_2507.method_30613((Path)path, (class_2505)class_2505.method_53898());
            class_2487 collectiveNbt = (class_2487)nbt.method_10562("collective").orElseThrow();
            THE_COLLECTIVE = CollectiveState.fromNbt((class_7225.class_7874)server.method_30611(), collectiveNbt);
        }
        catch (Exception e) {
            LOGGER.error("Failed to load shared inventory data", (Throwable)e);
            THE_COLLECTIVE = new CollectiveState();
        }
    }

    public static void restorePlayer(class_1657 player) {
        IPlayerInventory.SavedInventory original = originalInventories.get(player.method_5667());
        if (original != null) {
            ((IPlayerInventory)player.method_31548()).ourinventory$restore(original);
        }
    }
}

