/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.god.init;

import net.mcreator.god.entity.FallenGodEntity;
import net.mcreator.god.entity.FollowerEntity;
import net.mcreator.god.entity.SeraphineEntity;
import net.mcreator.god.entity.WatcherEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GodModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"god");
    public static final RegistryObject<EntityType<SeraphineEntity>> SERAPHINE = GodModEntities.register("seraphine", EntityType.Builder.m_20704_(SeraphineEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(SeraphineEntity::new).m_20719_().m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<FollowerEntity>> FOLLOWER = GodModEntities.register("follower", EntityType.Builder.m_20704_(FollowerEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(FollowerEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<WatcherEntity>> WATCHER = GodModEntities.register("watcher", EntityType.Builder.m_20704_(WatcherEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(1).setUpdateInterval(3).setCustomClientFactory(WatcherEntity::new).m_20719_().m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<FallenGodEntity>> FALLEN_GOD = GodModEntities.register("fallen_god", EntityType.Builder.m_20704_(FallenGodEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(FallenGodEntity::new).m_20719_().m_20699_(0.6f, 1.8f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            SeraphineEntity.init();
            FollowerEntity.init();
            WatcherEntity.init();
            FallenGodEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)SERAPHINE.get(), SeraphineEntity.createAttributes().m_22265_());
        event.put((EntityType)FOLLOWER.get(), FollowerEntity.createAttributes().m_22265_());
        event.put((EntityType)WATCHER.get(), WatcherEntity.createAttributes().m_22265_());
        event.put((EntityType)FALLEN_GOD.get(), FallenGodEntity.createAttributes().m_22265_());
    }
}

