/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.moreunique.zombies;

import aquariusplayz.moreunique.zombies.ClientSetup;
import aquariusplayz.moreunique.zombies.IZombie;
import aquariusplayz.moreunique.zombies.IZombieRenderState;
import aquariusplayz.moreunique.zombies.ItemRenderData;
import aquariusplayz.moreunique.zombies.config.ModConfigs;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.monster.zombie.ZombieModel;
import net.minecraft.client.model.object.projectile.ArrowModel;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.AbstractZombieRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.SpectralArrowRenderer;
import net.minecraft.client.renderer.entity.TippableArrowRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.ZombieRenderState;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.zombie.Zombie;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class ZombieWardrobeLayer<S extends ZombieRenderState, M extends EntityModel<S>>
extends RenderLayer<S, M> {
    ArrowModel arrow;
    AbstractZombieRenderer renderer;

    public ZombieWardrobeLayer(EntityRendererProvider.Context context, AbstractZombieRenderer renderer) {
        super((RenderLayerParent)renderer);
        this.arrow = new ArrowModel(context.bakeLayer(ModelLayers.ARROW));
        this.renderer = renderer;
    }

    public void submit(PoseStack posestack, SubmitNodeCollector buffer, int lightlevel, S state, float yaw, float pitch) {
        Zombie zombie = ((IZombieRenderState)state).getZombie();
        if (zombie == null) {
            return;
        }
        if (zombie.isBaby()) {
            return;
        }
        if (!ClientSetup.maindata.containsKey(this.renderer)) {
            return;
        }
        int[] idList = ((IZombie)zombie).getIDList();
        ZombieModel model = (ZombieModel)this.getParentModel();
        model.root().translateAndRotate(posestack);
        ItemDisplayContext itemDisplayContext = ItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
        if (idList.length == ModConfigs.maxItemOnZombie) {
            for (int i = 0; i < ModConfigs.maxItemOnZombie; ++i) {
                ItemStack stack = ((IZombie)zombie).getZombieItem(i);
                int id = idList[i];
                if (stack == null || stack.is(Items.AIR) || !ClientSetup.maindata.get(this.renderer).containsKey(id)) continue;
                posestack.pushPose();
                HashMap<Item, ItemRenderData> itemdata = ClientSetup.maindata.get(this.renderer).get(id);
                Item item = null;
                if (itemdata.containsKey(stack.getItem())) {
                    item = stack.getItem();
                }
                ItemRenderData data = itemdata.get(item);
                if (data.item instanceof ArrowItem) {
                    RenderType renderType = this.arrow.renderType(TippableArrowRenderer.NORMAL_ARROW_LOCATION);
                    if (stack.getItem() == Items.SPECTRAL_ARROW) {
                        renderType = this.arrow.renderType(SpectralArrowRenderer.SPECTRAL_ARROW_LOCATION);
                    } else if (stack.getItem() == Items.TIPPED_ARROW) {
                        renderType = this.arrow.renderType(TippableArrowRenderer.TIPPED_ARROW_LOCATION);
                    }
                    data.translateAndRotate(posestack);
                    data.renderArrow((Model)this.arrow, renderType, posestack, lightlevel);
                } else {
                    data.translateAndRotate(posestack);
                    Minecraft.getInstance().getEntityRenderDispatcher().getItemInHandRenderer().renderItem((LivingEntity)zombie, stack, itemDisplayContext, posestack, buffer, lightlevel);
                }
                posestack.popPose();
            }
        }
    }
}

