/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.libs.entity.tamable.goals;

import aquariusplayz.libs.entity.tamable.DefaultTamableAnimal;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.PathType;

public class ModFollowOwnerGoal
extends Goal {
    private final DefaultTamableAnimal tamable;
    private LivingEntity owner;
    private double speedModifier;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private final float startDistance;
    private float oldWaterCost;

    public ModFollowOwnerGoal(DefaultTamableAnimal p_25294_, double p_25295_, float p_25296_, float p_25297_) {
        this.tamable = p_25294_;
        this.speedModifier = p_25295_;
        this.navigation = p_25294_.getNavigation();
        this.startDistance = p_25296_;
        this.stopDistance = p_25297_;
    }

    public boolean canUse() {
        if (this.tamable.getBehaviorType() == 4 || this.tamable.getBehaviorType() == 0) {
            return false;
        }
        LivingEntity livingentity = this.tamable.getOwner();
        if (livingentity == null) {
            return false;
        }
        if (this.tamable.unableToMoveToTheOwner()) {
            return false;
        }
        if (this.tamable.distanceToSqr((Entity)livingentity) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = livingentity;
        return true;
    }

    public boolean canContinueToUse() {
        if (this.navigation.isDone()) {
            return false;
        }
        return this.tamable.unableToMoveToTheOwner() ? false : !(this.tamable.distanceToSqr((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
    }

    public void start() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.tamable.getPathfindingMalus(PathType.WATER);
        this.tamable.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public void stop() {
        this.owner = null;
        this.tamable.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
    }

    public void tick() {
        boolean flag = this.tamable.teleportToOwner();
        if (!flag) {
            this.tamable.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.tamable.getMaxHeadXRot());
        }
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.adjustedTickDelay(10);
            if (this.tamable.getOwner() != null) {
                if (flag) {
                    this.tamable.tryToTeleportToOwner();
                } else {
                    this.navigation.moveTo((Entity)this.owner, this.speedModifier);
                }
            }
        }
    }
}

