/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.libs.entity.interfaces;

import aquariusplayz.libs.helper.MobVariables;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public interface IAnimal {
    public boolean canFloat();

    public boolean canPanic();

    public boolean canMobBreed();

    public boolean followParent();

    public boolean canAvoidEntity();

    public boolean avoidEntities(LivingEntity var1);

    default public boolean avoidEntityPredicament(LivingEntity entity) {
        if (!MobVariables.NO_SPECTATORS.test((Entity)entity)) {
            return false;
        }
        return this.avoidEntities(entity);
    }

    default public boolean canMoveRandomly() {
        return true;
    }

    public boolean isGroundWalker();

    default public float walkGroundSpeed() {
        return 1.0f;
    }

    default public int randomGroundWalkInterval() {
        return 40;
    }

    default public boolean followLeader() {
        return false;
    }

    public boolean isPersistent();

    public float getAnimalSoundVolume();

    public void runWhenBreeding(Animal var1, Animal var2, AgeableMob var3);

    public boolean canSpawnAnywhere();

    public boolean canBeDamagedFromFalling();

    public void runWhenEatingOnClient();

    public void runWhenEatingOnServer();

    public void runWhenMakingSoundOnClient();

    public SoundEvent hurtSound();

    public SoundEvent idleSound(int var1);

    public void runBehaviorsOnServer(ServerLevel var1);

    public void runBehaviorsOnClient(Level var1);

    public void playIdleSound();

    public int playIdleSoundChance();

    public int idleSoundInterval();

    public boolean canPlayIdleSound();

    default public void spawnItemAtLocation(Mob mob, ServerLevel level, ItemStack item) {
        mob.spawnAtLocation(level, item);
    }
}

