/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.moreunique.zombies.mixin;

import aquariusplayz.moreunique.zombies.IZombie;
import aquariusplayz.moreunique.zombies.ModSetup;
import aquariusplayz.moreunique.zombies.config.ModConfigs;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.apache.commons.lang3.math.NumberUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Zombie.class})
public abstract class ZombieMixin
extends Monster
implements IZombie {
    private static final Object[] ITEM_STACK_DATA = new Object[]{SynchedEntityData.defineId(Zombie.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK), SynchedEntityData.defineId(Zombie.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK), SynchedEntityData.defineId(Zombie.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK)};
    private static final EntityDataAccessor<String> ID_LIST_DATA = SynchedEntityData.defineId(Zombie.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    ItemStack emptyItem = new ItemStack((ItemLike)Items.AIR);
    public int[] ID_LIST = new int[ModConfigs.maxItemOnZombie];
    private static final String defaultIDList = ZombieMixin.createIDList(ModConfigs.maxItemOnZombie);

    private static String createIDList(int maxid) {
        Object tempIDList = "";
        for (int i = 0; i < maxid; ++i) {
            tempIDList = (String)tempIDList + "0" + (i == maxid - 1 ? "" : ";");
        }
        return tempIDList;
    }

    public ZombieMixin(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    public int checkId(List<Integer> temptList, int tries, int id) {
        int newid = id;
        for (int i = 0; i < tries; ++i) {
            if (temptList.contains(id)) {
                // empty if block
            }
            this.random.nextInt(34);
        }
        return newid;
    }

    @Inject(at={@At(value="RETURN")}, method={"finalizeSpawn"})
    public void finalizeSpawn(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, EntitySpawnReason entitySpawnReason, SpawnGroupData spawnGroupData, CallbackInfoReturnable<SpawnGroupData> cir) {
        if (this.isBaby()) {
            return;
        }
        Object idlistdata = "";
        ArrayList<Integer> temptList = new ArrayList<Integer>();
        for (int i = 0; i < ModConfigs.maxItemOnZombie; ++i) {
            int id = this.random.nextInt(34);
            if (temptList.contains(id)) {
                for (int k = 0; k < 5; ++k) {
                    id = this.random.nextInt(34);
                    if (temptList.contains(id)) continue;
                    temptList.add(id);
                    break;
                }
            } else {
                temptList.add(id);
            }
            idlistdata = (String)idlistdata + id + (i == ModConfigs.maxItemOnZombie - 1 ? "" : ";");
            Item newitem = Items.AIR;
            int chance = this.getRandom().nextInt(ModConfigs.NO_ITEM_CHANCE + ModConfigs.RANDOM_COMMON_ITEM_CHANCE + ModConfigs.RANDOM_UNCOMMON_ITEM_CHANCE + ModConfigs.RANDOM_RARE_ITEM_CHANCE + ModConfigs.RANDOM_EPIC_ITEM_CHANCE);
            if (chance < ModConfigs.RANDOM_EPIC_ITEM_CHANCE) {
                newitem = this.getRandomZombieItem(ModSetup.EPIC_ITEM);
            } else if (chance < ModConfigs.RANDOM_EPIC_ITEM_CHANCE + ModConfigs.RANDOM_RARE_ITEM_CHANCE) {
                newitem = this.getRandomZombieItem(ModSetup.RARE_ITEM);
            } else if (chance < ModConfigs.RANDOM_EPIC_ITEM_CHANCE + ModConfigs.RANDOM_RARE_ITEM_CHANCE + ModConfigs.RANDOM_UNCOMMON_ITEM_CHANCE) {
                newitem = this.getRandomZombieItem(ModSetup.UNCOMMON_ITEM);
            } else if (chance < ModConfigs.RANDOM_EPIC_ITEM_CHANCE + ModConfigs.RANDOM_RARE_ITEM_CHANCE + ModConfigs.RANDOM_UNCOMMON_ITEM_CHANCE + ModConfigs.RANDOM_COMMON_ITEM_CHANCE) {
                newitem = this.getRandomZombieItem(ModSetup.COMMON_ITEM);
            }
            if (newitem == Items.AIR) {
                this.setZombieItem(this.emptyItem, i);
                continue;
            }
            this.setZombieItem(new ItemStack((ItemLike)newitem), i);
        }
        this.setZombieIDList((String)idlistdata);
    }

    public Item getRandomZombieItem(TagKey<Item> tag) {
        Object object;
        Iterable itemsInTag = BuiltInRegistries.ITEM.getTagOrEmpty(tag);
        Object[] list = Iterables.toArray((Iterable)itemsInTag, Object.class);
        int length = list.length;
        if (length > 0 && (object = list[this.getRandom().nextInt(length)]) instanceof Holder) {
            Holder holder = (Holder)object;
            return (Item)holder.value();
        }
        return Items.AIR;
    }

    @Inject(at={@At(value="RETURN")}, method={"defineSynchedData"})
    public void defineSynchedData(SynchedEntityData.Builder builder, CallbackInfo ci) {
        for (int i = 0; i < ModConfigs.maxItemOnZombie; ++i) {
            builder.define((EntityDataAccessor)ITEM_STACK_DATA[i], (Object)ItemStack.EMPTY);
        }
        builder.define(ID_LIST_DATA, (Object)defaultIDList);
    }

    public void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource damageSource, boolean bl) {
        super.dropCustomDeathLoot(serverLevel, damageSource, bl);
        for (int i = 0; i < ModConfigs.maxItemOnZombie; ++i) {
            if (this.getZombieItem(i) == null) continue;
            int chance = ModConfigs.COMMON_ITEM_DROP_CHANCE_ON_DEATH;
            if (this.getZombieItem(i).is(ModSetup.UNCOMMON_ITEM)) {
                chance = ModConfigs.UNCOMMON_ITEM_DROP_CHANCE_ON_DEATH;
            } else if (this.getZombieItem(i).is(ModSetup.RARE_ITEM)) {
                chance = ModConfigs.RARE_ITEM_DROP_CHANCE_ON_DEATH;
            } else if (this.getZombieItem(i).is(ModSetup.EPIC_ITEM)) {
                chance = ModConfigs.EPIC_ITEM_DROP_CHANCE_ON_DEATH;
            }
            if (this.random.nextInt(100) >= chance || this.getZombieItem(i).is(Items.AIR)) continue;
            this.spawnAtLocation((ServerLevel)this.level(), this.getZombieItem(i));
        }
    }

    public void setZombieItem(ItemStack itemStack, int id) {
        if (itemStack.isEmpty()) {
            this.getEntityData().set((EntityDataAccessor)ITEM_STACK_DATA[id], (Object)this.emptyItem);
        } else {
            this.getEntityData().set((EntityDataAccessor)ITEM_STACK_DATA[id], (Object)itemStack.copyWithCount(1));
        }
    }

    public String getZombieIDList() {
        return (String)this.getEntityData().get(ID_LIST_DATA);
    }

    public void setZombieIDList(String list) {
        String[] newList;
        this.getEntityData().set(ID_LIST_DATA, (Object)list);
        if (list != null && list.contains(";") && this.ID_LIST.length >= (newList = list.split(";")).length) {
            for (int j = 0; j < newList.length; ++j) {
                if (!NumberUtils.isCreatable((String)newList[j])) continue;
                this.ID_LIST[j] = NumberUtils.createInteger((String)newList[j]);
            }
        }
    }

    @Override
    public ItemStack getZombieItem(int id) {
        return (ItemStack)this.getEntityData().get((EntityDataAccessor)ITEM_STACK_DATA[id]);
    }

    @Override
    public int[] getIDList() {
        String[] newList;
        if (this.getZombieIDList() != null && this.getZombieIDList().contains(";") && this.ID_LIST.length >= (newList = this.getZombieIDList().split(";")).length) {
            for (int j = 0; j < newList.length; ++j) {
                if (!NumberUtils.isCreatable((String)newList[j])) continue;
                this.ID_LIST[j] = NumberUtils.createInteger((String)newList[j]);
            }
        }
        return this.ID_LIST;
    }

    @Inject(at={@At(value="RETURN")}, method={"addAdditionalSaveData"})
    public void addAdditionalSaveData(ValueOutput valueOutput, CallbackInfo ci) {
        for (int i = 0; i < ModConfigs.maxItemOnZombie; ++i) {
            if (this.getZombieItem(i) == null || this.getZombieItem(i).is(Items.AIR)) continue;
            valueOutput.store("ZombieItem-" + i, ItemStack.CODEC, (Object)this.getZombieItem(i));
        }
        valueOutput.putString("ItemIDList", this.getZombieIDList());
    }

    @Inject(at={@At(value="RETURN")}, method={"readAdditionalSaveData"})
    public void readAdditionalSaveData(ValueInput valueInput, CallbackInfo ci) {
        for (int i = 0; i < ModConfigs.maxItemOnZombie; ++i) {
            int j = i;
            valueInput.read("ZombieItem-" + i, ItemStack.CODEC).ifPresent(stack -> this.setZombieItem((ItemStack)stack, j));
        }
        this.setZombieIDList(valueInput.getStringOr("ItemIDList", defaultIDList));
    }
}

