/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.libs.helper;

import aquariusplayz.libs.helper.MobVariables;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class MobFunctions {
    public static boolean isFood(ItemStack p_27600_, Mob mob) {
        return p_27600_.get(DataComponents.FOOD) != null;
    }

    public static AttributeSupplier.Builder createAttributes(double hp, double speed, double attackdamage, double armor, double armortoughness, double followrange, double temptrange) {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, hp).add(Attributes.MOVEMENT_SPEED, speed).add(Attributes.ARMOR, armor).add(Attributes.ARMOR_TOUGHNESS, armortoughness).add(Attributes.FOLLOW_RANGE, followrange).add(Attributes.ATTACK_DAMAGE, attackdamage);
    }

    public static AttributeSupplier.Builder createAttributes(double hp, double speed, double attackdamage, double followrange, double temptrange) {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, hp).add(Attributes.MOVEMENT_SPEED, speed).add(Attributes.ARMOR, 0.0).add(Attributes.ARMOR_TOUGHNESS, 0.0).add(Attributes.FOLLOW_RANGE, followrange).add(Attributes.ATTACK_DAMAGE, attackdamage);
    }

    public static void spawnSprintParticle(Mob mob) {
        BlockPos blockpos = mob.getOnPosLegacy();
        BlockState blockstate = mob.level().getBlockState(blockpos);
        if (!blockstate.addRunningEffects(mob.level(), blockpos, (Entity)mob) && blockstate.getRenderShape() != RenderShape.INVISIBLE) {
            Vec3 vec3 = mob.getDeltaMovement();
            BlockPos blockpos1 = mob.blockPosition();
            double d0 = mob.getX() + (mob.getRandom().nextDouble() - 0.5) * (double)mob.getDimensions(mob.getPose()).width();
            double d1 = mob.getZ() + (mob.getRandom().nextDouble() - 0.5) * (double)mob.getDimensions(mob.getPose()).width();
            if (blockpos1.getX() != blockpos.getX()) {
                d0 = Mth.clamp((double)d0, (double)blockpos.getX(), (double)((double)blockpos.getX() + 1.0));
            }
            if (blockpos1.getZ() != blockpos.getZ()) {
                d1 = Mth.clamp((double)d1, (double)blockpos.getZ(), (double)((double)blockpos.getZ() + 1.0));
            }
            mob.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockstate, blockpos), d0, mob.getY() + 0.1, d1, vec3.x * -4.0, 1.5, vec3.z * -4.0);
        }
    }

    public static AABB getHitbox(Entity self) {
        AABB aabb = self.getBoundingBox();
        Entity entity = self.getVehicle();
        if (entity != null) {
            Vec3 vec3 = entity.getPassengerRidingPosition(self);
            return aabb.setMinY(Math.max(vec3.y, aabb.minY));
        }
        return aabb;
    }

    public boolean isWithinMeleeAttackRange(Entity self, LivingEntity target) {
        return MobFunctions.getAttackBoundingBox(self).intersects(MobFunctions.getHitbox((Entity)target));
    }

    public static AABB getAttackBoundingBox(Entity self, double p_457993_) {
        AABB aabb;
        Entity entity = self.getVehicle();
        if (entity != null) {
            AABB aabb1 = entity.getBoundingBox();
            AABB aabb2 = self.getBoundingBox();
            aabb = new AABB(Math.min(aabb2.minX, aabb1.minX), aabb2.minY, Math.min(aabb2.minZ, aabb1.minZ), Math.max(aabb2.maxX, aabb1.maxX), aabb2.maxY, Math.max(aabb2.maxZ, aabb1.maxZ));
        } else {
            aabb = self.getBoundingBox();
        }
        return aabb.inflate(p_457993_, p_457993_, p_457993_);
    }

    public static AABB getAttackBoundingBox(Entity self) {
        AABB aabb;
        Entity entity = self.getVehicle();
        if (entity != null) {
            AABB aabb1 = entity.getBoundingBox();
            AABB aabb2 = self.getBoundingBox();
            aabb = new AABB(Math.min(aabb2.minX, aabb1.minX), aabb2.minY, Math.min(aabb2.minZ, aabb1.minZ), Math.max(aabb2.maxX, aabb1.maxX), aabb2.maxY, Math.max(aabb2.maxZ, aabb1.maxZ));
        } else {
            aabb = self.getBoundingBox();
        }
        return aabb.inflate(MobVariables.DEFAULT_ATTACK_REACH, 0.0, MobVariables.DEFAULT_ATTACK_REACH);
    }

    public static boolean checkSurfaceWaterCreatureSpawnRules(int checkAreaSizeForMobsOfSameTypeWhenSpawning, int maxMobOfSameTypeAroundAreaWhenSpawning, EntityType<? extends Mob> p_369363_, ServerLevelAccessor p_370080_, BlockPos p_370200_, RandomSource p_362509_) {
        if (p_362509_.nextInt(10) != 0) {
            return false;
        }
        List list = p_370080_.getLevel().getEntitiesOfClass(Mob.class, new AABB(p_370200_).inflate((double)checkAreaSizeForMobsOfSameTypeWhenSpawning));
        int mobsFound = 0;
        for (Mob entity : list) {
            if (!entity.isAlive()) continue;
            ++mobsFound;
        }
        if (mobsFound >= maxMobOfSameTypeAroundAreaWhenSpawning) {
            return false;
        }
        int i = p_370080_.getSeaLevel();
        int j = i - 13;
        return p_370200_.getY() >= j && p_370200_.getY() <= i && p_370080_.getFluidState(p_370200_.below()).is(FluidTags.WATER) && p_370080_.getBlockState(p_370200_.above()).is(Blocks.WATER);
    }
}

