/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.libs.helper;

import aquariusplayz.libs.helper.ModResourceLocation;
import java.util.Optional;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class RegisterFunctions {
    public static <T extends Mob> DeferredHolder<EntityType<?>, EntityType<T>> registerMob(DeferredRegister<EntityType<?>> moblist, String modid, String name, EntityType.EntityFactory<T> entitytype, MobCategory mobcategory, float sizeWidth, float sizeHeight) {
        return moblist.register(name, () -> EntityType.Builder.of((EntityType.EntityFactory)entitytype, (MobCategory)mobcategory).sized(sizeWidth, sizeHeight).build(RegisterFunctions.mobid(modid, name)));
    }

    public static <T extends Mob> DeferredHolder<Item, Item> registerSpawnEgg(DeferredRegister<Item> itemlist, String modid, String name, DeferredHolder<EntityType<?>, EntityType<T>> mob, int color1, int color2) {
        return itemlist.register(name, () -> new SpawnEggItem(new Item.Properties().spawnEgg((EntityType)mob.get()).setId(RegisterFunctions.itemid(modid, name))));
    }

    public static ModelLayerLocation createLayer(String modid, String name) {
        return RegisterFunctions.createLayer(modid, name, "main");
    }

    public static ModelLayerLocation createLayer(String modid, String name, String extra) {
        return new ModelLayerLocation(new ModResourceLocation(modid, name).get(), extra);
    }

    public static SoundEvent createVariableRangeEvent(String name) {
        return new SoundEvent(new ModResourceLocation(name).get(), Optional.empty());
    }

    public static SoundEvent createVariableRangeEvent(String modid, String name) {
        return new SoundEvent(new ModResourceLocation(modid, name).get(), Optional.empty());
    }

    public static ResourceKey<Biome> getBiome(String name) {
        return ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)new ModResourceLocation(name).get());
    }

    public static ResourceKey<EntityType<?>> mobid(String name) {
        return ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)new ModResourceLocation(name).get());
    }

    public static ResourceKey<Item> itemid(String name) {
        return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)new ModResourceLocation(name).get());
    }

    public static TagKey<Item> bind(String name) {
        return ItemTags.create((ResourceLocation)new ModResourceLocation(name).get());
    }

    public static ResourceKey<EntityType<?>> mobid(String modid, String name) {
        return ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)new ModResourceLocation(modid, name).get());
    }

    public static ResourceKey<Item> itemid(String modid, String name) {
        return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)new ModResourceLocation(modid, name).get());
    }

    public static TagKey<Item> bind(String modid, String name) {
        return ItemTags.create((ResourceLocation)new ModResourceLocation(modid, name).get());
    }
}

