/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.libs.entity;

import aquariusplayz.libs.entity.interfaces.IAnimal;
import aquariusplayz.libs.helper.ModAnimationState;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;

public abstract class DefaultAnimal
extends Animal
implements IAnimal {
    public int lastIdleSoundTick;

    public DefaultAnimal(EntityType<? extends Animal> p_27557_, Level p_27558_) {
        super(p_27557_, p_27558_);
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide()) {
            this.runBehaviorsOnServer((ServerLevel)this.level());
            this.playIdleSound();
        } else {
            this.runBehaviorsOnClient(this.level());
        }
    }

    @Override
    public void playIdleSound() {
        if (this.idleSound(0) != null) {
            if (this.lastIdleSoundTick > 0) {
                --this.lastIdleSoundTick;
            }
            if (this.getRandom().nextInt(this.playIdleSoundChance()) == 0 && this.lastIdleSoundTick <= 0 && this.canPlayIdleSound()) {
                this.playSound(this.idleSound(0), this.getSoundVolume(), this.getVoicePitch());
                this.level().broadcastEntityEvent((Entity)this, (byte)8);
                this.lastIdleSoundTick = 20 * this.idleSoundInterval();
            }
        }
    }

    @Override
    public int playIdleSoundChance() {
        return 200;
    }

    @Override
    public int idleSoundInterval() {
        return this.getRandom().nextInt(20) + 10;
    }

    public void registerGoals() {
        if (this.canFloat()) {
            this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        }
        if (this.canPanic()) {
            this.goalSelector.addGoal(2, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        }
        if (this.canPanic()) {
            this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 8.0f, 1.6, 1.4, entity -> this.avoidEntityPredicament((LivingEntity)entity)));
        }
        if (this.followParent()) {
            this.goalSelector.addGoal(7, (Goal)new FollowParentGoal((Animal)this, 1.1));
        }
        if (this.canMobBreed()) {
            this.goalSelector.addGoal(8, (Goal)new BreedGoal((Animal)this, 1.0));
        }
        if (this.isGroundWalker()) {
            this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, (double)this.walkGroundSpeed(), (float)this.randomGroundWalkInterval()));
        }
    }

    public boolean isPersistenceRequired() {
        return this.hasCustomName() || this.isPersistent();
    }

    public boolean requiresCustomPersistence() {
        return this.hasCustomName() || this.isPersistent();
    }

    public boolean removeWhenFarAway(double p_452414_) {
        return !this.isPersistent() && !this.hasCustomName();
    }

    protected float getSoundVolume() {
        return this.getAnimalSoundVolume();
    }

    public DefaultAnimal getBreedOffspring(ServerLevel p_148993_, AgeableMob p_148994_) {
        DefaultAnimal mob = (DefaultAnimal)this.getType().create((Level)p_148993_, EntitySpawnReason.BREEDING);
        this.runWhenBreeding(mob, this, p_148994_);
        return mob;
    }

    public boolean animationEnded(ModAnimationState state, float animLength) {
        return (float)state.getTimeInMillis(this.tickCount) > animLength * 1000.0f;
    }

    public boolean hurtServer(ServerLevel level, DamageSource damagesource, float damage) {
        if (this.isInvulnerableTo(level, damagesource)) {
            return false;
        }
        this.runWhenAttackedOnServer(level, damagesource, damage);
        return super.hurtServer(level, damagesource, damage);
    }

    public void runWhenAttackedOnServer(ServerLevel level, DamageSource damagesource, float damage) {
        if (this.hurtSound() != null) {
            this.playSound(this.hurtSound(), this.getSoundVolume(), this.getVoicePitch());
        }
        this.level().broadcastEntityEvent((Entity)this, (byte)8);
    }

    public void handleEntityEvent(byte value) {
        if (value == 8) {
            this.runWhenMakingSoundOnClient();
        } else if (value == 10) {
            this.runWhenEatingOnClient();
        } else {
            super.handleEntityEvent(value);
        }
    }
}

