/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.libs.entity.tamable;

import aquariusplayz.libs.entity.interfaces.IAnimal;
import aquariusplayz.libs.entity.tamable.goals.ModAvoidEntityGoal;
import aquariusplayz.libs.entity.tamable.goals.ModBreedGoal;
import aquariusplayz.libs.entity.tamable.goals.ModFollowOwnerGoal;
import aquariusplayz.libs.entity.tamable.goals.ModFollowParentGoal;
import aquariusplayz.libs.entity.tamable.goals.ModGoBackHomeGoal;
import aquariusplayz.libs.entity.tamable.goals.ModPanicGoal;
import aquariusplayz.libs.entity.tamable.goals.ModWaterAvoidingRandomStrollGoal;
import aquariusplayz.libs.helper.ModAnimationState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public abstract class DefaultTamableAnimal
extends TamableAnimal
implements IAnimal {
    private static final EntityDataAccessor<Integer> BEHAVIOR = SynchedEntityData.defineId(DefaultTamableAnimal.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public BlockPos home;
    public int lastIdleSoundTick;

    public DefaultTamableAnimal(EntityType<? extends TamableAnimal> p_27557_, Level p_27558_) {
        super(p_27557_, p_27558_);
        this.setTame(false, false);
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide()) {
            this.runBehaviorsOnServer((ServerLevel)this.level());
            this.playIdleSound();
        } else {
            this.runBehaviorsOnClient(this.level());
        }
    }

    @Override
    public void playIdleSound() {
        if (this.idleSound(0) != null) {
            if (this.lastIdleSoundTick > 0) {
                --this.lastIdleSoundTick;
            }
            if (this.getRandom().nextInt(this.playIdleSoundChance()) == 0 && this.lastIdleSoundTick <= 0 && this.canPlayIdleSound()) {
                this.playSound(this.idleSound(0), this.getSoundVolume(), this.getVoicePitch());
                this.level().broadcastEntityEvent((Entity)this, (byte)8);
                this.lastIdleSoundTick = 20 * this.idleSoundInterval();
            }
        }
    }

    @Override
    public int playIdleSoundChance() {
        return 200;
    }

    @Override
    public int idleSoundInterval() {
        return this.getRandom().nextInt(20) + 10;
    }

    public AgeableMob getBreedOffspring(ServerLevel p_148993_, AgeableMob p_148994_) {
        DefaultTamableAnimal mob = (DefaultTamableAnimal)this.getType().create((Level)p_148993_, EntitySpawnReason.BREEDING);
        if (this.isTame()) {
            mob.setOwnerReference(this.getOwnerReference());
            mob.setTame(true, true);
            this.runWhenBreedingTamedMob((Animal)mob, (Animal)this, p_148994_);
        }
        this.runWhenBreeding((Animal)mob, (Animal)this, p_148994_);
        return mob;
    }

    public abstract void runWhenBreedingTamedMob(Animal var1, Animal var2, AgeableMob var3);

    public void registerGoals() {
        if (this.canFloat()) {
            this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        }
        if (this.canPanic()) {
            this.goalSelector.addGoal(2, (Goal)new ModPanicGoal(this, this.panicSpeed()));
        }
        if (this.canAvoidEntity()) {
            this.goalSelector.addGoal(2, new ModAvoidEntityGoal<LivingEntity>(this, LivingEntity.class, 8.0f, 1.6, 1.4, entity -> this.avoidEntityPredicament((LivingEntity)entity)));
        }
        if (this.canGoBackHome()) {
            this.goalSelector.addGoal(2, (Goal)new ModGoBackHomeGoal(this, this.goHomeSpeed(), this.goBackHomeStartDistance(), this.goBackHomeStopDistance()));
        }
        if (this.followOwner()) {
            this.goalSelector.addGoal(5, (Goal)new ModFollowOwnerGoal(this, this.followOwnerSpeed(), this.followOwnerStartDistance(), this.followOwnerStopDistance()));
        }
        if (this.followLeader()) {
            // empty if block
        }
        if (this.followParent()) {
            this.goalSelector.addGoal(7, (Goal)new ModFollowParentGoal(this, this.followParentSpeed()));
        }
        if (this.canMobBreed()) {
            this.goalSelector.addGoal(8, (Goal)new ModBreedGoal(this, 1.0));
        }
        if (this.isGroundWalker()) {
            this.goalSelector.addGoal(9, (Goal)new ModWaterAvoidingRandomStrollGoal(this, this.walkGroundSpeed(), 0.5f, this.randomGroundWalkInterval()));
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_335317_) {
        super.defineSynchedData(p_335317_);
        p_335317_.define(BEHAVIOR, (Object)0);
    }

    public void addAdditionalSaveData(ValueOutput p_29422_) {
        super.addAdditionalSaveData(p_29422_);
        p_29422_.putInt("BehaviorType", this.getBehaviorType());
        p_29422_.storeNullable("HomePos", BlockPos.CODEC, (Object)this.home);
    }

    public void readAdditionalSaveData(ValueInput p_29402_) {
        super.readAdditionalSaveData(p_29402_);
        this.setBehaviorType(p_29402_.getIntOr("BehaviorType", 0));
        this.home = p_29402_.read("HomePos", BlockPos.CODEC).orElse(null);
    }

    public int getBehaviorType() {
        return (Integer)this.entityData.get(BEHAVIOR);
    }

    public void setBehaviorType(int p_30398_) {
        this.entityData.set(BEHAVIOR, (Object)p_30398_);
    }

    public float panicSpeed() {
        return 1.5f;
    }

    public float goHomeSpeed() {
        return 1.3f;
    }

    public float followParentSpeed() {
        return 1.1f;
    }

    public float goBackHomeStartDistance() {
        return 48.0f;
    }

    public float goBackHomeStopDistance() {
        return 5.0f;
    }

    public boolean canTeleportHome() {
        return true;
    }

    public boolean teleportHome() {
        if (this.canTeleportHome()) {
            LivingEntity livingentity = this.getOwner();
            return livingentity != null && this.distanceToSqr((Entity)this.getOwner()) >= (double)(this.goBackHomeStartDistance() * this.goBackHomeStartDistance());
        }
        return false;
    }

    public abstract boolean canGoBackHome();

    public float followOwnerSpeed() {
        return 1.25f;
    }

    public float followOwnerStartDistance() {
        return 10.0f;
    }

    public float followOwnerStopDistance() {
        return 2.0f;
    }

    public abstract boolean followOwner();

    public boolean teleportToOwner() {
        if (this.canTeleportToOwner()) {
            LivingEntity livingentity = this.getOwner();
            return livingentity != null && this.distanceToSqr((Entity)this.getOwner()) >= (double)this.teleportToOwnerDistance();
        }
        return false;
    }

    public abstract boolean canTeleportToOwner();

    public int teleportToOwnerDistance() {
        return 144;
    }

    public boolean isPersistenceRequired() {
        return this.isTame() || this.hasCustomName() || this.isPersistent();
    }

    public boolean requiresCustomPersistence() {
        return this.isTame() || this.hasCustomName() || this.isPersistent();
    }

    public boolean removeWhenFarAway(double p_452414_) {
        if (this.isTame()) {
            return false;
        }
        return !this.isPersistent() && !this.hasCustomName();
    }

    public void tryToTeleportToOwner() {
        LivingEntity livingentity = this.getOwner();
        if (livingentity != null) {
            this.teleportToAroundBlockPos(livingentity.blockPosition());
        }
    }

    public void teleportToAroundBlockPos(BlockPos p_342611_) {
        for (int i = 0; i < 10; ++i) {
            int j = this.random.nextIntBetweenInclusive(-3, 3);
            int k = this.random.nextIntBetweenInclusive(-3, 3);
            if (Math.abs(j) < 2 && Math.abs(k) < 2) continue;
            int l = this.random.nextIntBetweenInclusive(-1, 1);
            if (!this.maybeTeleportTo(p_342611_.getX() + j, p_342611_.getY() + l, p_342611_.getZ() + k)) continue;
            return;
        }
    }

    public boolean maybeTeleportTo(int p_344380_, int p_344602_, int p_344979_) {
        if (!this.canTeleportTo(new BlockPos(p_344380_, p_344602_, p_344979_))) {
            return false;
        }
        this.snapTo((double)p_344380_ + 0.5, p_344602_, (double)p_344979_ + 0.5, this.getYRot(), this.getXRot());
        this.navigation.stop();
        return true;
    }

    public boolean canTeleportTo(BlockPos p_342572_) {
        PathType pathtype = WalkNodeEvaluator.getPathTypeStatic((Mob)this, (BlockPos)p_342572_);
        if (pathtype != PathType.WALKABLE) {
            return false;
        }
        BlockState blockstate = this.level().getBlockState(p_342572_.below());
        if (!this.canTeleportToOwner() && blockstate.getBlock() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = p_342572_.subtract((Vec3i)this.blockPosition());
        return this.level().noCollision((Entity)this, this.getBoundingBox().move(blockpos));
    }

    protected float getSoundVolume() {
        return this.getAnimalSoundVolume();
    }

    public int tameChance() {
        return 1;
    }

    public abstract boolean sitAfterTaming();

    public void tryToTame(Player p_336244_) {
        if (this.random.nextInt(this.tameChance()) == 0) {
            if (this.sitAfterTaming()) {
                this.setBehaviorType(4);
            }
            this.tame(p_336244_);
            this.navigation.stop();
            this.setTarget(null);
            this.level().broadcastEntityEvent((Entity)this, (byte)7);
        } else {
            this.level().broadcastEntityEvent((Entity)this, (byte)6);
        }
    }

    public boolean useDefaultMobInteract() {
        return true;
    }

    public float healAmount(float defaultFromFood) {
        return defaultFromFood;
    }

    public InteractionResult mobInteract(Player p_30412_, InteractionHand p_30413_) {
        if (this.useDefaultMobInteract()) {
            ItemStack itemstack = p_30412_.getItemInHand(p_30413_);
            if (this.isTame()) {
                if (this.isFood(itemstack)) {
                    float f;
                    this.usePlayerItem(p_30412_, p_30413_, itemstack);
                    FoodProperties foodproperties = (FoodProperties)itemstack.get(DataComponents.FOOD);
                    float f2 = f = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    if (this.level() instanceof ServerLevel) {
                        this.level().broadcastEntityEvent((Entity)this, (byte)10);
                        this.runWhenEatingOnServer();
                        if (this.getHealth() < this.getMaxHealth()) {
                            this.heal(this.healAmount(2.0f * f));
                        }
                    }
                    return super.mobInteract(p_30412_, p_30413_);
                }
                InteractionResult interactionresult = super.mobInteract(p_30412_, p_30413_);
                if (!interactionresult.consumesAction() && this.isOwnedBy((LivingEntity)p_30412_)) {
                    this.jumping = false;
                    this.navigation.stop();
                    this.setTarget(null);
                    if (this.level() instanceof ServerLevel) {
                        int i = this.getBehaviorType();
                        if (i < 3) {
                            this.setBehaviorType(4);
                            this.level().broadcastEntityEvent((Entity)this, (byte)13);
                            this.runWhenSittingOnServer();
                        } else if (i == 4) {
                            this.setBehaviorType(6);
                            this.level().broadcastEntityEvent((Entity)this, (byte)14);
                            this.runWhenFollowingOwnerOnServer();
                        } else {
                            this.home = this.blockPosition();
                            this.setBehaviorType(0);
                            this.level().broadcastEntityEvent((Entity)this, (byte)5);
                            this.runWhenWanderingOnServer();
                        }
                    }
                    return InteractionResult.SUCCESS.withoutItem();
                }
                return interactionresult;
            }
            if (!this.level().isClientSide() && this.isFood(itemstack)) {
                itemstack.consume(1, (LivingEntity)p_30412_);
                this.tryToTame(p_30412_);
                return InteractionResult.SUCCESS_SERVER;
            }
            return super.mobInteract(p_30412_, p_30413_);
        }
        return super.mobInteract(p_30412_, p_30413_);
    }

    public void handleEntityEvent(byte value) {
        if (value == 8) {
            this.runWhenMakingSoundOnClient();
        } else if (value == 10) {
            this.runWhenEatingOnClient();
        } else if (value == 13) {
            this.setBehaviorType(4);
            this.runWhenSittingOnClient();
        } else if (value == 14) {
            this.setBehaviorType(6);
            this.runWhenFollowingOwnerOnClient();
        } else if (value == 5) {
            this.setBehaviorType(0);
            this.runWhenWanderingOnClient();
        } else {
            super.handleEntityEvent(value);
        }
    }

    public abstract void runWhenSittingOnClient();

    public abstract void runWhenWanderingOnClient();

    public abstract void runWhenFollowingOwnerOnClient();

    public void runWhenSittingOnServer() {
    }

    public void runWhenWanderingOnServer() {
    }

    public void runWhenFollowingOwnerOnServer() {
    }

    public boolean wantsToAttack(LivingEntity enemy, LivingEntity owner) {
        TamableAnimal tamableanimal;
        AbstractHorse abstracthorse;
        if (enemy == null) {
            return false;
        }
        if (enemy instanceof Creeper || enemy instanceof Ghast || enemy instanceof ArmorStand) {
            return false;
        }
        if (enemy instanceof DefaultTamableAnimal) {
            DefaultTamableAnimal mob = (DefaultTamableAnimal)enemy;
            return !mob.isTame() || mob.getOwner() != owner;
        }
        if (enemy instanceof Player && this.isTame() && this.getOwner() == enemy) {
            return false;
        }
        if (enemy instanceof Player) {
            Player player1;
            Player player = (Player)enemy;
            if (owner instanceof Player && !(player1 = (Player)owner).canHarmPlayer(player)) {
                return false;
            }
        }
        if (enemy instanceof AbstractHorse && (abstracthorse = (AbstractHorse)enemy).isTamed()) {
            return false;
        }
        return !(enemy instanceof TamableAnimal) || !(tamableanimal = (TamableAnimal)enemy).isTame();
    }

    public boolean hurtServer(ServerLevel level, DamageSource damagesource, float damage) {
        if (this.isInvulnerableTo(level, damagesource)) {
            return false;
        }
        if (this.getBehaviorType() == 4) {
            this.setBehaviorType(this.isTame() ? 6 : 0);
        }
        if (this.getBehaviorType() == 6) {
            this.level().broadcastEntityEvent((Entity)this, (byte)14);
        } else if (this.getBehaviorType() == 0) {
            this.level().broadcastEntityEvent((Entity)this, (byte)5);
        }
        this.runWhenAttackedOnServer(level, damagesource, damage);
        return super.hurtServer(level, damagesource, damage);
    }

    public void runWhenAttackedOnServer(ServerLevel level, DamageSource damagesource, float damage) {
        if (this.hurtSound() != null) {
            this.playSound(this.hurtSound(), this.getSoundVolume(), this.getVoicePitch());
        }
        this.level().broadcastEntityEvent((Entity)this, (byte)8);
    }

    public boolean causeFallDamage(double p_393354_, float p_147187_, DamageSource p_147189_) {
        return this.canBeDamagedFromFalling();
    }

    public boolean checkSpawnObstruction(LevelReader p_455089_) {
        if (this.canSpawnAnywhere()) {
            return p_455089_.isUnobstructed((Entity)this);
        }
        return super.checkSpawnObstruction(p_455089_);
    }

    public boolean animationEnded(ModAnimationState state, float animLength) {
        return (float)state.getTimeInMillis(this.tickCount) > animLength * 1000.0f;
    }

    public boolean unableToMoveToTheOwner() {
        return this.isOrderedToSit() || this.isPassenger() || this.mayBeLeashed() || this.getOwner() != null && this.getOwner().isSpectator();
    }
}

