/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.libs.entity.tamable;

import aquariusplayz.libs.entity.interfaces.IVariant;
import aquariusplayz.libs.entity.tamable.NeutralTamableAnimal;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public abstract class NeutralVariantTamableAnimal
extends NeutralTamableAnimal
implements IVariant {
    private static final EntityDataAccessor<Integer> BODY_VARIANT = SynchedEntityData.defineId(NeutralVariantTamableAnimal.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public NeutralVariantTamableAnimal(EntityType<? extends NeutralVariantTamableAnimal> p_29362_, Level p_29363_) {
        super((EntityType<? extends NeutralTamableAnimal>)p_29362_, p_29363_);
    }

    public abstract int maxBodyVariant();

    public abstract boolean hasRandomVariant();

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_146746_, DifficultyInstance p_146747_, EntitySpawnReason p_366700_, SpawnGroupData p_146749_) {
        if (this.hasRandomVariant()) {
            this.setBodyVariant(this.getRandom().nextInt(this.maxBodyVariant()));
        }
        return super.finalizeSpawn(p_146746_, p_146747_, p_366700_, p_146749_);
    }

    public NeutralVariantTamableAnimal getBreedOffspring(ServerLevel p_148993_, AgeableMob p_148994_) {
        NeutralVariantTamableAnimal mob = (NeutralVariantTamableAnimal)super.getBreedOffspring(p_148993_, p_148994_);
        if (this.hasRandomVariant()) {
            mob.setBodyVariant(this.getRandom().nextInt(this.maxBodyVariant()));
        }
        return mob;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_335317_) {
        super.defineSynchedData(p_335317_);
        p_335317_.define(BODY_VARIANT, (Object)this.defaultBodyVariant());
    }

    @Override
    public void addAdditionalSaveData(ValueOutput p_29422_) {
        super.addAdditionalSaveData(p_29422_);
        p_29422_.putInt("MobBodyVariant", this.getBodyVariant());
    }

    @Override
    public void readAdditionalSaveData(ValueInput p_29402_) {
        super.readAdditionalSaveData(p_29402_);
        this.setBodyVariant(p_29402_.getIntOr("MobBodyVariant", this.defaultBodyVariant()));
    }

    public int getBodyVariant() {
        return (Integer)this.entityData.get(BODY_VARIANT);
    }

    public void setBodyVariant(int p_30398_) {
        this.entityData.set(BODY_VARIANT, (Object)p_30398_);
    }
}

