/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.moreunique.zombies.mixin;

import aquariusplayz.moreunique.zombies.IZombie;
import aquariusplayz.moreunique.zombies.ModSetup;
import aquariusplayz.moreunique.zombies.config.ModConfigs;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.attachment.AttachmentType;
import org.apache.commons.lang3.math.NumberUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Zombie.class}, remap=false)
public abstract class ZombieMixin
extends Monster
implements IZombie {
    ItemStack emptyItem = new ItemStack((ItemLike)Items.AIR);
    public int[] ID_LIST = new int[ModConfigs.maxItemOnZombie];
    private static final String defaultIDList = ZombieMixin.createIDList(ModConfigs.maxItemOnZombie);

    private static String createIDList(int maxid) {
        Object tempIDList = "";
        for (int i = 0; i < maxid; ++i) {
            tempIDList = (String)tempIDList + "0" + (i == maxid - 1 ? "" : ";");
        }
        return tempIDList;
    }

    public ZombieMixin(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    public int checkId(List<Integer> temptList, int tries, int id) {
        int newid = id;
        for (int i = 0; i < tries; ++i) {
            if (temptList.contains(id)) {
                // empty if block
            }
            this.random.nextInt(34);
        }
        return newid;
    }

    @Inject(at={@At(value="RETURN")}, method={"finalizeSpawn"})
    public void finalizeSpawn(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, EntitySpawnReason entitySpawnReason, SpawnGroupData spawnGroupData, CallbackInfoReturnable<SpawnGroupData> cir) {
        if (this.isBaby()) {
            return;
        }
        Object idlistdata = "";
        ArrayList<Integer> temptList = new ArrayList<Integer>();
        for (int i = 0; i < ModConfigs.maxItemOnZombie; ++i) {
            Supplier<AttachmentType<ItemStack>> type;
            int id = this.random.nextInt(34);
            if (temptList.contains(id)) {
                for (int k = 0; k < 5; ++k) {
                    id = this.random.nextInt(34);
                    if (temptList.contains(id)) continue;
                    temptList.add(id);
                    break;
                }
            } else {
                temptList.add(id);
            }
            idlistdata = (String)idlistdata + id + (i == ModConfigs.maxItemOnZombie - 1 ? "" : ";");
            Item newitem = Items.AIR;
            int chance = this.getRandom().nextInt(ModConfigs.NO_ITEM_CHANCE + ModConfigs.RANDOM_COMMON_ITEM_CHANCE + ModConfigs.RANDOM_UNCOMMON_ITEM_CHANCE + ModConfigs.RANDOM_RARE_ITEM_CHANCE + ModConfigs.RANDOM_EPIC_ITEM_CHANCE);
            if (chance < ModConfigs.RANDOM_EPIC_ITEM_CHANCE) {
                newitem = this.getRandomZombieItem(ModSetup.EPIC_ITEM);
            } else if (chance < ModConfigs.RANDOM_EPIC_ITEM_CHANCE + ModConfigs.RANDOM_RARE_ITEM_CHANCE) {
                newitem = this.getRandomZombieItem(ModSetup.RARE_ITEM);
            } else if (chance < ModConfigs.RANDOM_EPIC_ITEM_CHANCE + ModConfigs.RANDOM_RARE_ITEM_CHANCE + ModConfigs.RANDOM_UNCOMMON_ITEM_CHANCE) {
                newitem = this.getRandomZombieItem(ModSetup.UNCOMMON_ITEM);
            } else if (chance < ModConfigs.RANDOM_EPIC_ITEM_CHANCE + ModConfigs.RANDOM_RARE_ITEM_CHANCE + ModConfigs.RANDOM_UNCOMMON_ITEM_CHANCE + ModConfigs.RANDOM_COMMON_ITEM_CHANCE) {
                newitem = this.getRandomZombieItem(ModSetup.COMMON_ITEM);
            }
            Supplier<AttachmentType<ItemStack>> supplier = id == 0 ? ModSetup.ITEM_STACK_DATA_1 : (type = id == 1 ? ModSetup.ITEM_STACK_DATA_2 : ModSetup.ITEM_STACK_DATA_3);
            if (newitem == Items.AIR) continue;
            this.setData(type, new ItemStack((ItemLike)newitem));
            this.setData(ModSetup.ID_LIST_DATA, idlistdata);
        }
        this.setData(ModSetup.ID_LIST_DATA, idlistdata);
    }

    public Item getRandomZombieItem(TagKey<Item> tag) {
        Object object;
        Iterable itemsInTag = BuiltInRegistries.ITEM.getTagOrEmpty(tag);
        Object[] list = Iterables.toArray((Iterable)itemsInTag, Object.class);
        int length = list.length;
        if (length > 0 && (object = list[this.getRandom().nextInt(length)]) instanceof Holder) {
            Holder holder = (Holder)object;
            return (Item)holder.value();
        }
        return Items.AIR;
    }

    @Inject(at={@At(value="RETURN")}, method={"dropCustomDeathLoot"})
    public void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource damageSource, boolean bl, CallbackInfo ci) {
        for (int i = 0; i < ModConfigs.maxItemOnZombie; ++i) {
            if (this.getZombieItem(i) == null || this.getZombieItem(i).isEmpty()) continue;
            int chance = ModConfigs.COMMON_ITEM_DROP_CHANCE_ON_DEATH;
            if (this.getZombieItem(i).is(ModSetup.UNCOMMON_ITEM)) {
                chance = ModConfigs.UNCOMMON_ITEM_DROP_CHANCE_ON_DEATH;
            } else if (this.getZombieItem(i).is(ModSetup.RARE_ITEM)) {
                chance = ModConfigs.RARE_ITEM_DROP_CHANCE_ON_DEATH;
            } else if (this.getZombieItem(i).is(ModSetup.EPIC_ITEM)) {
                chance = ModConfigs.EPIC_ITEM_DROP_CHANCE_ON_DEATH;
            }
            if (this.random.nextInt(100) >= chance || this.getZombieItem(i).is(Items.AIR)) continue;
            this.spawnAtLocation((ServerLevel)this.level(), this.getZombieItem(i));
        }
    }

    public String getZombieIDList() {
        return (String)this.getData(ModSetup.ID_LIST_DATA);
    }

    @Override
    public ItemStack getZombieItem(int id) {
        return (ItemStack)this.getData(id == 0 ? ModSetup.ITEM_STACK_DATA_1 : (id == 1 ? ModSetup.ITEM_STACK_DATA_2 : ModSetup.ITEM_STACK_DATA_3));
    }

    @Override
    public int[] getIDList() {
        String[] newList;
        if (this.getZombieIDList() != null && this.getZombieIDList().contains(";") && this.ID_LIST.length >= (newList = this.getZombieIDList().split(";")).length) {
            for (int j = 0; j < newList.length; ++j) {
                if (!NumberUtils.isCreatable((String)newList[j])) continue;
                this.ID_LIST[j] = NumberUtils.createInteger((String)newList[j]);
            }
        }
        return this.ID_LIST;
    }
}

