/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.libs.entity.tamable.goals;

import aquariusplayz.libs.entity.tamable.DefaultTamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.PathType;

public class ModGoBackHomeGoal
extends Goal {
    private final DefaultTamableAnimal tamable;
    private final double speedModifier;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private final float startDistance;
    private float oldWaterCost;

    public ModGoBackHomeGoal(DefaultTamableAnimal mob, double speed, float start, float stop) {
        this.tamable = mob;
        this.speedModifier = speed;
        this.navigation = mob.getNavigation();
        this.startDistance = start;
        this.stopDistance = stop;
    }

    public boolean canUse() {
        if (this.tamable.getBehaviorType() == 4 || this.tamable.getBehaviorType() == 6) {
            return false;
        }
        if (this.tamable.home == null) {
            return false;
        }
        if (this.tamable.distanceToSqr(this.tamable.home.getCenter()) <= (double)(this.stopDistance * this.stopDistance)) {
            return false;
        }
        return this.tamable.distanceToSqr(this.tamable.home.getCenter()) > (double)(this.startDistance * this.startDistance);
    }

    public boolean canContinueToUse() {
        if (this.tamable.getBehaviorType() == 4 || this.tamable.getBehaviorType() == 6) {
            return false;
        }
        if (this.navigation.isDone()) {
            return false;
        }
        if (this.tamable.home == null) {
            return false;
        }
        if (this.tamable.distanceToSqr(this.tamable.home.getCenter()) <= (double)(this.stopDistance * this.stopDistance)) {
            return false;
        }
        return this.tamable.distanceToSqr(this.tamable.home.getCenter()) > (double)(this.startDistance * this.startDistance);
    }

    public void start() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.tamable.getPathfindingMalus(PathType.WATER);
        this.tamable.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public void stop() {
        this.tamable.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
    }

    public void tick() {
        boolean flag = this.tamable.teleportHome();
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.adjustedTickDelay(10);
            if (flag) {
                this.tamable.tryToTeleportToOwner();
            } else if (this.tamable.home != null) {
                this.navigation.moveTo((double)this.tamable.home.getX(), (double)this.tamable.home.getY(), (double)this.tamable.home.getZ(), this.speedModifier);
            }
        }
    }
}

