/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.libs.entity.tamable;

import aquariusplayz.libs.entity.interfaces.IAnimal;
import aquariusplayz.libs.entity.tamable.goals.ModAvoidEntityGoal;
import aquariusplayz.libs.entity.tamable.goals.ModBreedGoal;
import aquariusplayz.libs.entity.tamable.goals.ModFollowOwnerGoal;
import aquariusplayz.libs.entity.tamable.goals.ModFollowParentGoal;
import aquariusplayz.libs.entity.tamable.goals.ModGoBackHomeGoal;
import aquariusplayz.libs.entity.tamable.goals.ModPanicGoal;
import aquariusplayz.libs.entity.tamable.goals.ModWaterAvoidingRandomStrollGoal;
import aquariusplayz.libs.helper.ModAnimationState;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_14;
import net.minecraft.class_1429;
import net.minecraft.class_1496;
import net.minecraft.class_1531;
import net.minecraft.class_1548;
import net.minecraft.class_1571;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_4174;
import net.minecraft.class_4538;
import net.minecraft.class_7;
import net.minecraft.class_9334;

public abstract class DefaultTamableAnimal
extends class_1321
implements IAnimal {
    private static final class_2940<Integer> BEHAVIOR = class_2945.method_12791(DefaultTamableAnimal.class, (class_2941)class_2943.field_13327);
    public class_2338 home;
    public int lastIdleSoundTick;

    public DefaultTamableAnimal(class_1299<? extends class_1321> p_27557_, class_1937 p_27558_) {
        super(p_27557_, p_27558_);
        this.method_6173(false, false);
    }

    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().method_8608()) {
            this.runBehaviorsOnServer((class_3218)this.method_37908());
            this.playIdleSound();
        } else {
            this.runBehaviorsOnClient(this.method_37908());
        }
    }

    @Override
    public void playIdleSound() {
        if (this.idleSound(0) != null) {
            if (this.lastIdleSoundTick > 0) {
                --this.lastIdleSoundTick;
            }
            if (this.method_59922().method_43048(this.playIdleSoundChance()) == 0 && this.lastIdleSoundTick <= 0 && this.canPlayIdleSound()) {
                this.method_5783(this.idleSound(0), this.method_6107(), this.method_6017());
                this.method_37908().method_8421((class_1297)this, (byte)8);
                this.lastIdleSoundTick = 20 * this.idleSoundInterval();
            }
        }
    }

    @Override
    public int playIdleSoundChance() {
        return 200;
    }

    @Override
    public int idleSoundInterval() {
        return this.method_59922().method_43048(20) + 10;
    }

    public class_1296 method_5613(class_3218 p_148993_, class_1296 p_148994_) {
        DefaultTamableAnimal mob = (DefaultTamableAnimal)this.method_5864().method_5883((class_1937)p_148993_, class_3730.field_16466);
        if (this.method_6181()) {
            mob.method_66288(this.method_66287());
            mob.method_6173(true, true);
            this.runWhenBreedingTamedMob((class_1429)mob, (class_1429)this, p_148994_);
        }
        this.runWhenBreeding((class_1429)mob, (class_1429)this, p_148994_);
        return mob;
    }

    public abstract void runWhenBreedingTamedMob(class_1429 var1, class_1429 var2, class_1296 var3);

    public void method_5959() {
        if (this.canFloat()) {
            this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        }
        if (this.canPanic()) {
            this.field_6201.method_6277(2, (class_1352)new ModPanicGoal(this, this.panicSpeed()));
        }
        if (this.canAvoidEntity()) {
            this.field_6201.method_6277(2, new ModAvoidEntityGoal<class_1309>(this, class_1309.class, 8.0f, 1.6, 1.4, entity -> this.avoidEntityPredicament((class_1309)entity)));
        }
        if (this.canGoBackHome()) {
            this.field_6201.method_6277(2, (class_1352)new ModGoBackHomeGoal(this, this.goHomeSpeed(), this.goBackHomeStartDistance(), this.goBackHomeStopDistance()));
        }
        if (this.followOwner()) {
            this.field_6201.method_6277(5, (class_1352)new ModFollowOwnerGoal(this, this.followOwnerSpeed(), this.followOwnerStartDistance(), this.followOwnerStopDistance()));
        }
        if (this.followLeader()) {
            // empty if block
        }
        if (this.followParent()) {
            this.field_6201.method_6277(7, (class_1352)new ModFollowParentGoal(this, this.followParentSpeed()));
        }
        if (this.canMobBreed()) {
            this.field_6201.method_6277(8, (class_1352)new ModBreedGoal(this, 1.0));
        }
        if (this.isGroundWalker()) {
            this.field_6201.method_6277(9, (class_1352)new ModWaterAvoidingRandomStrollGoal(this, this.walkGroundSpeed(), 0.5f, this.randomGroundWalkInterval()));
        }
    }

    protected void method_5693(class_2945.class_9222 p_335317_) {
        super.method_5693(p_335317_);
        p_335317_.method_56912(BEHAVIOR, (Object)0);
    }

    public void method_5652(class_2487 p_29422_) {
        super.method_5652(p_29422_);
        p_29422_.method_10569("BehaviorType", this.getBehaviorType());
        p_29422_.method_68082("HomePos", class_2338.field_25064, (Object)this.home);
    }

    public void method_5749(class_2487 p_29402_) {
        super.method_5749(p_29402_);
        this.setBehaviorType(p_29402_.method_68083("BehaviorType", 0));
        this.home = p_29402_.method_67491("HomePos", class_2338.field_25064).orElse(null);
    }

    public int getBehaviorType() {
        return (Integer)this.field_6011.method_12789(BEHAVIOR);
    }

    public void setBehaviorType(int p_30398_) {
        this.field_6011.method_12778(BEHAVIOR, (Object)p_30398_);
    }

    public float panicSpeed() {
        return 1.5f;
    }

    public float goHomeSpeed() {
        return 1.3f;
    }

    public float followParentSpeed() {
        return 1.1f;
    }

    public float goBackHomeStartDistance() {
        return 48.0f;
    }

    public float goBackHomeStopDistance() {
        return 5.0f;
    }

    public boolean canTeleportHome() {
        return true;
    }

    public boolean teleportHome() {
        if (this.canTeleportHome()) {
            class_1309 livingentity = this.method_35057();
            return livingentity != null && this.method_5858((class_1297)this.method_35057()) >= (double)(this.goBackHomeStartDistance() * this.goBackHomeStartDistance());
        }
        return false;
    }

    public abstract boolean canGoBackHome();

    public float followOwnerSpeed() {
        return 1.25f;
    }

    public float followOwnerStartDistance() {
        return 10.0f;
    }

    public float followOwnerStopDistance() {
        return 2.0f;
    }

    public abstract boolean followOwner();

    public boolean teleportToOwner() {
        if (this.canTeleportToOwner()) {
            class_1309 livingentity = this.method_35057();
            return livingentity != null && this.method_5858((class_1297)this.method_35057()) >= (double)this.teleportToOwnerDistance();
        }
        return false;
    }

    public abstract boolean canTeleportToOwner();

    public int teleportToOwnerDistance() {
        return 144;
    }

    public boolean method_5947() {
        return this.method_6181() || this.method_16914() || this.isPersistent();
    }

    public boolean method_17326() {
        return this.method_6181() || this.method_16914() || this.isPersistent();
    }

    public boolean method_5974(double p_452414_) {
        if (this.method_6181()) {
            return false;
        }
        return !this.isPersistent() && !this.method_16914();
    }

    public void method_60713() {
        class_1309 livingentity = this.method_35057();
        if (livingentity != null) {
            this.teleportToAroundBlockPos(livingentity.method_24515());
        }
    }

    public void teleportToAroundBlockPos(class_2338 p_342611_) {
        for (int i = 0; i < 10; ++i) {
            int j = this.field_5974.method_39332(-3, 3);
            int k = this.field_5974.method_39332(-3, 3);
            if (Math.abs(j) < 2 && Math.abs(k) < 2) continue;
            int l = this.field_5974.method_39332(-1, 1);
            if (!this.maybeTeleportTo(p_342611_.method_10263() + j, p_342611_.method_10264() + l, p_342611_.method_10260() + k)) continue;
            return;
        }
    }

    public boolean maybeTeleportTo(int p_344380_, int p_344602_, int p_344979_) {
        if (!this.canTeleportTo(new class_2338(p_344380_, p_344602_, p_344979_))) {
            return false;
        }
        this.method_5808((double)p_344380_ + 0.5, p_344602_, (double)p_344979_ + 0.5, this.method_36454(), this.method_36455());
        this.field_6189.method_6340();
        return true;
    }

    public boolean canTeleportTo(class_2338 p_342572_) {
        class_7 pathtype = class_14.method_57625((class_1308)this, (class_2338)p_342572_);
        if (pathtype != class_7.field_12) {
            return false;
        }
        class_2680 blockstate = this.method_37908().method_8320(p_342572_.method_10074());
        if (!this.canTeleportToOwner() && blockstate.method_26204() instanceof class_2397) {
            return false;
        }
        class_2338 blockpos = p_342572_.method_10059((class_2382)this.method_24515());
        return this.method_37908().method_8587((class_1297)this, this.method_5829().method_996(blockpos));
    }

    protected float method_6107() {
        return this.getAnimalSoundVolume();
    }

    public int tameChance() {
        return 1;
    }

    public abstract boolean sitAfterTaming();

    public void tryToTame(class_1657 p_336244_) {
        if (this.field_5974.method_43048(this.tameChance()) == 0) {
            if (this.sitAfterTaming()) {
                this.setBehaviorType(4);
            }
            this.method_6170(p_336244_);
            this.field_6189.method_6340();
            this.method_5980(null);
            this.method_37908().method_8421((class_1297)this, (byte)7);
        } else {
            this.method_37908().method_8421((class_1297)this, (byte)6);
        }
    }

    public boolean useDefaultMobInteract() {
        return true;
    }

    public float healAmount(float defaultFromFood) {
        return defaultFromFood;
    }

    public class_1269 method_5992(class_1657 p_30412_, class_1268 p_30413_) {
        if (this.useDefaultMobInteract()) {
            class_1799 itemstack = p_30412_.method_5998(p_30413_);
            if (this.method_6181()) {
                if (this.method_6481(itemstack)) {
                    float f;
                    this.method_6475(p_30412_, p_30413_, itemstack);
                    class_4174 foodproperties = (class_4174)itemstack.method_58694(class_9334.field_50075);
                    float f2 = f = foodproperties != null ? (float)foodproperties.comp_2491() : 1.0f;
                    if (this.method_37908() instanceof class_3218) {
                        this.method_37908().method_8421((class_1297)this, (byte)10);
                        this.runWhenEatingOnServer();
                        if (this.method_6032() < this.method_6063()) {
                            this.method_6025(this.healAmount(2.0f * f));
                        }
                    }
                    return super.method_5992(p_30412_, p_30413_);
                }
                class_1269 interactionresult = super.method_5992(p_30412_, p_30413_);
                if (!interactionresult.method_23665() && this.method_6171((class_1309)p_30412_)) {
                    this.field_6282 = false;
                    this.field_6189.method_6340();
                    this.method_5980(null);
                    if (this.method_37908() instanceof class_3218) {
                        int i = this.getBehaviorType();
                        if (i < 3) {
                            this.setBehaviorType(4);
                            this.method_37908().method_8421((class_1297)this, (byte)13);
                            this.runWhenSittingOnServer();
                        } else if (i == 4) {
                            this.setBehaviorType(6);
                            this.method_37908().method_8421((class_1297)this, (byte)14);
                            this.runWhenFollowingOwnerOnServer();
                        } else {
                            this.home = this.method_24515();
                            this.setBehaviorType(0);
                            this.method_37908().method_8421((class_1297)this, (byte)5);
                            this.runWhenWanderingOnServer();
                        }
                    }
                    return class_1269.field_5812.method_61394();
                }
                return interactionresult;
            }
            if (!this.method_37908().method_8608() && this.method_6481(itemstack)) {
                itemstack.method_57008(1, (class_1309)p_30412_);
                this.tryToTame(p_30412_);
                return class_1269.field_52422;
            }
            return super.method_5992(p_30412_, p_30413_);
        }
        return super.method_5992(p_30412_, p_30413_);
    }

    public void method_5711(byte value) {
        if (value == 8) {
            this.runWhenMakingSoundOnClient();
        } else if (value == 10) {
            this.runWhenEatingOnClient();
        } else if (value == 13) {
            this.setBehaviorType(4);
            this.runWhenSittingOnClient();
        } else if (value == 14) {
            this.setBehaviorType(6);
            this.runWhenFollowingOwnerOnClient();
        } else if (value == 5) {
            this.setBehaviorType(0);
            this.runWhenWanderingOnClient();
        } else {
            super.method_5711(value);
        }
    }

    public abstract void runWhenSittingOnClient();

    public abstract void runWhenWanderingOnClient();

    public abstract void runWhenFollowingOwnerOnClient();

    public void runWhenSittingOnServer() {
    }

    public void runWhenWanderingOnServer() {
    }

    public void runWhenFollowingOwnerOnServer() {
    }

    public boolean method_6178(class_1309 enemy, class_1309 owner) {
        class_1321 tamableanimal;
        class_1496 abstracthorse;
        if (enemy == null) {
            return false;
        }
        if (enemy instanceof class_1548 || enemy instanceof class_1571 || enemy instanceof class_1531) {
            return false;
        }
        if (enemy instanceof DefaultTamableAnimal) {
            DefaultTamableAnimal mob = (DefaultTamableAnimal)enemy;
            return !mob.method_6181() || mob.method_35057() != owner;
        }
        if (enemy instanceof class_1657 && this.method_6181() && this.method_35057() == enemy) {
            return false;
        }
        if (enemy instanceof class_1657) {
            class_1657 player1;
            class_1657 player = (class_1657)enemy;
            if (owner instanceof class_1657 && !(player1 = (class_1657)owner).method_7256(player)) {
                return false;
            }
        }
        if (enemy instanceof class_1496 && (abstracthorse = (class_1496)enemy).method_6727()) {
            return false;
        }
        return !(enemy instanceof class_1321) || !(tamableanimal = (class_1321)enemy).method_6181();
    }

    public boolean method_64397(class_3218 level, class_1282 damagesource, float damage) {
        if (this.method_5679(level, damagesource)) {
            return false;
        }
        if (this.getBehaviorType() == 4) {
            this.setBehaviorType(this.method_6181() ? 6 : 0);
        }
        if (this.getBehaviorType() == 6) {
            this.method_37908().method_8421((class_1297)this, (byte)14);
        } else if (this.getBehaviorType() == 0) {
            this.method_37908().method_8421((class_1297)this, (byte)5);
        }
        this.runWhenAttackedOnServer(level, damagesource, damage);
        return super.method_64397(level, damagesource, damage);
    }

    public void runWhenAttackedOnServer(class_3218 level, class_1282 damagesource, float damage) {
        if (this.hurtSound() != null) {
            this.method_5783(this.hurtSound(), this.method_6107(), this.method_6017());
        }
        this.method_37908().method_8421((class_1297)this, (byte)8);
    }

    public boolean method_5747(double p_393354_, float p_147187_, class_1282 p_147189_) {
        return this.canBeDamagedFromFalling();
    }

    public boolean method_5957(class_4538 p_455089_) {
        if (this.canSpawnAnywhere()) {
            return p_455089_.method_8606((class_1297)this);
        }
        return super.method_5957(p_455089_);
    }

    public boolean animationEnded(ModAnimationState state, float animLength) {
        return (float)state.method_61400(this.field_6012) > animLength * 1000.0f;
    }

    public boolean unableToMoveToTheOwner() {
        return this.method_24345() || this.method_5765() || this.method_60954() || this.method_35057() != null && this.method_35057().method_7325();
    }
}

