/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.libs.entity.tamable.goals;

import aquariusplayz.libs.entity.tamable.DefaultTamableAnimal;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3;

public class ModWaterAvoidingRandomStrollGoal
extends RandomStrollGoal {
    public static final float PROBABILITY = 0.001f;
    protected final float probability;
    protected final DefaultTamableAnimal mob;
    public int reachWantedPosTimer = 0;

    public ModWaterAvoidingRandomStrollGoal(DefaultTamableAnimal p_25987_, double p_25988_) {
        this(p_25987_, p_25988_, 0.001f);
    }

    public ModWaterAvoidingRandomStrollGoal(DefaultTamableAnimal p_25990_, double p_25991_, float p_25992_) {
        super((PathfinderMob)p_25990_, p_25991_);
        this.mob = p_25990_;
        this.probability = p_25992_;
    }

    public ModWaterAvoidingRandomStrollGoal(DefaultTamableAnimal p_25990_, double p_25991_, float p_25992_, int interval) {
        super((PathfinderMob)p_25990_, p_25991_, interval);
        this.mob = p_25990_;
        this.probability = p_25992_;
    }

    public boolean canUse() {
        if (this.mob.getBehaviorType() == 4) {
            return false;
        }
        if (this.mob.getBehaviorType() == 6) {
            return super.canUse();
        }
        if (this.mob.hasControllingPassenger()) {
            return false;
        }
        if (this.mob.canMoveRandomly()) {
            Vec3 vec3;
            if (this.reachWantedPosTimer > 0) {
                --this.reachWantedPosTimer;
            }
            if (this.reachWantedPosTimer == 0) {
                this.forceTrigger = true;
            }
            if (!this.forceTrigger) {
                if (this.mob.getNoActionTime() >= 100) {
                    return false;
                }
                if (this.mob.getRandom().nextInt(ModWaterAvoidingRandomStrollGoal.reducedTickDelay((int)this.interval)) != 0) {
                    return false;
                }
            }
            if ((vec3 = this.getPosition()) == null) {
                return false;
            }
            this.wantedX = vec3.x;
            this.wantedY = vec3.y;
            this.wantedZ = vec3.z;
            this.forceTrigger = false;
            this.reachWantedPosTimer = 400;
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        if (this.mob.getBehaviorType() == 4) {
            return false;
        }
        return super.canContinueToUse();
    }

    protected Vec3 getPosition() {
        if (this.mob.isInWater()) {
            Vec3 vec3 = LandRandomPos.getPos((PathfinderMob)this.mob, (int)15, (int)7);
            return vec3 == null ? super.getPosition() : vec3;
        }
        return this.mob.getRandom().nextFloat() >= this.probability ? LandRandomPos.getPos((PathfinderMob)this.mob, (int)10, (int)7) : super.getPosition();
    }
}

