/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.moreunique.zombies;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.Item;

public class ItemRenderData {
    public Item item;
    public ModelPart part;
    public float x = 0.0f;
    public float y = 0.0f;
    public float z = 0.0f;
    public float YP = 0.0f;
    public float XP = 0.0f;
    public float ZP = 0.0f;

    public ItemRenderData(ModelPart part, Item item, float x, float y, float z, float YP, float XP, float ZP) {
        this.part = part;
        this.item = item;
        this.x = x;
        this.y = y;
        this.z = z;
        this.YP = YP;
        this.XP = XP;
        this.ZP = ZP;
    }

    public void translateAndRotate(PoseStack posestack) {
        if (this.part != null) {
            this.part.translateAndRotate(posestack);
            posestack.translate(this.x, this.y, this.z);
            posestack.mulPose(Axis.YP.rotationDegrees(this.YP));
            posestack.mulPose(Axis.XP.rotationDegrees(this.XP));
            posestack.mulPose(Axis.ZP.rotationDegrees(this.ZP));
        }
    }

    public void renderArrow(Model arrow, RenderType renderType, PoseStack posestack, int lightlevel) {
        arrow.renderToBuffer(posestack, Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(renderType), lightlevel, OverlayTexture.NO_OVERLAY);
    }

    public ItemRenderData build(HashMap<Item, ItemRenderData> hashMap) {
        hashMap.put(this.item, this);
        return this;
    }
}

