/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.libs.defaultbutton;

import aquariusplayz.libs.defaultbutton.ARGB;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;

public class ModButton {
    public String text;
    public int textColor;
    public int x;
    public int y;
    public int width;
    public int height;
    public int borderSize;
    public int hoverColor;
    public boolean changeColorOnHover = false;
    public boolean canBeClicked = false;
    public OnPress onPress;
    public boolean visible = true;
    public boolean selected = false;
    public int opacity = 255;

    public void data(String text, int textColor, int x, int y, int width, int height, int borderSize, int hoverColor, boolean changeColorOnHover, boolean canBeClicked, OnPress onPress) {
        this.text = text;
        this.textColor = textColor;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.borderSize = borderSize;
        this.hoverColor = hoverColor;
        this.changeColorOnHover = changeColorOnHover;
        this.canBeClicked = canBeClicked;
        this.onPress = onPress;
    }

    public void render(GuiGraphics gui, int mouseX, int mouseY) {
        if (this.visible) {
            Font font = Minecraft.getInstance().font;
            int screenHeight = this.height;
            int screenWidth = this.width;
            gui.fill(this.x, this.y, this.x + screenWidth, this.y + screenHeight, ARGB.color(this.opacity, 0, 0, 0));
            gui.fill(this.x + 1, this.y + 1, this.x + screenWidth - 1 - this.borderSize, this.y + screenHeight - 1 - this.borderSize, ARGB.color(this.opacity, 255, 255, 255));
            gui.fill(this.x + 1 + this.borderSize, this.y + 1 + this.borderSize, this.x + screenWidth - 1, this.y + screenHeight - 1, ARGB.color(this.opacity, 85, 85, 85));
            gui.fill(this.x + 1 + this.borderSize, this.y + 1 + this.borderSize, this.x + screenWidth - 1 - this.borderSize, this.y + screenHeight - 1 - this.borderSize, ARGB.color(this.opacity, 198, 198, 198));
            if (this.selected) {
                gui.fill(this.x + 1 + this.borderSize, this.y + 1 + this.borderSize, this.x + screenWidth - 1, this.y + screenHeight - 1, ARGB.color((int)((float)this.opacity * 0.5f), 0, 0, 0));
            } else if (this.changeColorOnHover && ModButton.isMouseOverArea(mouseX, mouseY, this.x, this.y, screenWidth, screenHeight)) {
                gui.fill(this.x + 1 + this.borderSize, this.y + 1 + this.borderSize, this.x + screenWidth - 1, this.y + screenHeight - 1, this.hoverColor);
            }
            if (!this.text.isBlank()) {
                gui.drawCenteredString(font, this.text, this.x + screenWidth / 2, this.y + 3, this.textColor);
            }
        }
    }

    public boolean clicked(double mouseX, double mouseY, int mousekeycode) {
        if (this.canBeClicked && mousekeycode == 0 && this.visible && ModButton.isMouseOverArea(mouseX, mouseY, this.x, this.y, this.width, this.height)) {
            this.onPress.onPress(this);
            return true;
        }
        return false;
    }

    public static boolean isMouseOverArea(double mouseX, double mouseY, int posX, int posY, int sizeX, int sizeY) {
        return mouseX >= (double)posX && mouseX < (double)(posX + sizeX) && mouseY >= (double)posY && mouseY < (double)(posY + sizeY);
    }

    public static interface OnPress {
        public void onPress(ModButton var1);
    }
}

