/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.libs.entity;

import aquariusplayz.libs.entity.DefaultAnimal;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.level.Level;

public abstract class NeutralAnimal
extends DefaultAnimal
implements NeutralMob {
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.defineId(NeutralAnimal.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private UUID persistentAngerTarget;

    public NeutralAnimal(EntityType<? extends NeutralAnimal> p_29362_, Level p_29363_) {
        super(p_29362_, p_29363_);
    }

    @Override
    public void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, (double)this.attackSpeed(), this.mustSeeTarget()));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, this.mustSeeTarget(), false, arg_0 -> ((NeutralAnimal)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(6, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public abstract float attackSpeed();

    public boolean mustSeeTarget() {
        return true;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide()) {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_335317_) {
        super.defineSynchedData(p_335317_);
        p_335317_.define(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag p_29422_) {
        super.addAdditionalSaveData(p_29422_);
        this.addPersistentAngerSaveData(p_29422_);
    }

    public void readAdditionalSaveData(CompoundTag p_29402_) {
        super.readAdditionalSaveData(p_29402_);
        this.readPersistentAngerSaveData(this.level(), p_29402_);
    }

    public int getRemainingPersistentAngerTime() {
        return (Integer)this.entityData.get(DATA_REMAINING_ANGER_TIME);
    }

    public void setRemainingPersistentAngerTime(int p_396897_) {
        this.entityData.set(DATA_REMAINING_ANGER_TIME, (Object)p_396897_);
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void setPersistentAngerTarget(UUID p_393236_) {
        this.persistentAngerTarget = p_393236_;
    }

    public boolean doHurtTarget(Entity target) {
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            this.runDoHurtTargetOnServer(level2, target);
        }
        return super.doHurtTarget(target);
    }

    public abstract void runDoHurtTargetOnServer(ServerLevel var1, Entity var2);

    public abstract void runDoHurtTargetOnClient();

    @Override
    public void handleEntityEvent(byte p_397414_) {
        if (p_397414_ == 4) {
            this.runDoHurtTargetOnClient();
        } else {
            super.handleEntityEvent(p_397414_);
        }
    }
}

