/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.libs.entity;

import aquariusplayz.libs.entity.DefaultAnimal;
import aquariusplayz.libs.entity.interfaces.IVariant;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public abstract class VariantAnimal
extends DefaultAnimal
implements IVariant {
    private static final EntityDataAccessor<Integer> BODY_VARIANT = SynchedEntityData.defineId(VariantAnimal.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public VariantAnimal(EntityType<? extends VariantAnimal> p_29362_, Level p_29363_) {
        super(p_29362_, p_29363_);
    }

    public abstract int maxBodyVariant();

    public abstract boolean hasRandomVariant();

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_146746_, DifficultyInstance p_146747_, MobSpawnType p_366700_, SpawnGroupData p_146749_) {
        if (this.hasRandomVariant()) {
            this.setBodyVariant(this.getRandom().nextInt(this.maxBodyVariant()));
        }
        return super.finalizeSpawn(p_146746_, p_146747_, p_366700_, p_146749_);
    }

    @Override
    public VariantAnimal getBreedOffspring(ServerLevel p_148993_, AgeableMob p_148994_) {
        VariantAnimal mob = (VariantAnimal)super.getBreedOffspring(p_148993_, p_148994_);
        if (this.hasRandomVariant()) {
            mob.setBodyVariant(this.getRandom().nextInt(this.maxBodyVariant()));
        }
        return mob;
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_335317_) {
        super.defineSynchedData(p_335317_);
        p_335317_.define(BODY_VARIANT, (Object)this.defaultBodyVariant());
    }

    public void addAdditionalSaveData(CompoundTag p_29422_) {
        super.addAdditionalSaveData(p_29422_);
        p_29422_.putInt("MobBodyVariant", this.getBodyVariant());
    }

    public void readAdditionalSaveData(CompoundTag p_29402_) {
        super.readAdditionalSaveData(p_29402_);
        this.setBodyVariant(p_29402_.getInt("MobBodyVariant"));
    }

    public int getBodyVariant() {
        return (Integer)this.entityData.get(BODY_VARIANT);
    }

    public void setBodyVariant(int p_30398_) {
        this.entityData.set(BODY_VARIANT, (Object)p_30398_);
    }
}

