/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.libs.entity.renderer.model;

import aquariusplayz.libs.helper.ModAnimationState;
import aquariusplayz.libs.helper.ModMobRenderState;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import org.joml.Vector3f;

public class DefaultAnimatedModel<T extends Mob>
extends EntityModel<T> {
    private final List<ModelPart> allParts;
    public final ModelPart root;
    public static final Vector3f ANIMATION_VECTOR_CACHE = new Vector3f();

    public DefaultAnimatedModel(ModelPart root) {
        this.root = root.getChild("root");
        this.allParts = root.getAllParts().toList();
    }

    public static PartDefinition createRootLayer(MeshDefinition meshdefinition) {
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.ZERO);
        return root;
    }

    public final ModelPart root() {
        return this.root;
    }

    public void animate(ModAnimationState p_361867_, AnimationDefinition p_365477_, float p_361961_) {
        this.animate(p_361867_, p_365477_, p_361961_, 1.0f);
    }

    public void animateWalk(AnimationDefinition p_363127_, float p_364817_, float p_364163_, float p_365350_, float p_365167_) {
        long i = (long)(p_364817_ * 50.0f * p_365350_);
        float f = Math.min(p_364163_ * p_365167_, 1.0f);
        DefaultAnimatedModel.animate(this, p_363127_, i, f, ANIMATION_VECTOR_CACHE);
    }

    public void animate(ModAnimationState p_368871_, AnimationDefinition p_365491_, float p_363110_, float p_368202_) {
        p_368871_.ifStarted(p_368242_ -> DefaultAnimatedModel.animate(this, p_365491_, (long)((float)((ModAnimationState)((Object)p_368242_)).getTimeInMillis(p_363110_) * p_368202_), 1.0f, ANIMATION_VECTOR_CACHE));
    }

    public void applyStatic(AnimationDefinition p_369884_) {
        DefaultAnimatedModel.animate(this, p_369884_, 0L, 1.0f, ANIMATION_VECTOR_CACHE);
    }

    public static Optional<ModelPart> getAnyDescendantWithName(DefaultAnimatedModel p_362391_, String p_363872_) {
        Stream stream = p_362391_.root().getAllParts().toList().stream();
        return p_363872_.equals("root") ? Optional.of(p_362391_.root()) : stream.filter(p_364767_ -> p_364767_.hasChild(p_363872_)).findFirst().map(p_366385_ -> p_366385_.getChild(p_363872_));
    }

    public static void animate(DefaultAnimatedModel p_362391_, AnimationDefinition p_232321_, long p_232322_, float p_232323_, Vector3f p_253861_) {
        float f = DefaultAnimatedModel.getElapsedSeconds(p_232321_, p_232322_);
        for (Map.Entry entry : p_232321_.boneAnimations().entrySet()) {
            Optional<ModelPart> optional = DefaultAnimatedModel.getAnyDescendantWithName(p_362391_, (String)entry.getKey());
            List list = (List)entry.getValue();
            optional.ifPresent(p_232330_ -> list.forEach(p_288241_ -> {
                Keyframe[] akeyframe = p_288241_.keyframes();
                int i = Math.max(0, Mth.binarySearch((int)0, (int)akeyframe.length, p_232315_ -> f <= akeyframe[p_232315_].timestamp()) - 1);
                int j = Math.min(akeyframe.length - 1, i + 1);
                Keyframe keyframe = akeyframe[i];
                Keyframe keyframe1 = akeyframe[j];
                float f1 = f - keyframe.timestamp();
                float f2 = j != i ? Mth.clamp((float)(f1 / (keyframe1.timestamp() - keyframe.timestamp())), (float)0.0f, (float)1.0f) : 0.0f;
                keyframe1.interpolation().apply(p_253861_, f2, akeyframe, i, j, p_232323_);
                p_288241_.target().apply(p_232330_, p_253861_);
            }));
        }
    }

    public static float getElapsedSeconds(AnimationDefinition p_232317_, long p_232318_) {
        float f = (float)p_232318_ / 1000.0f;
        return p_232317_.looping() ? f % p_232317_.lengthInSeconds() : f;
    }

    public final List<ModelPart> allParts() {
        return this.allParts;
    }

    public final void resetPose() {
        for (ModelPart modelpart : this.allParts) {
            modelpart.resetPose();
        }
    }

    public void setupAnim(ModMobRenderState<T> state) {
        this.resetPose();
    }

    public void setupAnim(T entity, float pos, float speed, float ageInTicks, float yaw, float pitch) {
        boolean bl;
        if (entity instanceof Animal) {
            Animal animal = (Animal)entity;
            bl = animal.isBaby();
        } else {
            bl = entity.isBaby();
        }
        this.setupAnim(new ModMobRenderState<T>(entity, pos, speed, ageInTicks, yaw, pitch, bl));
    }

    public void renderToBuffer(PoseStack p_103111_, VertexConsumer p_103112_, int p_103113_, int p_103114_, int p_345283_) {
        this.root.render(p_103111_, p_103112_, p_103113_, p_103114_, p_345283_);
    }
}

