/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.libs.entity;

import aquariusplayz.libs.entity.interfaces.IAnimal;
import aquariusplayz.libs.helper.ModAnimationState;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;

public abstract class DefaultAnimal
extends Animal
implements IAnimal {
    public int lastIdleSoundTick;

    public DefaultAnimal(EntityType<? extends Animal> p_27557_, Level p_27558_) {
        super(p_27557_, p_27558_);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().m_5776_()) {
            this.runBehaviorsOnServer((ServerLevel)this.m_9236_());
            this.playIdleSound();
        } else {
            this.runBehaviorsOnClient(this.m_9236_());
        }
    }

    @Override
    public void playIdleSound() {
        if (this.idleSound(0) != null) {
            if (this.lastIdleSoundTick > 0) {
                --this.lastIdleSoundTick;
            }
            if (this.m_217043_().m_188503_(this.playIdleSoundChance()) == 0 && this.lastIdleSoundTick <= 0 && this.canPlayIdleSound()) {
                this.m_5496_(this.idleSound(0), this.m_6121_(), this.m_6100_());
                this.m_9236_().m_7605_((Entity)this, (byte)8);
                this.lastIdleSoundTick = 20 * this.idleSoundInterval();
            }
        }
    }

    @Override
    public int playIdleSoundChance() {
        return 200;
    }

    @Override
    public int idleSoundInterval() {
        return this.m_217043_().m_188503_(20) + 10;
    }

    public void m_8099_() {
        if (this.canFloat()) {
            this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        }
        if (this.canPanic()) {
            this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        }
        if (this.canPanic()) {
            this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 8.0f, 1.6, 1.4, entity -> this.avoidEntityPredicament((LivingEntity)entity)));
        }
        if (this.followParent()) {
            this.f_21345_.m_25352_(7, (Goal)new FollowParentGoal((Animal)this, 1.1));
        }
        if (this.canMobBreed()) {
            this.f_21345_.m_25352_(8, (Goal)new BreedGoal((Animal)this, 1.0));
        }
        if (this.isGroundWalker()) {
            this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, (double)this.walkGroundSpeed(), (float)this.randomGroundWalkInterval()));
        }
    }

    public boolean m_21532_() {
        return this.m_8077_() || this.isPersistent();
    }

    public boolean m_8023_() {
        return this.m_8077_() || this.isPersistent();
    }

    public boolean m_6785_(double p_452414_) {
        return !this.isPersistent() && !this.m_8077_();
    }

    protected float m_6121_() {
        return this.getAnimalSoundVolume();
    }

    public DefaultAnimal getBreedOffspring(ServerLevel p_148993_, AgeableMob p_148994_) {
        DefaultAnimal mob = (DefaultAnimal)this.m_6095_().m_20615_((Level)p_148993_);
        this.runWhenBreeding(mob, this, p_148994_);
        return mob;
    }

    public boolean animationEnded(ModAnimationState state, float animLength) {
        return (float)state.getTimeInMillis(this.f_19797_) > animLength * 1000.0f;
    }

    public boolean m_6469_(DamageSource damagesource, float damage) {
        if (this.m_6673_(damagesource)) {
            return false;
        }
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            this.runWhenAttackedOnServer(level2, damagesource, damage);
        }
        return super.m_6469_(damagesource, damage);
    }

    public void runWhenAttackedOnServer(ServerLevel level, DamageSource damagesource, float damage) {
        if (this.hurtSound() != null) {
            this.m_5496_(this.hurtSound(), this.m_6121_(), this.m_6100_());
        }
        this.m_9236_().m_7605_((Entity)this, (byte)8);
    }

    public void m_7822_(byte value) {
        if (value == 8) {
            this.runWhenMakingSoundOnClient();
        } else if (value == 10) {
            this.runWhenEatingOnClient();
        } else {
            super.m_7822_(value);
        }
    }
}

