/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.libs.entity.tamable;

import aquariusplayz.libs.entity.interfaces.IAnimal;
import aquariusplayz.libs.entity.tamable.goals.ModAvoidEntityGoal;
import aquariusplayz.libs.entity.tamable.goals.ModBreedGoal;
import aquariusplayz.libs.entity.tamable.goals.ModFollowOwnerGoal;
import aquariusplayz.libs.entity.tamable.goals.ModFollowParentGoal;
import aquariusplayz.libs.entity.tamable.goals.ModGoBackHomeGoal;
import aquariusplayz.libs.entity.tamable.goals.ModPanicGoal;
import aquariusplayz.libs.entity.tamable.goals.ModWaterAvoidingRandomStrollGoal;
import aquariusplayz.libs.helper.ModAnimationState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public abstract class DefaultTamableAnimal
extends TamableAnimal
implements IAnimal {
    private static final EntityDataAccessor<Integer> BEHAVIOR = SynchedEntityData.m_135353_(DefaultTamableAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public BlockPos home;
    public int lastIdleSoundTick;

    public DefaultTamableAnimal(EntityType<? extends TamableAnimal> p_27557_, Level p_27558_) {
        super(p_27557_, p_27558_);
        this.m_7105_(false);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().m_5776_()) {
            this.runBehaviorsOnServer((ServerLevel)this.m_9236_());
            this.playIdleSound();
        } else {
            this.runBehaviorsOnClient(this.m_9236_());
        }
    }

    @Override
    public void playIdleSound() {
        if (this.idleSound(0) != null) {
            if (this.lastIdleSoundTick > 0) {
                --this.lastIdleSoundTick;
            }
            if (this.m_217043_().m_188503_(this.playIdleSoundChance()) == 0 && this.lastIdleSoundTick <= 0 && this.canPlayIdleSound()) {
                this.m_5496_(this.idleSound(0), this.m_6121_(), this.m_6100_());
                this.m_9236_().m_7605_((Entity)this, (byte)8);
                this.lastIdleSoundTick = 20 * this.idleSoundInterval();
            }
        }
    }

    @Override
    public int playIdleSoundChance() {
        return 200;
    }

    @Override
    public int idleSoundInterval() {
        return this.m_217043_().m_188503_(20) + 10;
    }

    public AgeableMob m_142606_(ServerLevel p_148993_, AgeableMob p_148994_) {
        DefaultTamableAnimal mob = (DefaultTamableAnimal)this.m_6095_().m_20615_((Level)p_148993_);
        if (this.m_21824_()) {
            mob.m_21816_(this.m_21805_());
            mob.m_7105_(true);
            this.runWhenBreedingTamedMob((Animal)mob, (Animal)this, p_148994_);
        }
        this.runWhenBreeding((Animal)mob, (Animal)this, p_148994_);
        return mob;
    }

    public abstract void runWhenBreedingTamedMob(Animal var1, Animal var2, AgeableMob var3);

    public void m_8099_() {
        if (this.canFloat()) {
            this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        }
        if (this.canPanic()) {
            this.f_21345_.m_25352_(2, (Goal)new ModPanicGoal(this, this.panicSpeed()));
        }
        if (this.canAvoidEntity()) {
            this.f_21345_.m_25352_(2, new ModAvoidEntityGoal<LivingEntity>(this, LivingEntity.class, 8.0f, 1.6, 1.4, entity -> this.avoidEntityPredicament((LivingEntity)entity)));
        }
        if (this.canGoBackHome()) {
            this.f_21345_.m_25352_(2, (Goal)new ModGoBackHomeGoal(this, this.goHomeSpeed(), this.goBackHomeStartDistance(), this.goBackHomeStopDistance()));
        }
        if (this.followOwner()) {
            this.f_21345_.m_25352_(5, (Goal)new ModFollowOwnerGoal(this, this.followOwnerSpeed(), this.followOwnerStartDistance(), this.followOwnerStopDistance()));
        }
        if (this.followLeader()) {
            // empty if block
        }
        if (this.followParent()) {
            this.f_21345_.m_25352_(7, (Goal)new ModFollowParentGoal(this, this.followParentSpeed()));
        }
        if (this.canMobBreed()) {
            this.f_21345_.m_25352_(8, (Goal)new ModBreedGoal(this, 1.0));
        }
        if (this.isGroundWalker()) {
            this.f_21345_.m_25352_(9, (Goal)new ModWaterAvoidingRandomStrollGoal(this, this.walkGroundSpeed(), 0.5f, this.randomGroundWalkInterval()));
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BEHAVIOR, (Object)0);
    }

    public void m_7380_(CompoundTag p_29422_) {
        super.m_7380_(p_29422_);
        p_29422_.m_128405_("BehaviorType", this.getBehaviorType());
        if (this.home != null) {
            p_29422_.m_128365_("HomePos", (Tag)NbtUtils.m_129224_((BlockPos)this.home));
        }
    }

    public void m_7378_(CompoundTag p_29402_) {
        super.m_7378_(p_29402_);
        this.setBehaviorType(p_29402_.m_128451_("BehaviorType"));
        this.home = null;
        if (p_29402_.m_128441_("HomePos")) {
            this.home = NbtUtils.m_129239_((CompoundTag)p_29402_.m_128469_("HivePos"));
        }
    }

    public int getBehaviorType() {
        return (Integer)this.f_19804_.m_135370_(BEHAVIOR);
    }

    public void setBehaviorType(int p_30398_) {
        this.f_19804_.m_135381_(BEHAVIOR, (Object)p_30398_);
    }

    public float panicSpeed() {
        return 1.5f;
    }

    public float goHomeSpeed() {
        return 1.3f;
    }

    public float followParentSpeed() {
        return 1.1f;
    }

    public float goBackHomeStartDistance() {
        return 48.0f;
    }

    public float goBackHomeStopDistance() {
        return 5.0f;
    }

    public boolean canTeleportHome() {
        return true;
    }

    public boolean teleportHome() {
        if (this.canTeleportHome()) {
            LivingEntity livingentity = this.m_269323_();
            return livingentity != null && this.m_20280_((Entity)this.m_269323_()) >= (double)(this.goBackHomeStartDistance() * this.goBackHomeStartDistance());
        }
        return false;
    }

    public abstract boolean canGoBackHome();

    public float followOwnerSpeed() {
        return 1.25f;
    }

    public float followOwnerStartDistance() {
        return 10.0f;
    }

    public float followOwnerStopDistance() {
        return 2.0f;
    }

    public abstract boolean followOwner();

    public boolean teleportToOwner() {
        if (this.canTeleportToOwner()) {
            LivingEntity livingentity = this.m_269323_();
            return livingentity != null && this.m_20280_((Entity)this.m_269323_()) >= (double)this.teleportToOwnerDistance();
        }
        return false;
    }

    public abstract boolean canTeleportToOwner();

    public int teleportToOwnerDistance() {
        return 144;
    }

    public boolean m_21532_() {
        return this.m_21824_() || this.m_8077_() || this.isPersistent();
    }

    public boolean m_8023_() {
        return this.m_21824_() || this.m_8077_() || this.isPersistent();
    }

    public boolean m_6785_(double p_452414_) {
        if (this.m_21824_()) {
            return false;
        }
        return !this.isPersistent() && !this.m_8077_();
    }

    public void tryToTeleportToOwner() {
        LivingEntity livingentity = this.m_269323_();
        if (livingentity != null) {
            this.teleportToAroundBlockPos(livingentity.m_20183_());
        }
    }

    public void teleportToAroundBlockPos(BlockPos p_342611_) {
        for (int i = 0; i < 10; ++i) {
            int j = this.f_19796_.m_216332_(-3, 3);
            int k = this.f_19796_.m_216332_(-3, 3);
            if (Math.abs(j) < 2 && Math.abs(k) < 2) continue;
            int l = this.f_19796_.m_216332_(-1, 1);
            if (!this.maybeTeleportTo(p_342611_.m_123341_() + j, p_342611_.m_123342_() + l, p_342611_.m_123343_() + k)) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int p_344380_, int p_344602_, int p_344979_) {
        if (!this.canTeleportTo(new BlockPos(p_344380_, p_344602_, p_344979_))) {
            return false;
        }
        this.m_7678_((double)p_344380_ + 0.5, p_344602_, (double)p_344979_ + 0.5, this.m_146908_(), this.m_146909_());
        this.f_21344_.m_26573_();
        return true;
    }

    public boolean canTeleportTo(BlockPos p_342572_) {
        BlockPathTypes pathtype = WalkNodeEvaluator.m_77604_((BlockGetter)this.m_9236_(), (BlockPos.MutableBlockPos)p_342572_.m_122032_());
        if (pathtype != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockState blockstate = this.m_9236_().m_8055_(p_342572_.m_7495_());
        if (!this.canTeleportToOwner() && blockstate.m_60734_() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = p_342572_.m_121996_((Vec3i)this.m_20183_());
        return this.m_9236_().m_45756_((Entity)this, this.m_20191_().m_82338_(blockpos));
    }

    protected float m_6121_() {
        return this.getAnimalSoundVolume();
    }

    public int tameChance() {
        return 1;
    }

    public abstract boolean sitAfterTaming();

    public void tryToTame(Player p_336244_) {
        if (this.f_19796_.m_188503_(this.tameChance()) == 0) {
            if (this.sitAfterTaming()) {
                this.setBehaviorType(4);
            }
            this.m_21828_(p_336244_);
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            this.m_9236_().m_7605_((Entity)this, (byte)7);
        } else {
            this.m_9236_().m_7605_((Entity)this, (byte)6);
        }
    }

    public boolean useDefaultMobInteract() {
        return true;
    }

    public float healAmount(float defaultFromFood) {
        return defaultFromFood;
    }

    public InteractionResult m_6071_(Player p_30412_, InteractionHand p_30413_) {
        if (this.useDefaultMobInteract()) {
            ItemStack itemstack = p_30412_.m_21120_(p_30413_);
            if (this.m_21824_()) {
                if (this.m_6898_(itemstack)) {
                    float f;
                    this.m_142075_(p_30412_, p_30413_, itemstack);
                    FoodProperties foodproperties = itemstack.getFoodProperties((LivingEntity)this);
                    float f2 = f = foodproperties != null ? (float)foodproperties.m_38744_() : 1.0f;
                    if (this.m_9236_() instanceof ServerLevel) {
                        this.m_9236_().m_7605_((Entity)this, (byte)10);
                        this.runWhenEatingOnServer();
                        if (this.m_21223_() < this.m_21233_()) {
                            this.m_5634_(this.healAmount(2.0f * f));
                        }
                    }
                    return super.m_6071_(p_30412_, p_30413_);
                }
                InteractionResult interactionresult = super.m_6071_(p_30412_, p_30413_);
                if (!interactionresult.m_19077_() && this.m_21830_((LivingEntity)p_30412_)) {
                    this.f_20899_ = false;
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                    if (this.m_9236_() instanceof ServerLevel) {
                        int i = this.getBehaviorType();
                        if (i < 3) {
                            this.setBehaviorType(4);
                            this.m_9236_().m_7605_((Entity)this, (byte)13);
                            this.runWhenSittingOnServer();
                        } else if (i == 4) {
                            this.setBehaviorType(6);
                            this.m_9236_().m_7605_((Entity)this, (byte)14);
                            this.runWhenFollowingOwnerOnServer();
                        } else {
                            this.home = this.m_20183_();
                            this.setBehaviorType(0);
                            this.m_9236_().m_7605_((Entity)this, (byte)5);
                            this.runWhenWanderingOnServer();
                        }
                    }
                    return InteractionResult.SUCCESS;
                }
                return interactionresult;
            }
            if (!this.m_9236_().m_5776_() && this.m_6898_(itemstack)) {
                if (!p_30412_.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.tryToTame(p_30412_);
                return InteractionResult.SUCCESS;
            }
            return super.m_6071_(p_30412_, p_30413_);
        }
        return super.m_6071_(p_30412_, p_30413_);
    }

    public void m_7822_(byte value) {
        if (value == 8) {
            this.runWhenMakingSoundOnClient();
        } else if (value == 10) {
            this.runWhenEatingOnClient();
        } else if (value == 13) {
            this.setBehaviorType(4);
            this.runWhenSittingOnClient();
        } else if (value == 14) {
            this.setBehaviorType(6);
            this.runWhenFollowingOwnerOnClient();
        } else if (value == 5) {
            this.setBehaviorType(0);
            this.runWhenWanderingOnClient();
        } else {
            super.m_7822_(value);
        }
    }

    public abstract void runWhenSittingOnClient();

    public abstract void runWhenWanderingOnClient();

    public abstract void runWhenFollowingOwnerOnClient();

    public void runWhenSittingOnServer() {
    }

    public void runWhenWanderingOnServer() {
    }

    public void runWhenFollowingOwnerOnServer() {
    }

    public boolean m_7757_(LivingEntity enemy, LivingEntity owner) {
        TamableAnimal tamableanimal;
        AbstractHorse abstracthorse;
        if (enemy == null) {
            return false;
        }
        if (enemy instanceof Creeper || enemy instanceof Ghast || enemy instanceof ArmorStand) {
            return false;
        }
        if (enemy instanceof DefaultTamableAnimal) {
            DefaultTamableAnimal mob = (DefaultTamableAnimal)enemy;
            return !mob.m_21824_() || mob.m_269323_() != owner;
        }
        if (enemy instanceof Player && this.m_21824_() && this.m_269323_() == enemy) {
            return false;
        }
        if (enemy instanceof Player) {
            Player player1;
            Player player = (Player)enemy;
            if (owner instanceof Player && !(player1 = (Player)owner).m_7099_(player)) {
                return false;
            }
        }
        if (enemy instanceof AbstractHorse && (abstracthorse = (AbstractHorse)enemy).m_30614_()) {
            return false;
        }
        return !(enemy instanceof TamableAnimal) || !(tamableanimal = (TamableAnimal)enemy).m_21824_();
    }

    public boolean m_6469_(DamageSource damagesource, float damage) {
        if (this.m_6673_(damagesource)) {
            return false;
        }
        if (this.getBehaviorType() == 4) {
            this.setBehaviorType(this.m_21824_() ? 6 : 0);
        }
        if (this.getBehaviorType() == 6) {
            this.m_9236_().m_7605_((Entity)this, (byte)14);
        } else if (this.getBehaviorType() == 0) {
            this.m_9236_().m_7605_((Entity)this, (byte)5);
        }
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            this.runWhenAttackedOnServer(level2, damagesource, damage);
        }
        return super.m_6469_(damagesource, damage);
    }

    public void runWhenAttackedOnServer(ServerLevel level, DamageSource damagesource, float damage) {
        if (this.hurtSound() != null) {
            this.m_5496_(this.hurtSound(), this.m_6121_(), this.m_6100_());
        }
        this.m_9236_().m_7605_((Entity)this, (byte)8);
    }

    public boolean m_142535_(float p_393354_, float p_147187_, DamageSource p_147189_) {
        return this.canBeDamagedFromFalling();
    }

    public boolean m_6914_(LevelReader p_455089_) {
        if (this.canSpawnAnywhere()) {
            return p_455089_.m_45784_((Entity)this);
        }
        return super.m_6914_(p_455089_);
    }

    public boolean animationEnded(ModAnimationState state, float animLength) {
        return (float)state.getTimeInMillis(this.f_19797_) > animLength * 1000.0f;
    }

    public boolean unableToMoveToTheOwner() {
        return this.m_21827_() || this.m_20159_() || this.m_269323_() != null && this.m_269323_().m_5833_();
    }
}

