/*
 * Decompiled with CFR 0.152.
 */
package com.evandev.afterimages.client;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class TransparencyBufferSource
implements MultiBufferSource {
    private final MultiBufferSource delegate;
    private final ResourceLocation texture;
    private float alpha = 1.0f;
    private int rgb = 0xFFFFFF;
    private boolean overlayOnly = false;

    public TransparencyBufferSource(MultiBufferSource delegate, ResourceLocation texture) {
        this.delegate = delegate;
        this.texture = texture;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public void setColor(int rgb) {
        this.rgb = rgb;
    }

    public void setOverlayOnly(boolean overlayOnly) {
        this.overlayOnly = overlayOnly;
    }

    @NotNull
    public VertexConsumer getBuffer(@NotNull RenderType type) {
        if (this.overlayOnly) {
            if (type.toString().contains("eyes")) {
                return new AlphaVertexConsumer(this.delegate.getBuffer(type), this.alpha, this.rgb, true);
            }
            return new NoOpVertexConsumer();
        }
        RenderType remappedType = GhostRenderType.get(this.texture);
        return new AlphaVertexConsumer(this.delegate.getBuffer(remappedType), this.alpha, this.rgb, false);
    }

    private record AlphaVertexConsumer(VertexConsumer delegate, float alpha, int rgb, boolean premultiplyAlpha) implements VertexConsumer
    {
        @NotNull
        public VertexConsumer addVertex(float x, float y, float z) {
            this.delegate.addVertex(x, y, z);
            return this;
        }

        @NotNull
        public VertexConsumer setColor(int red, int green, int blue, int alpha) {
            float rScale = (float)(this.rgb >> 16 & 0xFF) / 255.0f;
            float gScale = (float)(this.rgb >> 8 & 0xFF) / 255.0f;
            float bScale = (float)(this.rgb & 0xFF) / 255.0f;
            float alphaFactor = this.alpha;
            if (this.premultiplyAlpha) {
                rScale *= alphaFactor;
                gScale *= alphaFactor;
                bScale *= alphaFactor;
            }
            this.delegate.setColor((int)((float)red * rScale), (int)((float)green * gScale), (int)((float)blue * bScale), (int)((float)alpha * alphaFactor));
            return this;
        }

        @NotNull
        public VertexConsumer setUv(float u, float v) {
            this.delegate.setUv(u, v);
            return this;
        }

        @NotNull
        public VertexConsumer setUv1(int u, int v) {
            this.delegate.setUv1(u, v);
            return this;
        }

        @NotNull
        public VertexConsumer setUv2(int u, int v) {
            this.delegate.setUv2(u, v);
            return this;
        }

        @NotNull
        public VertexConsumer setNormal(float x, float y, float z) {
            this.delegate.setNormal(x, y, z);
            return this;
        }
    }

    private static class NoOpVertexConsumer
    implements VertexConsumer {
        private NoOpVertexConsumer() {
        }

        @NotNull
        public VertexConsumer addVertex(float x, float y, float z) {
            return this;
        }

        @NotNull
        public VertexConsumer setColor(int red, int green, int blue, int alpha) {
            return this;
        }

        @NotNull
        public VertexConsumer setUv(float u, float v) {
            return this;
        }

        @NotNull
        public VertexConsumer setUv1(int u, int v) {
            return this;
        }

        @NotNull
        public VertexConsumer setUv2(int u, int v) {
            return this;
        }

        @NotNull
        public VertexConsumer setNormal(float x, float y, float z) {
            return this;
        }
    }

    private static class GhostRenderType
    extends RenderType {
        private static final Map<ResourceLocation, RenderType> CACHE = new HashMap<ResourceLocation, RenderType>();

        private GhostRenderType(String name, VertexFormat format, VertexFormat.Mode mode, int bufferSize, boolean affectsCrumbling, boolean sortOnUpload, Runnable setupState, Runnable clearState) {
            super(name, format, mode, bufferSize, affectsCrumbling, sortOnUpload, setupState, clearState);
        }

        public static RenderType get(ResourceLocation texture) {
            return CACHE.computeIfAbsent(texture, GhostRenderType::createGhostType);
        }

        private static RenderType createGhostType(ResourceLocation texture) {
            RenderType.CompositeState state = RenderType.CompositeState.builder().setShaderState(RENDERTYPE_ENTITY_TRANSLUCENT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setCullState(NO_CULL).setLightmapState(LIGHTMAP).setOverlayState(OVERLAY).setWriteMaskState(COLOR_WRITE).createCompositeState(false);
            return RenderType.create((String)"afterimage_ghost", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)state);
        }
    }
}

