/*
 * Decompiled with CFR 0.152.
 */
package com.evandev.afterimages.compat;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.combat_roll.CombatRollMod;
import net.combat_roll.internals.RollingEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class CombatRollCompat {
    private static final Map<UUID, Long> ROLL_START_TIMES = new ConcurrentHashMap<UUID, Long>();

    public static void init() {
    }

    public static void onRoll(Entity entity) {
        if (entity != null) {
            ROLL_START_TIMES.put(entity.getUUID(), entity.level().getGameTime());
        }
    }

    public static boolean isRolling(Entity entity) {
        RollingEntity rollingEntity;
        if (!(entity instanceof Player)) {
            return false;
        }
        if (entity instanceof RollingEntity && (rollingEntity = (RollingEntity)entity).getRollManager() != null) {
            return rollingEntity.getRollManager().isRolling();
        }
        if (ROLL_START_TIMES.containsKey(entity.getUUID())) {
            int duration;
            long startTime = ROLL_START_TIMES.get(entity.getUUID());
            long currentTime = entity.level().getGameTime();
            long elapsed = currentTime - startTime;
            int n = duration = CombatRollMod.config != null ? CombatRollMod.config.roll_duration : 20;
            if (elapsed >= 0L && elapsed < (long)duration) {
                return true;
            }
            ROLL_START_TIMES.remove(entity.getUUID());
        }
        return false;
    }
}

