/*
 * Decompiled with CFR 0.152.
 */
package com.evandev.afterimages.mixin;

import com.evandev.afterimages.access.AfterimageAccessor;
import com.evandev.afterimages.client.TransparencyBufferSource;
import com.evandev.afterimages.config.ModConfig;
import com.evandev.afterimages.data.AfterimageConfigLoader;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Deque;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityRenderDispatcher.class})
public abstract class EntityRenderDispatcherMixin {
    @Unique
    private boolean afterimages$isRenderingAfterimage = false;

    @Shadow
    public abstract <E extends Entity> EntityRenderer<? super E> getRenderer(E var1);

    @Inject(method={"render"}, at={@At(value="TAIL")})
    public <E extends Entity> void renderAfterimages(E entity, double x, double y, double z, float rotationYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, CallbackInfo ci) {
        if (this.afterimages$isRenderingAfterimage) {
            return;
        }
        if (entity instanceof AfterimageAccessor) {
            AfterimageAccessor accessor = (AfterimageAccessor)entity;
            Deque<AfterimageAccessor.Snapshot> history = accessor.afterimages$getHistory();
            if (history.isEmpty()) {
                return;
            }
            AfterimageConfigLoader.AfterimageConfig config = AfterimageConfigLoader.CONFIGS.get(entity.getType());
            if (config == null) {
                return;
            }
            this.afterimages$isRenderingAfterimage = true;
            RenderSystem.depthMask((boolean)false);
            EntityRenderer<E> baseRenderer = this.getRenderer(entity);
            ResourceLocation entityTexture = baseRenderer.getTextureLocation(entity);
            TransparencyBufferSource transparencyBuffer = new TransparencyBufferSource(buffer, entityTexture);
            transparencyBuffer.setColor(config.color());
            transparencyBuffer.setOverlayOnly(config.overlayOnly());
            ArrayList<AfterimageAccessor.Snapshot> snapshots = new ArrayList<AfterimageAccessor.Snapshot>();
            double renderTime = (float)entity.level().getGameTime() + partialTicks;
            boolean connectedToBody = false;
            double timeGap = 0.0;
            if (history.peekFirst() != null) {
                timeGap = renderTime - (double)history.peekFirst().timestamp();
            }
            if (timeGap < 2.0) {
                connectedToBody = true;
                double curX = Mth.lerp((double)partialTicks, (double)entity.xo, (double)entity.getX());
                double curY = Mth.lerp((double)partialTicks, (double)entity.yo, (double)entity.getY());
                double curZ = Mth.lerp((double)partialTicks, (double)entity.zo, (double)entity.getZ());
                float curYRot = Mth.lerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot());
                float curXRot = Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot());
                float curYBody = 0.0f;
                float curYHead = 0.0f;
                if (entity instanceof LivingEntity) {
                    LivingEntity l = (LivingEntity)entity;
                    curYBody = Mth.lerp((float)partialTicks, (float)l.yBodyRotO, (float)l.yBodyRot);
                    curYHead = Mth.lerp((float)partialTicks, (float)l.yHeadRotO, (float)l.yHeadRot);
                }
                snapshots.add(new AfterimageAccessor.Snapshot(new Vec3(curX, curY, curZ), curYBody, curYHead, curYRot, curXRot, 1.0f, (long)renderTime));
            }
            snapshots.addAll(history);
            double stepSize = Math.max(0.05, ModConfig.get().step_size);
            double maxAge = config.duration();
            for (double age = stepSize; age < maxAge; age += stepSize) {
                double t2;
                double t1;
                double delta;
                double targetTime = renderTime - age;
                AfterimageAccessor.Snapshot before = null;
                AfterimageAccessor.Snapshot after = null;
                for (int i = 0; i < snapshots.size() - 1; ++i) {
                    AfterimageAccessor.Snapshot s1 = (AfterimageAccessor.Snapshot)snapshots.get(i);
                    AfterimageAccessor.Snapshot s2 = (AfterimageAccessor.Snapshot)snapshots.get(i + 1);
                    double t12 = i == 0 && connectedToBody ? renderTime : (double)s1.timestamp();
                    double t22 = s2.timestamp();
                    if (!(targetTime <= t12) || !(targetTime >= t22)) continue;
                    before = s1;
                    after = s2;
                    break;
                }
                if (before == null || (delta = (t1 = snapshots.indexOf(before) == 0 && connectedToBody ? renderTime : (double)before.timestamp()) - (t2 = (double)after.timestamp())) <= 1.0E-4) continue;
                float progress = (float)((t1 - targetTime) / delta);
                float ageProgress = (float)(age / maxAge);
                float alpha = (float)(config.startAlpha() * (double)(1.0f - ageProgress));
                if ((alpha *= (float)(stepSize / 0.25)) <= 0.01f) continue;
                transparencyBuffer.setAlpha(alpha);
                double interpX = Mth.lerp((double)progress, (double)before.position().x, (double)after.position().x);
                double interpY = Mth.lerp((double)progress, (double)before.position().y, (double)after.position().y);
                double interpZ = Mth.lerp((double)progress, (double)before.position().z, (double)after.position().z);
                float interpYRot = Mth.rotLerp((float)progress, (float)before.yRot(), (float)after.yRot());
                float interpXRot = Mth.rotLerp((float)progress, (float)before.xRot(), (float)after.xRot());
                float interpYBody = Mth.rotLerp((float)progress, (float)before.yBodyRot(), (float)after.yBodyRot());
                float interpYHead = Mth.rotLerp((float)progress, (float)before.yHeadRot(), (float)after.yHeadRot());
                poseStack.pushPose();
                double curX = Mth.lerp((double)partialTicks, (double)entity.xo, (double)entity.getX());
                double curY = Mth.lerp((double)partialTicks, (double)entity.yo, (double)entity.getY());
                double curZ = Mth.lerp((double)partialTicks, (double)entity.zo, (double)entity.getZ());
                double offsetX = interpX - curX;
                double offsetY = interpY - curY;
                double offsetZ = interpZ - curZ;
                poseStack.translate(x + offsetX, y + offsetY, z + offsetZ);
                try {
                    LivingEntity l;
                    float oldYRot = entity.getYRot();
                    float oldXRot = entity.getXRot();
                    float oldYBody = 0.0f;
                    float oldYHead = 0.0f;
                    if (entity instanceof LivingEntity) {
                        l = (LivingEntity)entity;
                        oldYBody = l.yBodyRot;
                        oldYHead = l.yHeadRot;
                        l.yBodyRot = interpYBody;
                        l.yHeadRot = interpYHead;
                    }
                    entity.setYRot(interpYRot);
                    entity.setXRot(interpXRot);
                    baseRenderer.render(entity, 0.0f, 0.0f, poseStack, (MultiBufferSource)transparencyBuffer, packedLight);
                    entity.setYRot(oldYRot);
                    entity.setXRot(oldXRot);
                    if (entity instanceof LivingEntity) {
                        l = (LivingEntity)entity;
                        l.yBodyRot = oldYBody;
                        l.yHeadRot = oldYHead;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                poseStack.popPose();
            }
            RenderSystem.depthMask((boolean)true);
            this.afterimages$isRenderingAfterimage = false;
        }
    }
}

