/*
 * Decompiled with CFR 0.152.
 */
package com.evandev.afterimages.data;

import com.evandev.afterimages.Constants;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public class AfterimageConfigLoader
extends class_4309 {
    public static final Map<class_1299<?>, AfterimageConfig> CONFIGS = new HashMap();
    private static final Gson GSON = new Gson();

    public AfterimageConfigLoader() {
        super(GSON, "afterimages/entities");
    }

    protected void apply(Map<class_2960, JsonElement> resources, @NotNull class_3300 resourceManager, @NotNull class_3695 profiler) {
        CONFIGS.clear();
        resources.forEach((location, json) -> {
            try {
                JsonObject obj = json.getAsJsonObject();
                ArrayList<class_1299> entities = new ArrayList<class_1299>();
                if (obj.has("entity")) {
                    String entityStr = obj.get("entity").getAsString();
                    if (entityStr.startsWith("#")) {
                        class_2960 tagLoc = class_2960.method_60654((String)entityStr.substring(1));
                        class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)tagLoc);
                        class_7923.field_41177.method_40266(tagKey).ifPresent(tag -> {
                            for (class_6880 holder : tag) {
                                entities.add((class_1299)holder.comp_349());
                            }
                        });
                    } else {
                        entities.add((class_1299)class_7923.field_41177.method_10223(class_2960.method_60654((String)entityStr)));
                    }
                } else {
                    class_2960 entityId = class_2960.method_60655((String)location.method_12836(), (String)location.method_12832());
                    entities.add((class_1299)class_7923.field_41177.method_10223(entityId));
                }
                if (!entities.isEmpty()) {
                    double speedThreshold = obj.has("speed_threshold") ? obj.get("speed_threshold").getAsDouble() : 0.1;
                    int duration = obj.has("duration") ? obj.get("duration").getAsInt() : 15;
                    int color = obj.has("color") ? Integer.decode(obj.get("color").getAsString()) : 0xFFFFFF;
                    boolean overlay = obj.has("overlay_only") && obj.get("overlay_only").getAsBoolean();
                    boolean combatRollOnly = obj.has("combat_roll_only") && obj.get("combat_roll_only").getAsBoolean();
                    double startAlpha = obj.has("start_alpha") ? obj.get("start_alpha").getAsDouble() : 0.5;
                    AfterimageConfig config = new AfterimageConfig(speedThreshold, duration, color, overlay, startAlpha, combatRollOnly);
                    for (class_1299 type : entities) {
                        CONFIGS.put(type, config);
                    }
                }
            }
            catch (Exception e) {
                Constants.LOG.error("Failed to load afterimage config for {}", location, (Object)e);
            }
        });
        Constants.LOG.info("Loaded {} afterimage configurations.", (Object)CONFIGS.size());
    }

    public record AfterimageConfig(double speedThreshold, int duration, int color, boolean overlayOnly, double startAlpha, boolean combatRollOnly) {
    }
}

