/*
 * Decompiled with CFR 0.152.
 */
package com.evandev.afterimages.client;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class TransparencyBufferSource
implements MultiBufferSource {
    private final MultiBufferSource delegate;
    private final ResourceLocation texture;
    private float alpha = 1.0f;
    private int rgb = 0xFFFFFF;
    private boolean overlayOnly = false;

    public TransparencyBufferSource(MultiBufferSource delegate, ResourceLocation texture) {
        this.delegate = delegate;
        this.texture = texture;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public void setColor(int rgb) {
        this.rgb = rgb;
    }

    public void setOverlayOnly(boolean overlayOnly) {
        this.overlayOnly = overlayOnly;
    }

    @NotNull
    public VertexConsumer m_6299_(@NotNull RenderType type) {
        if (this.overlayOnly) {
            if (type.toString().contains("eyes")) {
                return new AlphaVertexConsumer(this.delegate.m_6299_(type), this.alpha, this.rgb, true);
            }
            return new NoOpVertexConsumer();
        }
        RenderType remappedType = GhostRenderType.get(this.texture);
        return new AlphaVertexConsumer(this.delegate.m_6299_(remappedType), this.alpha, this.rgb, false);
    }

    private record AlphaVertexConsumer(VertexConsumer delegate, float alpha, int rgb, boolean premultiplyAlpha) implements VertexConsumer
    {
        @NotNull
        public VertexConsumer m_5483_(double x, double y, double z) {
            this.delegate.m_5483_(x, y, z);
            return this;
        }

        @NotNull
        public VertexConsumer m_6122_(int red, int green, int blue, int alpha) {
            float rScale = (float)(this.rgb >> 16 & 0xFF) / 255.0f;
            float gScale = (float)(this.rgb >> 8 & 0xFF) / 255.0f;
            float bScale = (float)(this.rgb & 0xFF) / 255.0f;
            float alphaFactor = this.alpha;
            if (this.premultiplyAlpha) {
                rScale *= alphaFactor;
                gScale *= alphaFactor;
                bScale *= alphaFactor;
            }
            this.delegate.m_6122_((int)((float)red * rScale), (int)((float)green * gScale), (int)((float)blue * bScale), (int)((float)alpha * alphaFactor));
            return this;
        }

        @NotNull
        public VertexConsumer m_7421_(float u, float v) {
            this.delegate.m_7421_(u, v);
            return this;
        }

        @NotNull
        public VertexConsumer m_7122_(int u, int v) {
            this.delegate.m_7122_(u, v);
            return this;
        }

        @NotNull
        public VertexConsumer m_7120_(int u, int v) {
            this.delegate.m_7120_(u, v);
            return this;
        }

        @NotNull
        public VertexConsumer m_5601_(float x, float y, float z) {
            this.delegate.m_5601_(x, y, z);
            return this;
        }

        public void m_5752_() {
            this.delegate.m_5752_();
        }

        public void m_7404_(int r, int g, int b, int a) {
            float rScale = (float)(this.rgb >> 16 & 0xFF) / 255.0f;
            float gScale = (float)(this.rgb >> 8 & 0xFF) / 255.0f;
            float bScale = (float)(this.rgb & 0xFF) / 255.0f;
            float alphaFactor = this.alpha;
            if (this.premultiplyAlpha) {
                rScale *= alphaFactor;
                gScale *= alphaFactor;
                bScale *= alphaFactor;
            }
            this.delegate.m_7404_((int)((float)r * rScale), (int)((float)g * gScale), (int)((float)b * bScale), (int)((float)a * alphaFactor));
        }

        public void m_141991_() {
            this.delegate.m_141991_();
        }
    }

    private static class NoOpVertexConsumer
    implements VertexConsumer {
        private NoOpVertexConsumer() {
        }

        @NotNull
        public VertexConsumer m_5483_(double x, double y, double z) {
            return this;
        }

        @NotNull
        public VertexConsumer m_6122_(int red, int green, int blue, int alpha) {
            return this;
        }

        @NotNull
        public VertexConsumer m_7421_(float u, float v) {
            return this;
        }

        @NotNull
        public VertexConsumer m_7122_(int u, int v) {
            return this;
        }

        @NotNull
        public VertexConsumer m_7120_(int u, int v) {
            return this;
        }

        @NotNull
        public VertexConsumer m_5601_(float x, float y, float z) {
            return this;
        }

        public void m_5752_() {
        }

        public void m_7404_(int r, int g, int b, int a) {
        }

        public void m_141991_() {
        }
    }

    private static class GhostRenderType
    extends RenderType {
        private static final Map<ResourceLocation, RenderType> CACHE = new HashMap<ResourceLocation, RenderType>();

        private GhostRenderType(String name, VertexFormat format, VertexFormat.Mode mode, int bufferSize, boolean affectsCrumbling, boolean sortOnUpload, Runnable setupState, Runnable clearState) {
            super(name, format, mode, bufferSize, affectsCrumbling, sortOnUpload, setupState, clearState);
        }

        public static RenderType get(ResourceLocation texture) {
            return CACHE.computeIfAbsent(texture, GhostRenderType::createGhostType);
        }

        private static RenderType createGhostType(ResourceLocation texture) {
            RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(f_173066_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110685_(f_110139_).m_110661_(f_110110_).m_110671_(f_110152_).m_110677_(f_110154_).m_110687_(f_110115_).m_110691_(false);
            return RenderType.m_173215_((String)"afterimage_ghost", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)state);
        }
    }
}

