/*
 * Decompiled with CFR 0.152.
 */
package com.evandev.afterimages.compat;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.combatroll.CombatRoll;
import net.combatroll.internals.RollingEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class CombatRollCompat {
    private static final Map<UUID, Long> ROLL_START_TIMES = new ConcurrentHashMap<UUID, Long>();

    public static void init() {
    }

    public static void onRoll(Entity entity) {
        if (entity != null) {
            ROLL_START_TIMES.put(entity.m_20148_(), entity.m_9236_().m_46467_());
        }
    }

    public static boolean isRolling(Entity entity) {
        RollingEntity rollingEntity;
        if (!(entity instanceof Player)) {
            return false;
        }
        if (entity instanceof RollingEntity && (rollingEntity = (RollingEntity)entity).getRollManager() != null) {
            return rollingEntity.getRollManager().isRolling();
        }
        if (ROLL_START_TIMES.containsKey(entity.m_20148_())) {
            int duration;
            long startTime = ROLL_START_TIMES.get(entity.m_20148_());
            long currentTime = entity.m_9236_().m_46467_();
            long elapsed = currentTime - startTime;
            int n = duration = CombatRoll.config != null ? CombatRoll.config.roll_duration : 20;
            if (elapsed >= 0L && elapsed < (long)duration) {
                return true;
            }
            ROLL_START_TIMES.remove(entity.m_20148_());
        }
        return false;
    }
}

