/*
 * Decompiled with CFR 0.152.
 */
package com.evandev.afterimages.config;

import com.evandev.afterimages.Constants;
import com.evandev.afterimages.platform.Services;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = Services.PLATFORM.getConfigDirectory().resolve("afterimages.json").toFile();
    private static ModConfig INSTANCE;
    public double step_size = 0.25;

    public static ModConfig get() {
        if (INSTANCE == null) {
            ModConfig.load();
        }
        return INSTANCE;
    }

    public static void load() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                INSTANCE = (ModConfig)GSON.fromJson((Reader)reader, ModConfig.class);
            }
            catch (Exception e) {
                Constants.LOG.error("Failed to load afterimages.json", (Throwable)e);
                INSTANCE = new ModConfig();
            }
        } else {
            INSTANCE = new ModConfig();
            ModConfig.save();
        }
    }

    public static void save() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)INSTANCE, (Appendable)writer);
        }
        catch (IOException e) {
            Constants.LOG.error("Failed to save afterimages.json", (Throwable)e);
        }
    }
}

