/*
 * Decompiled with CFR 0.152.
 */
package com.evandev.afterimages.mixin;

import com.evandev.afterimages.access.AfterimageAccessor;
import com.evandev.afterimages.compat.CombatRollCompat;
import com.evandev.afterimages.data.AfterimageConfigLoader;
import com.evandev.afterimages.platform.Services;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public class EntityMixin
implements AfterimageAccessor {
    @Unique
    private final Deque<AfterimageAccessor.Snapshot> afterimages$afterimageHistory = new ArrayDeque<AfterimageAccessor.Snapshot>();

    @Override
    public Deque<AfterimageAccessor.Snapshot> afterimages$getHistory() {
        return this.afterimages$afterimageHistory;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tickAfterimages(CallbackInfo ci) {
        this.afterimages$tickHistory();
    }

    @Override
    public void afterimages$tickHistory() {
        AfterimageAccessor.Snapshot oldest;
        Entity self = (Entity)this;
        long gameTime = self.m_9236_().m_46467_();
        AfterimageConfigLoader.AfterimageConfig config = AfterimageConfigLoader.CONFIGS.get(self.m_6095_());
        if (config == null) {
            if (!this.afterimages$afterimageHistory.isEmpty()) {
                this.afterimages$afterimageHistory.clear();
            }
            return;
        }
        while (!this.afterimages$afterimageHistory.isEmpty() && gameTime - (oldest = this.afterimages$afterimageHistory.peekLast()).timestamp() > (long)config.duration()) {
            this.afterimages$afterimageHistory.removeLast();
        }
        boolean shouldRecord = false;
        if (config.combatRollOnly()) {
            if (Services.PLATFORM.isModLoaded("combatroll") && CombatRollCompat.isRolling(self)) {
                shouldRecord = true;
            }
        } else {
            double speed = self.m_20184_().m_82556_();
            if (speed >= config.speedThreshold() * config.speedThreshold()) {
                shouldRecord = true;
            }
        }
        if (!shouldRecord) {
            return;
        }
        float bodyRot = 0.0f;
        float headRot = self.m_146908_();
        if (self instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)self;
            bodyRot = living.f_20883_;
            headRot = living.f_20885_;
        }
        this.afterimages$afterimageHistory.addFirst(new AfterimageAccessor.Snapshot(new Vec3(self.m_20185_(), self.m_20186_(), self.m_20189_()), bodyRot, headRot, self.m_146908_(), self.m_146909_(), 1.0f, gameTime));
    }
}

