/*
 * Decompiled with CFR 0.152.
 */
package com.evandev.afterimages.mixin;

import com.evandev.afterimages.access.AfterimageAccessor;
import com.evandev.afterimages.client.TransparencyBufferSource;
import com.evandev.afterimages.config.ModConfig;
import com.evandev.afterimages.data.AfterimageConfigLoader;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Deque;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityRenderDispatcher.class})
public abstract class EntityRenderDispatcherMixin {
    @Unique
    private boolean afterimages$isRenderingAfterimage = false;

    @Shadow
    public abstract <E extends Entity> EntityRenderer<? super E> m_114382_(E var1);

    @Inject(method={"render"}, at={@At(value="TAIL")})
    public <E extends Entity> void renderAfterimages(E entity, double x, double y, double z, float rotationYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, CallbackInfo ci) {
        if (this.afterimages$isRenderingAfterimage) {
            return;
        }
        if (entity instanceof AfterimageAccessor) {
            AfterimageAccessor accessor = (AfterimageAccessor)entity;
            Deque<AfterimageAccessor.Snapshot> history = accessor.afterimages$getHistory();
            if (history.isEmpty()) {
                return;
            }
            AfterimageConfigLoader.AfterimageConfig config = AfterimageConfigLoader.CONFIGS.get(entity.m_6095_());
            if (config == null) {
                return;
            }
            this.afterimages$isRenderingAfterimage = true;
            RenderSystem.depthMask((boolean)false);
            EntityRenderer<E> baseRenderer = this.m_114382_(entity);
            ResourceLocation entityTexture = baseRenderer.m_5478_(entity);
            TransparencyBufferSource transparencyBuffer = new TransparencyBufferSource(buffer, entityTexture);
            transparencyBuffer.setColor(config.color());
            transparencyBuffer.setOverlayOnly(config.overlayOnly());
            ArrayList<AfterimageAccessor.Snapshot> snapshots = new ArrayList<AfterimageAccessor.Snapshot>();
            double renderTime = (float)entity.m_9236_().m_46467_() + partialTicks;
            boolean connectedToBody = false;
            double timeGap = 0.0;
            if (history.peekFirst() != null) {
                timeGap = renderTime - (double)history.peekFirst().timestamp();
            }
            if (timeGap < 2.0) {
                connectedToBody = true;
                double curX = Mth.m_14139_((double)partialTicks, (double)entity.f_19854_, (double)entity.m_20185_());
                double curY = Mth.m_14139_((double)partialTicks, (double)entity.f_19855_, (double)entity.m_20186_());
                double curZ = Mth.m_14139_((double)partialTicks, (double)entity.f_19856_, (double)entity.m_20189_());
                float curYRot = Mth.m_14179_((float)partialTicks, (float)entity.f_19859_, (float)entity.m_146908_());
                float curXRot = Mth.m_14179_((float)partialTicks, (float)entity.f_19860_, (float)entity.m_146909_());
                float curYBody = 0.0f;
                float curYHead = 0.0f;
                if (entity instanceof LivingEntity) {
                    LivingEntity l = (LivingEntity)entity;
                    curYBody = Mth.m_14179_((float)partialTicks, (float)l.f_20884_, (float)l.f_20883_);
                    curYHead = Mth.m_14179_((float)partialTicks, (float)l.f_20886_, (float)l.f_20885_);
                }
                snapshots.add(new AfterimageAccessor.Snapshot(new Vec3(curX, curY, curZ), curYBody, curYHead, curYRot, curXRot, 1.0f, (long)renderTime));
            }
            snapshots.addAll(history);
            double stepSize = Math.max(0.05, ModConfig.get().step_size);
            double maxAge = config.duration();
            for (double age = stepSize; age < maxAge; age += stepSize) {
                double t2;
                double t1;
                double delta;
                double targetTime = renderTime - age;
                AfterimageAccessor.Snapshot before = null;
                AfterimageAccessor.Snapshot after = null;
                for (int i = 0; i < snapshots.size() - 1; ++i) {
                    AfterimageAccessor.Snapshot s1 = (AfterimageAccessor.Snapshot)snapshots.get(i);
                    AfterimageAccessor.Snapshot s2 = (AfterimageAccessor.Snapshot)snapshots.get(i + 1);
                    double t12 = i == 0 && connectedToBody ? renderTime : (double)s1.timestamp();
                    double t22 = s2.timestamp();
                    if (!(targetTime <= t12) || !(targetTime >= t22)) continue;
                    before = s1;
                    after = s2;
                    break;
                }
                if (before == null || (delta = (t1 = snapshots.indexOf(before) == 0 && connectedToBody ? renderTime : (double)before.timestamp()) - (t2 = (double)after.timestamp())) <= 1.0E-4) continue;
                float progress = (float)((t1 - targetTime) / delta);
                float ageProgress = (float)(age / maxAge);
                float alpha = (float)(config.startAlpha() * (double)(1.0f - ageProgress));
                if ((alpha *= (float)(stepSize / 0.25)) <= 0.01f) continue;
                transparencyBuffer.setAlpha(alpha);
                double interpX = Mth.m_14139_((double)progress, (double)before.position().f_82479_, (double)after.position().f_82479_);
                double interpY = Mth.m_14139_((double)progress, (double)before.position().f_82480_, (double)after.position().f_82480_);
                double interpZ = Mth.m_14139_((double)progress, (double)before.position().f_82481_, (double)after.position().f_82481_);
                float interpYRot = Mth.m_14189_((float)progress, (float)before.yRot(), (float)after.yRot());
                float interpXRot = Mth.m_14189_((float)progress, (float)before.xRot(), (float)after.xRot());
                float interpYBody = Mth.m_14189_((float)progress, (float)before.yBodyRot(), (float)after.yBodyRot());
                float interpYHead = Mth.m_14189_((float)progress, (float)before.yHeadRot(), (float)after.yHeadRot());
                poseStack.m_85836_();
                double curX = Mth.m_14139_((double)partialTicks, (double)entity.f_19854_, (double)entity.m_20185_());
                double curY = Mth.m_14139_((double)partialTicks, (double)entity.f_19855_, (double)entity.m_20186_());
                double curZ = Mth.m_14139_((double)partialTicks, (double)entity.f_19856_, (double)entity.m_20189_());
                double offsetX = interpX - curX;
                double offsetY = interpY - curY;
                double offsetZ = interpZ - curZ;
                poseStack.m_85837_(x + offsetX, y + offsetY, z + offsetZ);
                try {
                    LivingEntity l;
                    float oldYRot = entity.m_146908_();
                    float oldXRot = entity.m_146909_();
                    float oldYBody = 0.0f;
                    float oldYHead = 0.0f;
                    if (entity instanceof LivingEntity) {
                        l = (LivingEntity)entity;
                        oldYBody = l.f_20883_;
                        oldYHead = l.f_20885_;
                        l.f_20883_ = interpYBody;
                        l.f_20885_ = interpYHead;
                    }
                    entity.m_146922_(interpYRot);
                    entity.m_146926_(interpXRot);
                    baseRenderer.m_7392_(entity, 0.0f, 0.0f, poseStack, (MultiBufferSource)transparencyBuffer, packedLight);
                    entity.m_146922_(oldYRot);
                    entity.m_146926_(oldXRot);
                    if (entity instanceof LivingEntity) {
                        l = (LivingEntity)entity;
                        l.f_20883_ = oldYBody;
                        l.f_20885_ = oldYHead;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                poseStack.m_85849_();
            }
            RenderSystem.depthMask((boolean)true);
            this.afterimages$isRenderingAfterimage = false;
        }
    }
}

