/*
 * Decompiled with CFR 0.152.
 */
package com.evandev.afterimages.client;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1921;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import org.jetbrains.annotations.NotNull;

public class TransparencyBufferSource
implements class_4597 {
    private final class_4597 delegate;
    private final class_2960 texture;
    private float alpha = 1.0f;
    private int rgb = 0xFFFFFF;
    private boolean overlayOnly = false;

    public TransparencyBufferSource(class_4597 delegate, class_2960 texture) {
        this.delegate = delegate;
        this.texture = texture;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public void setColor(int rgb) {
        this.rgb = rgb;
    }

    public void setOverlayOnly(boolean overlayOnly) {
        this.overlayOnly = overlayOnly;
    }

    @NotNull
    public class_4588 getBuffer(@NotNull class_1921 type) {
        if (this.overlayOnly) {
            if (type.toString().contains("eyes")) {
                return new AlphaVertexConsumer(this.delegate.getBuffer(type), this.alpha, this.rgb, true);
            }
            return new NoOpVertexConsumer();
        }
        class_1921 remappedType = GhostRenderType.get(this.texture);
        return new AlphaVertexConsumer(this.delegate.getBuffer(remappedType), this.alpha, this.rgb, false);
    }

    private record AlphaVertexConsumer(class_4588 delegate, float alpha, int rgb, boolean premultiplyAlpha) implements class_4588
    {
        @NotNull
        public class_4588 method_22912(double x, double y, double z) {
            this.delegate.method_22912(x, y, z);
            return this;
        }

        @NotNull
        public class_4588 method_1336(int red, int green, int blue, int alpha) {
            float rScale = (float)(this.rgb >> 16 & 0xFF) / 255.0f;
            float gScale = (float)(this.rgb >> 8 & 0xFF) / 255.0f;
            float bScale = (float)(this.rgb & 0xFF) / 255.0f;
            float alphaFactor = this.alpha;
            if (this.premultiplyAlpha) {
                rScale *= alphaFactor;
                gScale *= alphaFactor;
                bScale *= alphaFactor;
            }
            this.delegate.method_1336((int)((float)red * rScale), (int)((float)green * gScale), (int)((float)blue * bScale), (int)((float)alpha * alphaFactor));
            return this;
        }

        @NotNull
        public class_4588 method_22913(float u, float v) {
            this.delegate.method_22913(u, v);
            return this;
        }

        @NotNull
        public class_4588 method_22917(int u, int v) {
            this.delegate.method_22917(u, v);
            return this;
        }

        @NotNull
        public class_4588 method_22921(int u, int v) {
            this.delegate.method_22921(u, v);
            return this;
        }

        @NotNull
        public class_4588 method_22914(float x, float y, float z) {
            this.delegate.method_22914(x, y, z);
            return this;
        }

        public void method_1344() {
            this.delegate.method_1344();
        }

        public void method_22901(int r, int g, int b, int a) {
            float rScale = (float)(this.rgb >> 16 & 0xFF) / 255.0f;
            float gScale = (float)(this.rgb >> 8 & 0xFF) / 255.0f;
            float bScale = (float)(this.rgb & 0xFF) / 255.0f;
            float alphaFactor = this.alpha;
            if (this.premultiplyAlpha) {
                rScale *= alphaFactor;
                gScale *= alphaFactor;
                bScale *= alphaFactor;
            }
            this.delegate.method_22901((int)((float)r * rScale), (int)((float)g * gScale), (int)((float)b * bScale), (int)((float)a * alphaFactor));
        }

        public void method_35666() {
            this.delegate.method_35666();
        }
    }

    private static class NoOpVertexConsumer
    implements class_4588 {
        private NoOpVertexConsumer() {
        }

        @NotNull
        public class_4588 method_22912(double x, double y, double z) {
            return this;
        }

        @NotNull
        public class_4588 method_1336(int red, int green, int blue, int alpha) {
            return this;
        }

        @NotNull
        public class_4588 method_22913(float u, float v) {
            return this;
        }

        @NotNull
        public class_4588 method_22917(int u, int v) {
            return this;
        }

        @NotNull
        public class_4588 method_22921(int u, int v) {
            return this;
        }

        @NotNull
        public class_4588 method_22914(float x, float y, float z) {
            return this;
        }

        public void method_1344() {
        }

        public void method_22901(int r, int g, int b, int a) {
        }

        public void method_35666() {
        }
    }

    private static class GhostRenderType
    extends class_1921 {
        private static final Map<class_2960, class_1921> CACHE = new HashMap<class_2960, class_1921>();

        private GhostRenderType(String name, class_293 format, class_293.class_5596 mode, int bufferSize, boolean affectsCrumbling, boolean sortOnUpload, Runnable setupState, Runnable clearState) {
            super(name, format, mode, bufferSize, affectsCrumbling, sortOnUpload, setupState, clearState);
        }

        public static class_1921 get(class_2960 texture) {
            return CACHE.computeIfAbsent(texture, GhostRenderType::createGhostType);
        }

        private static class_1921 createGhostType(class_2960 texture) {
            class_1921.class_4688 state = class_1921.class_4688.method_23598().method_34578(field_29407).method_34577((class_4668.class_5939)new class_4668.class_4683(texture, false, false)).method_23615(field_21370).method_23603(field_21345).method_23608(field_21383).method_23611(field_21385).method_23616(field_21350).method_23617(false);
            return class_1921.method_24049((String)"afterimage_ghost", (class_293)class_290.field_1580, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)true, (boolean)true, (class_1921.class_4688)state);
        }
    }
}

