/*
 * Decompiled with CFR 0.152.
 */
package com.evandev.afterimages.mixin;

import com.evandev.afterimages.access.AfterimageAccessor;
import com.evandev.afterimages.client.TransparencyBufferSource;
import com.evandev.afterimages.config.ModConfig;
import com.evandev.afterimages.data.AfterimageConfigLoader;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Deque;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_897;
import net.minecraft.class_898;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_898.class})
public abstract class EntityRenderDispatcherMixin {
    @Unique
    private boolean afterimages$isRenderingAfterimage = false;

    @Shadow
    public abstract <E extends class_1297> class_897<? super E> method_3953(E var1);

    @Inject(method={"render"}, at={@At(value="TAIL")})
    public <E extends class_1297> void renderAfterimages(E entity, double x, double y, double z, float rotationYaw, float partialTicks, class_4587 poseStack, class_4597 buffer, int packedLight, CallbackInfo ci) {
        if (this.afterimages$isRenderingAfterimage) {
            return;
        }
        if (entity instanceof AfterimageAccessor) {
            AfterimageAccessor accessor = (AfterimageAccessor)entity;
            Deque<AfterimageAccessor.Snapshot> history = accessor.afterimages$getHistory();
            if (history.isEmpty()) {
                return;
            }
            AfterimageConfigLoader.AfterimageConfig config = AfterimageConfigLoader.CONFIGS.get(entity.method_5864());
            if (config == null) {
                return;
            }
            this.afterimages$isRenderingAfterimage = true;
            RenderSystem.depthMask((boolean)false);
            class_897<E> baseRenderer = this.method_3953(entity);
            class_2960 entityTexture = baseRenderer.method_3931(entity);
            TransparencyBufferSource transparencyBuffer = new TransparencyBufferSource(buffer, entityTexture);
            transparencyBuffer.setColor(config.color());
            transparencyBuffer.setOverlayOnly(config.overlayOnly());
            ArrayList<AfterimageAccessor.Snapshot> snapshots = new ArrayList<AfterimageAccessor.Snapshot>();
            double renderTime = (float)entity.method_37908().method_8510() + partialTicks;
            boolean connectedToBody = false;
            double timeGap = 0.0;
            if (history.peekFirst() != null) {
                timeGap = renderTime - (double)history.peekFirst().timestamp();
            }
            if (timeGap < 2.0) {
                connectedToBody = true;
                double curX = class_3532.method_16436((double)partialTicks, (double)entity.field_6014, (double)entity.method_23317());
                double curY = class_3532.method_16436((double)partialTicks, (double)entity.field_6036, (double)entity.method_23318());
                double curZ = class_3532.method_16436((double)partialTicks, (double)entity.field_5969, (double)entity.method_23321());
                float curYRot = class_3532.method_16439((float)partialTicks, (float)entity.field_5982, (float)entity.method_36454());
                float curXRot = class_3532.method_16439((float)partialTicks, (float)entity.field_6004, (float)entity.method_36455());
                float curYBody = 0.0f;
                float curYHead = 0.0f;
                if (entity instanceof class_1309) {
                    class_1309 l = (class_1309)entity;
                    curYBody = class_3532.method_16439((float)partialTicks, (float)l.field_6220, (float)l.field_6283);
                    curYHead = class_3532.method_16439((float)partialTicks, (float)l.field_6259, (float)l.field_6241);
                }
                snapshots.add(new AfterimageAccessor.Snapshot(new class_243(curX, curY, curZ), curYBody, curYHead, curYRot, curXRot, 1.0f, (long)renderTime));
            }
            snapshots.addAll(history);
            double stepSize = Math.max(0.05, ModConfig.get().step_size);
            double maxAge = config.duration();
            for (double age = stepSize; age < maxAge; age += stepSize) {
                double t2;
                double t1;
                double delta;
                double targetTime = renderTime - age;
                AfterimageAccessor.Snapshot before = null;
                AfterimageAccessor.Snapshot after = null;
                for (int i = 0; i < snapshots.size() - 1; ++i) {
                    AfterimageAccessor.Snapshot s1 = (AfterimageAccessor.Snapshot)snapshots.get(i);
                    AfterimageAccessor.Snapshot s2 = (AfterimageAccessor.Snapshot)snapshots.get(i + 1);
                    double t12 = i == 0 && connectedToBody ? renderTime : (double)s1.timestamp();
                    double t22 = s2.timestamp();
                    if (!(targetTime <= t12) || !(targetTime >= t22)) continue;
                    before = s1;
                    after = s2;
                    break;
                }
                if (before == null || (delta = (t1 = snapshots.indexOf(before) == 0 && connectedToBody ? renderTime : (double)before.timestamp()) - (t2 = (double)after.timestamp())) <= 1.0E-4) continue;
                float progress = (float)((t1 - targetTime) / delta);
                float ageProgress = (float)(age / maxAge);
                float alpha = (float)(config.startAlpha() * (double)(1.0f - ageProgress));
                if ((alpha *= (float)(stepSize / 0.25)) <= 0.01f) continue;
                transparencyBuffer.setAlpha(alpha);
                double interpX = class_3532.method_16436((double)progress, (double)before.position().field_1352, (double)after.position().field_1352);
                double interpY = class_3532.method_16436((double)progress, (double)before.position().field_1351, (double)after.position().field_1351);
                double interpZ = class_3532.method_16436((double)progress, (double)before.position().field_1350, (double)after.position().field_1350);
                float interpYRot = class_3532.method_17821((float)progress, (float)before.yRot(), (float)after.yRot());
                float interpXRot = class_3532.method_17821((float)progress, (float)before.xRot(), (float)after.xRot());
                float interpYBody = class_3532.method_17821((float)progress, (float)before.yBodyRot(), (float)after.yBodyRot());
                float interpYHead = class_3532.method_17821((float)progress, (float)before.yHeadRot(), (float)after.yHeadRot());
                poseStack.method_22903();
                double curX = class_3532.method_16436((double)partialTicks, (double)entity.field_6014, (double)entity.method_23317());
                double curY = class_3532.method_16436((double)partialTicks, (double)entity.field_6036, (double)entity.method_23318());
                double curZ = class_3532.method_16436((double)partialTicks, (double)entity.field_5969, (double)entity.method_23321());
                double offsetX = interpX - curX;
                double offsetY = interpY - curY;
                double offsetZ = interpZ - curZ;
                poseStack.method_22904(x + offsetX, y + offsetY, z + offsetZ);
                try {
                    class_1309 l;
                    float oldYRot = entity.method_36454();
                    float oldXRot = entity.method_36455();
                    float oldYBody = 0.0f;
                    float oldYHead = 0.0f;
                    if (entity instanceof class_1309) {
                        l = (class_1309)entity;
                        oldYBody = l.field_6283;
                        oldYHead = l.field_6241;
                        l.field_6283 = interpYBody;
                        l.field_6241 = interpYHead;
                    }
                    entity.method_36456(interpYRot);
                    entity.method_36457(interpXRot);
                    baseRenderer.method_3936(entity, 0.0f, 0.0f, poseStack, (class_4597)transparencyBuffer, packedLight);
                    entity.method_36456(oldYRot);
                    entity.method_36457(oldXRot);
                    if (entity instanceof class_1309) {
                        l = (class_1309)entity;
                        l.field_6283 = oldYBody;
                        l.field_6241 = oldYHead;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                poseStack.method_22909();
            }
            RenderSystem.depthMask((boolean)true);
            this.afterimages$isRenderingAfterimage = false;
        }
    }
}

