/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria;

import com.idark.valoria.Valoria;
import com.idark.valoria.core.DamageData;
import com.idark.valoria.core.capability.IMagmaLevel;
import com.idark.valoria.core.config.ClientConfig;
import com.idark.valoria.core.interfaces.ILivingEntityData;
import com.idark.valoria.registries.TagsRegistry;
import com.idark.valoria.registries.entity.living.decoration.MannequinEntity;
import com.idark.valoria.util.Pal;
import com.idark.valoria.util.ValoriaUtils;
import java.io.File;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.forgespi.language.IModInfo;
import pro.komaru.tridot.client.gfx.text.DotStyle;
import pro.komaru.tridot.util.Col;

public class ClientEvents {
    public static final DecimalFormat FORMAT = new DecimalFormat("###.##", new DecimalFormatSymbols(Locale.ENGLISH));
    private static final ResourceLocation FLAME_ICON = Valoria.loc("textures/gui/flame_icon.png");

    @SubscribeEvent
    public static void onRenderGui(RenderGuiOverlayEvent.Post event) {
        if (event.getOverlay() != VanillaGuiOverlay.FOOD_LEVEL.type()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || player.m_7500_() || player.m_5833_()) {
            return;
        }
        player.getCapability(IMagmaLevel.INSTANCE).ifPresent(arg_0 -> ClientEvents.lambda$onRenderGui$0((Player)player, event, mc, arg_0));
    }

    @SubscribeEvent
    public static void onEntityRender(RenderLivingEvent.Post<LivingEntity, ?> event) {
        LivingEntity entity = event.getEntity();
        ILivingEntityData data = (ILivingEntityData)entity;
        float lastDamage = data.valoria$getLastDamage();
        if (!entity.m_6095_().m_204039_(TagsRegistry.DAMAGE_INDICATOR_IGNORED) && (((Boolean)ClientConfig.DAMAGE_INDICATOR.get()).booleanValue() || entity instanceof MannequinEntity)) {
            if (!(lastDamage > 0.0f) || entity.f_20916_ <= 0) {
                return;
            }
            Col textColor = Col.red;
            MutableComponent component = Component.m_237113_((String)FORMAT.format(lastDamage));
            for (DamageData damageData : DamageData.dataTypes) {
                if (data.valoria$getLastDamageSource() == null || !damageData.predicate().test(data.valoria$getLastDamageSource())) continue;
                if (damageData.getText() != null) {
                    component = damageData.getText();
                }
                textColor = damageData.getColor();
            }
            ValoriaUtils.renderText(entity, textColor, (Component)component, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), entity.f_20916_);
        }
        if (data.valoria$getMissTime() > 0) {
            ValoriaUtils.renderText(entity, Col.lightGray, (Component)Component.m_237115_((String)"popup.valoria.miss"), event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), data.valoria$getMissTime());
        }
        if (data.valoria$getDodgeTime() > 0) {
            ValoriaUtils.renderText(entity, Col.lightGray, (Component)Component.m_237115_((String)"popup.valoria.dodge"), event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), data.valoria$getDodgeTime());
        }
    }

    @SubscribeEvent
    public static void onClientJoin(ClientPlayerNetworkEvent.LoggingIn event) {
        IModInfo modInfo = (IModInfo)ModList.get().getModFileById("valoria").getMods().get(0);
        VersionChecker.CheckResult result = VersionChecker.getResult((IModInfo)modInfo);
        if (((Boolean)ClientConfig.SHOW_UPDATES.get()).booleanValue() && !modInfo.getVersion().getQualifier().equals("0.0NONE") && result.status().shouldDraw()) {
            String newVersion = result.target().toString();
            MutableComponent message = Component.m_237113_((String)"\ud83e\udeb7 Valoria: ").m_130938_(style -> DotStyle.of().color(Pal.verySoftPink)).m_7220_((Component)Component.m_237110_((String)"tooltip.valoria.update_available", (Object[])new Object[]{newVersion}).m_130940_(ChatFormatting.WHITE));
            MutableComponent actions = Component.m_237115_((String)"tooltip.valoria.download").m_130938_(style -> style.m_131162_(Boolean.valueOf(true)).m_131150_(Valoria.FONT).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/valoria"))).m_7220_((Component)Component.m_237113_((String)" | ").m_7220_((Component)Component.m_237115_((String)"tooltip.valoria.hide").m_130938_(style -> style.m_131162_(Boolean.valueOf(true)).m_131150_(Valoria.FONT).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, new File(ConfigTracker.INSTANCE.getConfigFileName("valoria", ModConfig.Type.CLIENT)).getAbsolutePath())))).m_7220_((Component)Component.m_237113_((String)" | ")).m_7220_((Component)Component.m_237115_((String)"tooltip.valoria.patreon").m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.patreon.com/c/valoriamod")))));
            MutableComponent separator = Component.m_237113_((String)"<->-<->-<->-<->-<->-<->-<->-<->-<->-<->-<->-<->-<->-<->").m_130938_(style -> DotStyle.of().color(Pal.verySoftPink.copy().darker()));
            event.getPlayer().m_5661_((Component)separator, false);
            event.getPlayer().m_5661_((Component)message, false);
            event.getPlayer().m_5661_((Component)Component.m_237119_(), false);
            event.getPlayer().m_5661_((Component)actions, false);
            event.getPlayer().m_5661_((Component)separator, false);
        }
    }

    private static /* synthetic */ void lambda$onRenderGui$0(Player player, RenderGuiOverlayEvent.Post event, Minecraft mc, IMagmaLevel magmaLevel) {
        float max = magmaLevel.getMaxAmount((LivingEntity)player);
        float amount = magmaLevel.getAmount();
        if (max <= 0.0f || amount >= max) {
            return;
        }
        GuiGraphics gui = event.getGuiGraphics();
        int width = event.getWindow().m_85445_();
        int height = event.getWindow().m_85446_();
        int left = width / 2 + 10;
        int startY = height - 39 - 10;
        int bubblesToDraw = (int)Math.ceil(amount);
        RandomSource random = player.m_217043_();
        boolean shouldShake = player.m_20077_() || player.m_6060_();
        int shakeTick = mc.f_91065_.m_93079_();
        for (int i = 0; i < bubblesToDraw; ++i) {
            int row = i / 10;
            int col = i % 10;
            int x = left + col * 8;
            int y = startY - row * 10;
            if (shouldShake && (shakeTick + i * 2) % 7 == 0) {
                y += random.m_188503_(3) - 1;
            }
            gui.m_280163_(FLAME_ICON, x, y, 0.0f, 0.0f, 9, 9, 9, 9);
        }
    }
}

