/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.client.event;

import com.idark.valoria.registries.BlockRegistry;
import com.idark.valoria.registries.level.LevelGen;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
public class FogRenderer {

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onFogRender(ViewportEvent.RenderFog e) {
            Entity entity = e.getCamera().m_90592_();
            if (entity.m_9236_().m_46472_() == LevelGen.VALORIA_KEY) {
                long time = entity.m_9236_().m_46468_() % 24000L;
                float startFadeTime = 8000.0f;
                float endFadeTime = 22000.0f;
                float nearPlaneDefault = 25.0f;
                float nearPlaneMin = 0.0f;
                float farPlaneDefault = 165.5f;
                float farPlaneMin = 45.5f;
                float nearPlane = nearPlaneDefault;
                float farPlane = farPlaneDefault;
                if ((float)time > startFadeTime && (float)time <= endFadeTime) {
                    float fadeFactor = ((float)time - startFadeTime) / (endFadeTime - startFadeTime);
                    nearPlane = Mth.m_14179_((float)fadeFactor, (float)nearPlaneDefault, (float)nearPlaneMin);
                    farPlane = Mth.m_14179_((float)fadeFactor, (float)farPlaneDefault, (float)farPlaneMin);
                } else if (time > 20000L) {
                    float fadeFactor = ((float)time - endFadeTime) / (24000.0f - endFadeTime);
                    nearPlane = Mth.m_14179_((float)fadeFactor, (float)nearPlaneMin, (float)nearPlaneDefault);
                    farPlane = Mth.m_14179_((float)fadeFactor, (float)farPlaneMin, (float)farPlaneDefault);
                }
                if (time > 9000L) {
                    e.setCanceled(true);
                    e.setNearPlaneDistance(nearPlane);
                    e.setFarPlaneDistance(farPlane);
                }
            }
            if (e.getCamera().getBlockAtCamera().m_60713_((Block)BlockRegistry.quicksand.get())) {
                e.setCanceled(true);
                e.setNearPlaneDistance(0.0f);
                e.setFarPlaneDistance(1.5f);
            }
        }

        @SubscribeEvent
        public static void onFogColor(ViewportEvent.ComputeFogColor e) {
            if (e.getCamera().getBlockAtCamera().m_60713_((Block)BlockRegistry.quicksand.get())) {
                e.setRed(0.57f);
                e.setGreen(0.48f);
                e.setBlue(0.34f);
            }
        }
    }
}

