/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.client.model.entity;

import com.idark.valoria.client.model.animations.GolemAnimation;
import com.idark.valoria.client.model.entity.AbstractHierarchicalModel;
import com.idark.valoria.registries.entity.living.elemental.NatureGolem;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class NatureGolemModel<T extends NatureGolem>
extends AbstractHierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart left_arm;
    private final ModelPart right_arm;
    private final ModelPart left_leg;
    private final ModelPart right_leg;

    public NatureGolemModel(ModelPart root) {
        this.root = root;
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.left_arm = root.m_171324_("left_arm");
        this.right_arm = root.m_171324_("right_arm");
        this.left_leg = root.m_171324_("left_leg");
        this.right_leg = root.m_171324_("right_leg");
    }

    @Override
    public ModelPart getHead() {
        return this.head;
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(60, 19).m_171488_(-6.8f, 5.0f, -6.0f, 12.0f, 3.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(60, 34).m_171488_(-5.8f, 3.0f, -5.0f, 10.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(60, 0).m_171488_(-6.8f, -4.0f, -6.0f, 12.0f, 7.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(26, 64).m_171488_(-2.8f, -7.0f, -6.0f, 4.0f, 3.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(58, 83).m_171488_(1.2f, -5.0f, -6.0f, 4.0f, 1.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.8f, (float)-22.0f, (float)0.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-8.0f, -9.0f, -7.0f, 16.0f, 18.0f, 14.0f, new CubeDeformation(0.0f)).m_171514_(0, 32).m_171488_(-8.0f, -9.0f, -7.0f, 16.0f, 18.0f, 14.0f, new CubeDeformation(0.45f)), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(58, 69).m_171488_(-3.75f, -8.5f, -4.0f, 8.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(60, 47).m_171488_(-3.75f, -2.5f, -3.0f, 7.0f, 16.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)11.75f, (float)-5.5f, (float)0.0f));
        PartDefinition left_arm_decor_r1 = left_arm.m_171599_("left_arm_decor_r1", CubeListBuilder.m_171558_().m_171514_(38, 93).m_171480_().m_171488_(-3.0f, -1.5f, 0.0f, 6.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.25f, (float)-11.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition left_arm_decor_r2 = left_arm.m_171599_("left_arm_decor_r2", CubeListBuilder.m_171558_().m_171514_(38, 97).m_171480_().m_171488_(-3.0f, -1.5f, 0.0f, 6.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.25f, (float)-11.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition right_arm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(26, 79).m_171488_(-4.25f, -8.5f, -4.0f, 8.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 64).m_171488_(-3.25f, -2.5f, -3.0f, 7.0f, 16.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-11.75f, (float)-5.5f, (float)0.0f));
        PartDefinition right_arm_decor_r1 = right_arm.m_171599_("right_arm_decor_r1", CubeListBuilder.m_171558_().m_171514_(24, 98).m_171488_(-4.0f, -2.5f, 0.0f, 7.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.25f, (float)-11.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition right_arm_decor_r2 = right_arm.m_171599_("right_arm_decor_r2", CubeListBuilder.m_171558_().m_171514_(24, 93).m_171488_(-3.5f, -2.5f, 0.0f, 7.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.75f, (float)-11.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 86).m_171488_(-3.25f, -11.5f, -3.0f, 6.0f, 13.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(90, 66).m_171488_(-3.25f, 1.5f, -3.5f, 7.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.25f, (float)15.5f, (float)0.0f));
        PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(90, 80).m_171488_(-3.75f, 1.5f, -3.5f, 7.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(86, 47).m_171488_(-2.75f, -11.5f, -3.0f, 6.0f, 13.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.25f, (float)15.5f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T e, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.m_6973_(e, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.animateIdle(((NatureGolem)((Object)e)).idleAnimationState, GolemAnimation.IDLE, limbSwingAmount, ageInTicks, 1.0f);
        this.m_267799_(GolemAnimation.WALK, limbSwing, limbSwingAmount, 6.0f, 6.0f);
        this.m_233381_(((NatureGolem)((Object)e)).attackAnimationState, GolemAnimation.ATTACK1, ageInTicks);
        this.m_233381_(((NatureGolem)((Object)e)).stompAttackAnimationState, GolemAnimation.ATTACK2, ageInTicks);
        this.m_233381_(((NatureGolem)((Object)e)).attackSlapAnimationState, GolemAnimation.ATTACK3, ageInTicks);
        this.m_233381_(((NatureGolem)((Object)e)).groundPunchAnimationState, GolemAnimation.ATTACK4, ageInTicks);
    }
}

