/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.client.particle;

import com.idark.valoria.client.particle.ParticleRegistry;
import com.idark.valoria.registries.TagsRegistry;
import com.idark.valoria.util.Pal;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;
import pro.komaru.tridot.client.gfx.TridotParticles;
import pro.komaru.tridot.client.gfx.particle.GenericParticle;
import pro.komaru.tridot.client.gfx.particle.ParticleBuilder;
import pro.komaru.tridot.client.gfx.particle.behavior.SparkParticleBehavior;
import pro.komaru.tridot.client.gfx.particle.behavior.TrailParticleBehavior;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;
import pro.komaru.tridot.client.gfx.particle.data.LightParticleData;
import pro.komaru.tridot.client.gfx.particle.data.SpinParticleData;
import pro.komaru.tridot.client.render.TridotRenderTypes;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.Tmp;
import pro.komaru.tridot.util.math.ArcRandom;
import pro.komaru.tridot.util.math.Interp;

public class ParticleEffects {
    public static ArcRandom arcRandom = Tmp.rnd;

    public static void confetti(Level level, Vec3 pos) {
        if (level.m_5776_()) {
            ((ParticleBuilder)ParticleBuilder.create((RegistryObject)TridotParticles.SQUARE).setBehavior(SparkParticleBehavior.create().build()).setScaleData(GenericParticleData.create((float)0.0725f, (float)0.025f, (float)0.0f).setEasing((Interp)Interp.bounce).build()).setLifetime(45).setColorData(ColorParticleData.create().setRandomColor().setEasing((Interp)Interp.bounce).build()).randomVelocity(0.125, 0.35, 0.125)).setGravity(0.25f).setHasPhysics(false).repeat(level, pos.f_82479_, pos.f_82480_, pos.f_82481_, 32);
        }
    }

    public static void particles(Level level, Vec3 pos, ColorParticleData data) {
        if (level.m_5776_()) {
            ((ParticleBuilder)ParticleBuilder.create((RegistryObject)TridotParticles.WISP).setColorData(data).setTransparencyData(GenericParticleData.create((float)1.25f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)0.2f, (float)0.1f, (float)0.0f).build()).setLifetime(6).addVelocity(0.0, (double)0.08f, 0.0)).spawn(level, pos.f_82479_, pos.f_82480_, pos.f_82481_);
        }
    }

    public static void fireParticles(Level level, Vec3 pos, ColorParticleData data) {
        if (level.m_5776_()) {
            RandomSource random = level.m_213780_();
            ((ParticleBuilder)ParticleBuilder.create((RegistryObject)TridotParticles.WISP).setTransparencyData(GenericParticleData.create((float)0.25f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)(0.32f + arcRandom.randomValueUpTo(0.2f)), (float)arcRandom.randomValueUpTo(0.2f)).build()).setLifetime(21).setColorData(data).setSpinData(SpinParticleData.create((float)0.5f, (float)0.0f).build()).setVelocity((random.m_188500_() - 0.2) / 30.0, (random.m_188500_() + 0.2) / 6.0, (random.m_188500_() - 0.2) / 30.0)).spawn(level, pos.f_82479_, pos.f_82480_, pos.f_82481_);
        }
    }

    public static void smokeParticles(Level level, Vec3 pos, ColorParticleData data) {
        if (level.m_5776_()) {
            RandomSource random = level.m_213780_();
            ((ParticleBuilder)ParticleBuilder.create(ParticleRegistry.SPHERE).setTransparencyData(GenericParticleData.create((float)0.2f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)(0.25f + arcRandom.randomValueUpTo(0.25f)), (float)arcRandom.randomValueUpTo(0.2f)).build()).setLifetime(32).setColorData(data).setRenderType(TridotRenderTypes.TRANSLUCENT_PARTICLE).setSpinData(SpinParticleData.create((float)0.75f, (float)0.0f).build()).setVelocity((random.m_188500_() - 0.2) / 30.0, (random.m_188500_() + 0.2) / 4.0, (random.m_188500_() - 0.2) / 30.0)).spawn(level, pos.f_82479_, pos.f_82480_, pos.f_82481_);
        }
    }

    public static void transformParticle(Level level, Vec3 pos, ColorParticleData data) {
        if (level.m_5776_()) {
            RandomSource rand = level.m_213780_();
            ((ParticleBuilder)ParticleBuilder.create(ParticleRegistry.TRANSFORM_PARTICLE).randomVelocity((double)0.025f)).setColorData(data).setTransparencyData(GenericParticleData.create((float)0.45f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)0.35f, (float)0.0f).setEasing(Interp.sineIn, Interp.sineOut).build()).setLifetime(16).setSpinData(SpinParticleData.create((float)(0.5f * (float)((rand.m_188500_() - 0.5) * 2.0))).build()).spawn(level, pos.f_82479_, pos.f_82480_, pos.f_82481_);
        }
    }

    public static void leafParticle(Level level, Vec3 pos, ColorParticleData data) {
        if (level.m_5776_()) {
            ParticleBuilder.create(ParticleRegistry.SHADEWOOD_LEAF_PARTICLE).setParticleRenderType(ParticleRenderType.f_107430_).setLightData(LightParticleData.DEFAULT).flatRandomOffset(1.0, 0.0, 1.0).setColorData(data).spawn(level, pos.f_82479_, pos.f_82480_, pos.f_82481_);
        }
    }

    public static void trailMotionSparks(Level level, Vec3 pos, ColorParticleData data) {
        if (level.m_5776_()) {
            RandomSource rand = level.m_213780_();
            ((ParticleBuilder)ParticleBuilder.create((RegistryObject)TridotParticles.TINY_WISP).setTransparencyData(GenericParticleData.create((float)1.0f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)0.125f, (float)Mth.m_216283_((RandomSource)rand, (float)0.1f, (float)0.2f), (float)0.0f).build()).setLifetime(15).setVelocity(rand.m_188500_() / 32.0, (double)0.02f, rand.m_188500_() / 32.0)).setColorData(data).spawn(level, pos.f_82479_, pos.f_82480_, pos.f_82481_);
        }
    }

    public static void fancyTrail(Level level, Vec3 vec3, Vec3 pos) {
        Consumer<GenericParticle> target = p -> {
            double dX = vec3.m_7096_();
            double dY = vec3.m_7098_();
            double dZ = vec3.m_7094_();
            double yaw = Math.atan2(dZ, dX);
            double pitch = Math.atan2(Math.sqrt(dZ * dZ + dX * dX), dY) + Math.PI;
            float speed = 0.1f + (float)p.getAge() * 0.001f;
            double x = Math.sin(pitch) * Math.cos(yaw) * (double)speed;
            double y = Math.cos(pitch) * (double)speed;
            double z = Math.sin(pitch) * Math.sin(yaw) * (double)speed;
            p.setSpeed(p.getSpeed().m_82520_(-x, -y, -z));
        };
        ((ParticleBuilder)((ParticleBuilder)((ParticleBuilder)ParticleBuilder.create((RegistryObject)TridotParticles.TRAIL).setRenderType(TridotRenderTypes.ADDITIVE_PARTICLE_TEXTURE).setBehavior(TrailParticleBehavior.create().build()).setColorData(ColorParticleData.create((Col)Pal.infernal, (Col)Pal.darkMagenta).build()).setTransparencyData(GenericParticleData.create((float)0.6f, (float)0.0f).setEasing(Interp.sineOut).build()).setScaleData(GenericParticleData.create((float)0.5f).setEasing(Interp.sineIn).build()).addTickActor(target).setLifetime(20).randomVelocity(0.25, (double)0.02f, 0.25)).randomOffset((double)0.15f)).setVelocity(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_)).setFriction(0.8f).repeat(level, pos.f_82479_, pos.f_82480_, pos.f_82481_, 15);
    }

    public static void itemParticles(Level level, Vec3 pos, ColorParticleData data) {
        if (level.m_5776_()) {
            RandomSource random = level.m_213780_();
            ((ParticleBuilder)ParticleBuilder.create((RegistryObject)TridotParticles.TINY_WISP).setTransparencyData(GenericParticleData.create((float)0.15f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)(0.05f + arcRandom.randomValueUpTo(0.25f)), (float)arcRandom.randomValueUpTo(0.2f)).build()).setLifetime(6).setColorData(data).setSpinData(SpinParticleData.create((float)(0.5f * (float)((random.m_188500_() - 0.5) * 2.0)), (float)0.0f).build()).setVelocity(random.m_188500_() / 30.0, (double)0.05f, random.m_188500_() / 30.0)).spawn(level, pos.f_82479_, pos.f_82480_, pos.f_82481_);
        }
    }

    public static void swirlTrail(Level level, Vec3 pos, ColorParticleData data) {
        Vec3 vec3 = Vec3.f_82478_;
        Consumer<GenericParticle> fancyTarget = p -> {
            Vec3 particlePos = p.getPos();
            Vec3 toCenter = vec3.m_82546_(particlePos).m_82541_();
            double angle = (double)(p.getAge() + p.hashCode() % 20) * 0.15;
            double radius = 0.05;
            double swirlX = Math.cos(angle) * radius;
            double swirlZ = Math.sin(angle) * radius;
            Vec3 swirlVec = new Vec3(swirlX, 0.0, swirlZ);
            Vec3 attraction = toCenter.m_82490_(0.02);
            Vec3 finalMotion = swirlVec.m_82549_(attraction);
            p.setSpeed(p.getSpeed().m_82549_(finalMotion));
        };
        ((ParticleBuilder)((ParticleBuilder)ParticleBuilder.create((RegistryObject)TridotParticles.TRAIL).setRenderType(TridotRenderTypes.ADDITIVE_PARTICLE_TEXTURE).setBehavior(TrailParticleBehavior.create().build()).setColorData(data).setTransparencyData(GenericParticleData.create((float)1.0f, (float)0.0f).setEasing(Interp.sineOut).build()).setScaleData(GenericParticleData.create((float)0.5f).setEasing(Interp.sineIn).build()).addTickActor(fancyTarget).setLifetime(15).randomVelocity(0.25, 0.25, 0.25)).setVelocity(vec3.f_82479_, 0.0, vec3.f_82481_)).repeat(level, pos.f_82479_, pos.f_82480_, pos.f_82481_, 5);
    }

    public static void smoothTrail(Level level, Consumer<GenericParticle> target, Vec3 pos, ColorParticleData data) {
        ParticleBuilder.create((RegistryObject)TridotParticles.TRAIL).setRenderType(TridotRenderTypes.ADDITIVE_PARTICLE_TEXTURE).setBehavior(TrailParticleBehavior.create().build()).setColorData(data).setTransparencyData(GenericParticleData.create((float)1.0f, (float)0.0f).setEasing((Interp)Interp.bounceOut).build()).setScaleData(GenericParticleData.create((float)0.5f).setEasing(Interp.sineIn).build()).addTickActor(target).setGravity(0.0f).setLifetime(30).repeat(level, pos.f_82479_, pos.f_82480_, pos.f_82481_, 5);
    }

    public static void spawnItemParticles(Level level, ItemEntity entity, @Nullable ParticleType<?> particle, ColorParticleData color) {
        if (level.m_5776_()) {
            RandomSource rand = level.m_213780_();
            Vec3 pos = new Vec3(entity.m_20185_() + (rand.m_188500_() - 0.5) / 6.0, entity.m_20186_() + (double)0.4f, entity.m_20189_());
            if (color != null) {
                if (!entity.m_20069_()) {
                    Col particleColor = new Col(color.r1, color.g1, color.b1);
                    Col particleColorTo = new Col(color.r2, color.g2, color.b2);
                    if (level.m_5776_()) {
                        RandomSource random = level.m_213780_();
                        ((ParticleBuilder)ParticleBuilder.create(particle != null ? particle : (ParticleType)TridotParticles.TINY_WISP.get()).setTransparencyData(GenericParticleData.create((float)0.15f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)(0.05f + arcRandom.randomValueUpTo(0.15f)), (float)arcRandom.randomValueUpTo(0.2f)).build()).setLifetime(6).setColorData(ColorParticleData.create((Col)particleColor, (Col)particleColorTo).build()).setSpinData(SpinParticleData.create((float)(0.5f * (float)((random.m_188500_() - 0.5) * 2.0)), (float)0.0f).build()).setVelocity(random.m_188500_() / 30.0, (double)0.05f, random.m_188500_() / 30.0)).spawn(level, pos.f_82479_, pos.f_82480_, pos.f_82481_);
                    }
                }
                if (entity.m_32055_().m_204117_(TagsRegistry.SMOKE_PARTICLE)) {
                    ((ParticleBuilder)ParticleBuilder.create((RegistryObject)TridotParticles.TINY_WISP).setTransparencyData(GenericParticleData.create((float)0.25f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)(0.05f + arcRandom.randomValueUpTo(0.25f)), (float)arcRandom.randomValueUpTo(0.2f)).build()).setLifetime(16).setRenderType(TridotRenderTypes.TRANSLUCENT_PARTICLE).setColorData(ColorParticleData.create((Col)Col.black, (Col)Pal.smoke).build()).setSpinData(SpinParticleData.create((float)(0.5f * (float)((rand.m_188500_() - 0.5) * 2.0)), (float)0.0f).build()).setVelocity(rand.m_188500_() / 30.0, (double)0.05f, rand.m_188500_() / 30.0)).spawn(level, pos.f_82479_, pos.f_82480_, pos.f_82481_);
                }
            }
        }
    }
}

