/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.client.render.entity;

import com.idark.valoria.client.model.entity.AcornModel;
import com.idark.valoria.registries.entity.projectile.AcornProjectile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class AcornRenderer
extends EntityRenderer<AcornProjectile> {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("valoria", "textures/entity/projectile/acorn.png");
    private final AcornModel<AcornProjectile> model = new AcornModel(AcornModel.createBodyLayer().m_171564_());

    public AcornRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    protected void scale(AcornProjectile pLivingEntity, PoseStack pPoseStack, float pPartialTickTime) {
        float f = pLivingEntity.getSwelling(pPartialTickTime);
        float f1 = 1.0f + Mth.m_14031_((float)(f * 100.0f)) * f * 0.01f;
        f = Mth.m_14036_((float)f, (float)0.0f, (float)1.0f);
        f *= f;
        f *= f;
        float f2 = (1.0f + f * 0.4f) * f1;
        float f3 = (1.0f + f * 0.1f) / f1;
        pPoseStack.m_85841_(f2, f3, f2);
    }

    protected float getWhiteOverlayProgress(AcornProjectile pLivingEntity, float pPartialTicks) {
        float f = pLivingEntity.getSwelling(pPartialTicks);
        return (int)(f * 10.0f) % 2 == 0 ? 0.0f : Mth.m_14036_((float)f, (float)0.5f, (float)1.0f);
    }

    public static int getOverlayCoords(float pU) {
        return OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)pU), (int)OverlayTexture.m_118096_((boolean)false));
    }

    public void render(AcornProjectile pEntity, float pEntityYaw, float pPartialTicks, @NotNull PoseStack pMatrixStack, @NotNull MultiBufferSource pBuffer, int pPackedLight) {
        pMatrixStack.m_85836_();
        if (!(Minecraft.m_91087_().m_91104_() || pEntity.inGround || pEntity.m_20096_())) {
            pEntity.rotationVelocity = Mth.m_14179_((float)pPartialTicks, (float)pEntity.rotationVelocity, (float)(pEntity.rotationVelocity + 10.0f));
        }
        pMatrixStack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14179_((float)pPartialTicks, (float)pEntity.f_19859_, (float)pEntity.m_146908_()) + 90.0f));
        pMatrixStack.m_252781_(Axis.f_252403_.m_252977_(Mth.m_14179_((float)pPartialTicks, (float)(pEntity.f_19860_ - 90.0f + pEntity.rotationVelocity), (float)(pEntity.m_146909_() - 90.0f + pEntity.rotationVelocity))));
        this.scale(pEntity, pMatrixStack, pPartialTicks);
        pMatrixStack.m_85837_(0.0, -1.5, 0.0);
        this.model.m_6839_((Entity)pEntity, pEntity.m_146908_(), 0.0f, pPartialTicks);
        VertexConsumer vertexconsumer = pBuffer.m_6299_(this.model.m_103119_(TEXTURE));
        int i = AcornRenderer.getOverlayCoords(this.getWhiteOverlayProgress(pEntity, pPartialTicks));
        this.model.m_7695_(pMatrixStack, vertexconsumer, pPackedLight, i, 1.0f, 1.0f, 1.0f, 1.0f);
        pMatrixStack.m_85849_();
        super.m_7392_((Entity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull AcornProjectile pEntity) {
        return TEXTURE;
    }
}

