/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.client.ui;

import com.idark.valoria.core.capability.INihilityLevel;
import com.idark.valoria.core.config.ClientConfig;
import com.idark.valoria.registries.ItemsRegistry;
import com.idark.valoria.util.ValoriaUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import pro.komaru.tridot.client.ClientTick;
import pro.komaru.tridot.util.math.Interp;
import pro.komaru.tridot.util.math.Mathf;

@OnlyIn(value=Dist.CLIENT)
public class NihilityMeterRender
extends Gui {
    private final long DISPLAY_DURATION = 100L;
    public final ResourceLocation TEXTURE = new ResourceLocation("valoria", "textures/gui/nihility_meter.png");
    float animTime = 15.0f;
    private boolean isHiding = false;
    private long counter = 100L;
    private static float previousAmount = 0.0f;
    private static float actualPreviousAmount = 0.0f;

    public NihilityMeterRender() {
        super(Minecraft.m_91087_(), Minecraft.m_91087_().m_91291_());
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void renderGameOverlayEvent(RenderGuiEvent.Post event) {
        if (this.f_92986_.f_91073_ == null) {
            return;
        }
        GuiGraphics gui = event.getGuiGraphics();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || !ValoriaUtils.isEquippedCurio(m -> m.m_150930_((Item)ItemsRegistry.nihilityMonitor.get()), (LivingEntity)player)) {
            return;
        }
        player.getCapability(INihilityLevel.INSTANCE).ifPresent(arg_0 -> this.lambda$renderGameOverlayEvent$1(gui, (Player)player, arg_0));
    }

    private void render(GuiGraphics gui, float maxProgress, float currentProgress) {
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_252880_(0.0f, 0.0f, 300.0f);
        int windowHeight = this.f_92986_.m_91268_().m_85446_();
        int windowWidth = this.f_92986_.m_91268_().m_85445_();
        int xMargin = windowWidth - (Integer)ClientConfig.NIHILITY_METER_X.get();
        int yMargin = (Integer)ClientConfig.NIHILITY_METER_Y.get();
        int fillHeight = 45;
        int yCord = windowHeight - yMargin - fillHeight;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172817_);
        float a = this.getScale();
        if (((Boolean)ClientConfig.NIHILITY_METER_ANIMATE.get()).booleanValue()) {
            this.animate(gui, xMargin, yCord);
        }
        int progress = (int)(currentProgress / maxProgress * (float)fillHeight);
        int prevProgress = (int)(actualPreviousAmount / maxProgress * (float)fillHeight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)a);
        gui.m_280163_(this.TEXTURE, xMargin, yCord, (float)NihilityMeterRender.getuOffset(progress), 0.0f, 20, 59, 128, 128);
        if (progress >= 0) {
            float elapsed = (float)((long)ClientTick.ticksInGame - this.counter) + Minecraft.m_91087_().getPartialTick();
            float progress2 = Mathf.clamp((float)((elapsed - 20.0f) / (float)Math.abs(progress - prevProgress) / 1.5f));
            if (this.isHiding) {
                progress2 = 1.0f;
            }
            progress = (int)Mathf.lerp((float)prevProgress, (float)progress, (float)progress2);
            int vOffset = 64 + (fillHeight - progress);
            int yOffset = yCord + 6 + (fillHeight - progress);
            int vOffset2 = 64 + (fillHeight - prevProgress);
            int yOffset2 = yCord + 6 + (fillHeight - prevProgress);
            if (prevProgress < progress) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)a);
                gui.m_280163_(this.TEXTURE, xMargin + 7, yOffset, 0.0f, (float)vOffset, 6, progress, 128, 128);
                RenderSystem.setShaderColor((float)1.25f, (float)1.25f, (float)1.25f, (float)a);
                gui.m_280163_(this.TEXTURE, xMargin + 7, yOffset2, 0.0f, (float)vOffset2, 6, prevProgress, 128, 128);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)a);
            } else {
                RenderSystem.setShaderColor((float)0.15f, (float)0.15f, (float)0.15f, (float)a);
                gui.m_280163_(this.TEXTURE, xMargin + 7, yOffset2, 0.0f, (float)vOffset2, 6, prevProgress, 128, 128);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)a);
                gui.m_280163_(this.TEXTURE, xMargin + 7, yOffset, 0.0f, (float)vOffset, 6, progress, 128, 128);
            }
            float percentage = (float)progress / (float)fillHeight * 100.0f;
            int color = NihilityMeterRender.getColor(percentage);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)a);
            gui.m_280137_(this.f_92986_.f_91062_, NihilityMeterRender.getPercentageText(percentage), xMargin + 11, yCord + 62, color);
        }
        gui.m_280168_().m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private float getScale() {
        float timeElapsed = (float)((long)ClientTick.ticksInGame - this.counter) + Minecraft.m_91087_().getPartialTick();
        float animationProgress = Mth.m_14036_((float)(timeElapsed / this.animTime), (float)0.0f, (float)1.0f);
        Interp interp = Interp.smoother;
        float scale = interp.apply(animationProgress);
        if (this.isHiding) {
            scale = 1.0f - scale;
        }
        return scale;
    }

    private void animate(GuiGraphics gui, int xMargin, int yCord) {
        float timeElapsed = (float)((long)ClientTick.ticksInGame - this.counter) + Minecraft.m_91087_().getPartialTick();
        float animationProgress = Mth.m_14036_((float)(timeElapsed / this.animTime), (float)0.0f, (float)1.0f);
        Interp interp = Interp.smoother;
        float scale = interp.apply(animationProgress);
        if (this.isHiding) {
            scale = 1.0f - scale;
        }
        gui.m_280168_().m_252880_(0.0f, 10.0f * Interp.smoother.apply(1.0f - scale), 0.0f);
        RenderSystem.setShaderColor((float)scale, (float)scale, (float)scale, (float)scale);
        gui.m_280168_().m_85837_((double)(xMargin + 10), (double)yCord + 29.5, 0.0);
        gui.m_280168_().m_85841_(1.0f + (1.0f - scale) * 0.25f, scale * scale, 1.0f);
        gui.m_280168_().m_85837_((double)(-(xMargin + 10)), -((double)yCord + 29.5), 0.0);
    }

    @NotNull
    private static String getPercentageText(float percentage) {
        String percentageText = percentage < 10.0f ? String.format("%.1f%%", Float.valueOf(percentage)) : String.format("%.0f%%", Float.valueOf(percentage));
        return percentageText;
    }

    private static int getColor(float percentage) {
        int color = -1;
        color = percentage < 25.0f ? -16711936 : (percentage < 75.0f ? -256 : -65536);
        return color;
    }

    private static int getuOffset(int progress) {
        int uOffset = 0;
        if (progress >= 75) {
            uOffset = 62;
        } else if (progress >= 45) {
            uOffset = 30;
        }
        return uOffset;
    }

    private /* synthetic */ void lambda$renderGameOverlayEvent$1(GuiGraphics gui, Player player, INihilityLevel n) {
        boolean isShown;
        float clientAmount = n.getAmount();
        boolean bl = isShown = (Boolean)ClientConfig.NIHILITY_METER_ALWAYS_VISIBLE.get() != false || clientAmount > 0.0f;
        if (isShown) {
            actualPreviousAmount = previousAmount;
            previousAmount = clientAmount;
            this.counter = ClientTick.ticksInGame;
            this.isHiding = true;
        }
        if (!isShown) {
            if (clientAmount != previousAmount) {
                actualPreviousAmount = previousAmount;
                previousAmount = clientAmount;
                if ((long)ClientTick.ticksInGame > this.counter + 100L) {
                    this.counter = ClientTick.ticksInGame;
                    this.isHiding = false;
                }
            } else if ((long)ClientTick.ticksInGame > this.counter + 100L && !this.isHiding) {
                this.counter = ClientTick.ticksInGame;
                this.isHiding = true;
            }
        }
        this.render(gui, n.getMaxAmount((LivingEntity)player), clientAmount);
    }
}

