/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.client.ui.menus;

import com.idark.valoria.core.network.PacketHandler;
import com.idark.valoria.core.network.packets.AlchemyUpgradePacket;
import com.idark.valoria.core.network.packets.particle.AlchemyUpgradeParticlePacket;
import com.idark.valoria.registries.MenuRegistry;
import com.idark.valoria.registries.block.types.AlchemyStationBlock;
import com.idark.valoria.registries.item.recipe.AlchemyRecipe;
import com.idark.valoria.registries.item.recipe.AlchemyUpgradeRecipe;
import com.idark.valoria.registries.item.recipe.RecipeData;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import pro.komaru.tridot.client.render.gui.screen.ContainerMenuBase;

public class AlchemyStationMenu
extends ContainerMenuBase {
    public final List<AlchemyRecipe> allRecipes;
    public final int blockLevel;
    private final Player player;
    private final BlockPos pos;
    private final Level level;
    private final ContainerLevelAccess access;

    public AlchemyStationMenu(int windowId, Inventory playerInventory) {
        this(windowId, BlockPos.f_121853_, playerInventory, ContainerLevelAccess.f_39287_, 0);
    }

    public AlchemyStationMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, data.m_130135_(), playerInventory, ContainerLevelAccess.m_39289_((Level)playerInventory.f_35978_.m_9236_(), (BlockPos)data.m_130135_()), data.readInt());
    }

    public AlchemyStationMenu(int windowId, BlockPos pos, Inventory playerInventory, ContainerLevelAccess access, int blockLevel) {
        super((MenuType)MenuRegistry.ALCHEMY.get(), windowId);
        this.pos = pos;
        this.player = playerInventory.f_35978_;
        this.level = playerInventory.f_35978_.m_9236_();
        this.access = access;
        this.allRecipes = this.level.m_7465_().m_44013_((RecipeType)AlchemyRecipe.Type.INSTANCE);
        this.blockLevel = blockLevel;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 114 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, 172));
        }
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getBlockLevel() {
        return this.blockLevel;
    }

    public Level getLevel() {
        return this.level;
    }

    public Player getPlayer() {
        return this.player;
    }

    public List<AlchemyRecipe> getAllRecipes() {
        return this.allRecipes;
    }

    public boolean m_6875_(Player pPlayer) {
        return this.stillValid(this.access, pPlayer, b -> b instanceof AlchemyStationBlock);
    }

    private boolean stillValid(ContainerLevelAccess pAccess, Player pPlayer, Predicate<Block> pTargetBlock) {
        return (Boolean)pAccess.m_39299_((p_38916_, p_38917_) -> pTargetBlock.test(p_38916_.m_8055_(p_38917_).m_60734_()) && pPlayer.m_20275_((double)p_38917_.m_123341_() + 0.5, (double)p_38917_.m_123342_() + 0.5, (double)p_38917_.m_123343_() + 0.5) <= 64.0, (Object)true);
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        return ItemStack.f_41583_;
    }

    public boolean checkAndSetAvailability(AlchemyRecipe recipe) {
        Inventory inv = this.player.m_150109_();
        boolean isEnough = true;
        for (Pair<Ingredient, RecipeData> entry : recipe.getInputs()) {
            Ingredient ingredient = (Ingredient)entry.getFirst();
            int requiredCount = ((RecipeData)entry.getSecond()).count;
            int currentCount = 0;
            for (int i = 0; i < inv.m_6643_(); ++i) {
                ItemStack stack = inv.m_8020_(i);
                if (!ingredient.test(stack)) continue;
                currentCount += stack.m_41613_();
            }
            ((RecipeData)entry.getSecond()).setCurrent(currentCount);
            ((RecipeData)entry.getSecond()).setEnough(currentCount >= requiredCount);
            if (((RecipeData)entry.getSecond()).isEnough && this.getBlockLevel() >= recipe.getLevel()) continue;
            isEnough = false;
        }
        return isEnough;
    }

    private void consumeMaterials(AlchemyRecipe recipe) {
        Inventory inv = this.player.m_150109_();
        for (Pair<Ingredient, RecipeData> entry : recipe.getInputs()) {
            Ingredient ingredient = (Ingredient)entry.getFirst();
            int requiredCount = ((RecipeData)entry.getSecond()).count;
            for (int i = 0; i < inv.m_6643_() && requiredCount > 0; ++i) {
                ItemStack stack = inv.m_8020_(i);
                if (!ingredient.test(stack)) continue;
                int consumeAmount = Math.min(requiredCount, stack.m_41613_());
                stack.m_41774_(consumeAmount);
                requiredCount -= consumeAmount;
            }
        }
    }

    public boolean checkAndSetAvailability(AlchemyUpgradeRecipe recipe) {
        Inventory inv = this.player.m_150109_();
        boolean isEnough = true;
        for (Pair<Ingredient, RecipeData> entry : recipe.getInputs()) {
            Ingredient ingredient = (Ingredient)entry.getFirst();
            int requiredCount = ((RecipeData)entry.getSecond()).count;
            int currentCount = 0;
            for (int i = 0; i < inv.m_6643_(); ++i) {
                ItemStack stack = inv.m_8020_(i);
                if (!ingredient.test(stack)) continue;
                currentCount += stack.m_41613_();
            }
            ((RecipeData)entry.getSecond()).setCurrent(currentCount);
            ((RecipeData)entry.getSecond()).setEnough(currentCount >= requiredCount);
            if (((RecipeData)entry.getSecond()).isEnough) continue;
            isEnough = false;
        }
        return isEnough;
    }

    private void consumeMaterials(AlchemyUpgradeRecipe recipe) {
        Inventory inv = this.player.m_150109_();
        for (Pair<Ingredient, RecipeData> entry : recipe.getInputs()) {
            Ingredient ingredient = (Ingredient)entry.getFirst();
            int requiredCount = ((RecipeData)entry.getSecond()).count;
            for (int i = 0; i < inv.m_6643_() && requiredCount > 0; ++i) {
                ItemStack stack = inv.m_8020_(i);
                if (!ingredient.test(stack)) continue;
                int consumeAmount = Math.min(requiredCount, stack.m_41613_());
                stack.m_41774_(consumeAmount);
                requiredCount -= consumeAmount;
            }
        }
    }

    public void tryUpgrade(ServerPlayer player, ResourceLocation recipeId) {
        AlchemyUpgradeRecipe recipe;
        Optional<AlchemyUpgradeRecipe> recipeHolder = this.level.m_7465_().m_44043_(recipeId).filter(r -> r instanceof AlchemyUpgradeRecipe).map(r -> (AlchemyUpgradeRecipe)r);
        if (recipeHolder.isPresent() && this.checkAndSetAvailability(recipe = recipeHolder.get())) {
            this.consumeMaterials(recipe);
            ItemStack result = recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41777_();
            player.m_150109_().m_150079_(result);
            PacketHandler.sendToTracking((Level)player.m_284548_(), this.pos, new AlchemyUpgradeParticlePacket(this.blockLevel + 1, this.pos.m_123341_(), this.pos.m_123342_(), this.pos.m_123343_()));
            PacketHandler.sendToServer(new AlchemyUpgradePacket(this.blockLevel));
            this.m_38946_();
        }
    }

    public Optional<AlchemyUpgradeRecipe> getUpgrade(ResourceLocation recipeId) {
        return this.level.m_7465_().m_44043_(recipeId).filter(r -> r instanceof AlchemyUpgradeRecipe).map(r -> (AlchemyUpgradeRecipe)r);
    }

    public void tryCraftRecipe(ServerPlayer player, ResourceLocation recipeId) {
        AlchemyRecipe recipe;
        Optional<AlchemyRecipe> recipeHolder = this.level.m_7465_().m_44043_(recipeId).filter(r -> r instanceof AlchemyRecipe).map(r -> (AlchemyRecipe)r);
        if (recipeHolder.isPresent() && this.checkAndSetAvailability(recipe = recipeHolder.get())) {
            this.consumeMaterials(recipe);
            ItemStack result = recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41777_();
            player.m_150109_().m_150079_(result);
            this.m_38946_();
        }
    }
}

