/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.client.ui.screen;

import com.idark.valoria.Valoria;
import com.idark.valoria.client.ui.menus.HeavyWorkbenchMenu;
import com.idark.valoria.client.ui.screen.Categories;
import com.idark.valoria.core.network.PacketHandler;
import com.idark.valoria.core.network.packets.HeavyWorkbenchCraftPacket;
import com.idark.valoria.registries.SoundsRegistry;
import com.idark.valoria.registries.item.component.MaterialListComponent;
import com.idark.valoria.registries.item.recipe.WorkbenchRecipe;
import com.idark.valoria.util.ValoriaUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;
import pro.komaru.tridot.util.Tmp;
import pro.komaru.tridot.util.phys.AbsRect;
import pro.komaru.tridot.util.struct.data.Seq;

public class HeavyWorkbenchScreen
extends AbstractContainerScreen<HeavyWorkbenchMenu> {
    private static final ResourceLocation TEXTURE = Valoria.loc("textures/gui/container/heavy_workbench.png");
    private final Seq<BlueprintData> renderedRecipes = Seq.with();
    private BlueprintData hoveredRecipe = null;
    private BlueprintData clickedBlueprintO;
    private Categories chosen = Categories.ALL;
    private String lastSearch = "";
    private int errorVariant = 0;
    private EditBox searchBox;
    private static final Component SEARCH_HINT = Component.m_237115_((String)"gui.recipebook.search_hint").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY);
    private final int recipesOffsetX = 6;
    private final int recipesOffsetY = 18;
    private final int recipeSlotWidth = 20;
    private final int recipeSlotHeight = 19;
    private final int scrollbarHeight = 84;
    private boolean scrolling = false;
    private float scrollDistance = 0.0f;
    private final int visible = 7;
    private final int recipeAreaWidth = 175;
    private final int recipeAreaHeight = 85;
    private final int gridXOffset = 2;
    private final int gridYOffset = 2;
    private final int slotSize = 22;
    private final int recipeRowHeight;
    private final ContainerListener listener;

    public HeavyWorkbenchScreen(HeavyWorkbenchMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        Objects.requireNonNull(this);
        this.recipeRowHeight = this.recipeSlotHeight + 1 + 2;
        this.listener = new ContainerListener(){

            public void m_7934_(AbstractContainerMenu menu, int index, ItemStack stack) {
                HeavyWorkbenchScreen.this.updateCraftableRecipes();
            }

            public void m_142153_(AbstractContainerMenu menu, int index, int value) {
            }
        };
        this.f_97727_ = 196;
        this.f_97726_ = 176;
        ((HeavyWorkbenchMenu)this.f_97732_).m_38893_(this.listener);
        if (inventory.m_7983_()) {
            this.updateCraftableRecipes();
        }
    }

    public void m_7856_() {
        super.m_7856_();
        String s = this.getSearchValue();
        this.searchBox = new EditBox(this.f_96541_.f_91062_, this.getGuiLeft() + 4, this.getGuiTop() - 20, 171, 12, (Component)Component.m_237115_((String)"itemGroup.search"));
        this.searchBox.m_94199_(50);
        this.searchBox.m_94194_(true);
        this.searchBox.m_94202_(0xFFFFFF);
        this.searchBox.m_94144_(s);
        this.searchBox.m_257771_(SEARCH_HINT);
        this.m_7787_((GuiEventListener)this.searchBox);
    }

    @NotNull
    private String getSearchValue() {
        return this.searchBox != null ? this.searchBox.m_94155_() : "";
    }

    public boolean m_5534_(char pCodePoint, int pModifiers) {
        if (this.searchBox != null && this.searchBox.m_93696_()) {
            String s = this.getSearchValue();
            if (this.searchBox.m_5534_(pCodePoint, pModifiers)) {
                if (!Objects.equals(s, this.searchBox.m_94155_())) {
                    this.playSound(SoundEvents.f_11718_, 0.25f, 1.0f);
                    this.updateCraftableRecipes();
                }
                return true;
            }
        }
        return super.m_5534_(pCodePoint, pModifiers);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        String s = this.searchBox.m_94155_();
        if (this.searchBox.m_7933_(pKeyCode, pScanCode, pModifiers)) {
            if (!Objects.equals(s, this.searchBox.m_94155_())) {
                this.playSound(SoundEvents.f_11718_, 0.25f, 1.0f);
                this.updateCraftableRecipes();
            }
            return true;
        }
        return this.searchBox != null && this.searchBox.m_93696_() && this.searchBox.m_94213_() && pKeyCode != 256 || super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public void m_7861_() {
        super.m_7861_();
        ((HeavyWorkbenchMenu)this.f_97732_).m_38943_(this.listener);
    }

    public float getScrollPercent() {
        return this.scrollDistance / 22.0f;
    }

    private String getRecipeName(WorkbenchRecipe recipe) {
        ItemStack resultStack = recipe.m_8043_(this.f_96541_.f_91073_.m_9598_());
        if (resultStack.m_41619_()) {
            return "";
        }
        return resultStack.m_41786_().getString();
    }

    public void updateCraftableRecipes() {
        Seq craftableRecipes = Seq.with();
        Seq nonCraftableRecipes = Seq.with();
        for (WorkbenchRecipe recipeHolder : ((HeavyWorkbenchMenu)this.f_97732_).getAllRecipes()) {
            String s = this.getSearchValue();
            BlueprintData data = new BlueprintData(recipeHolder);
            if (s.isEmpty()) {
                if (!recipeHolder.getCategory().equals(this.chosen.category) && !this.chosen.equals((Object)Categories.ALL)) continue;
                this.addRecipes(recipeHolder, (Seq<BlueprintData>)craftableRecipes, data, (Seq<BlueprintData>)nonCraftableRecipes);
                continue;
            }
            String recipeName = this.getRecipeName(recipeHolder).toLowerCase();
            boolean searchMatch = recipeName.contains(s.toLowerCase());
            if (!searchMatch || !recipeHolder.getCategory().equals(this.chosen.category) && !this.chosen.equals((Object)Categories.ALL)) continue;
            this.addRecipes(recipeHolder, (Seq<BlueprintData>)craftableRecipes, data, (Seq<BlueprintData>)nonCraftableRecipes);
        }
        craftableRecipes.sort(Comparator.comparing(b -> b.recipe.m_6423_()));
        nonCraftableRecipes.sort(Comparator.comparing(b -> b.recipe.m_6423_()));
        this.renderedRecipes.clear();
        this.renderedRecipes.addAll(craftableRecipes).addAll(nonCraftableRecipes);
    }

    private void addRecipes(WorkbenchRecipe recipe, Seq<BlueprintData> craftableRecipes, BlueprintData data, Seq<BlueprintData> nonCraftableRecipes) {
        if (((HeavyWorkbenchMenu)this.f_97732_).checkAndSetAvailability(recipe)) {
            craftableRecipes.add((Object)data);
        } else {
            nonCraftableRecipes.add((Object)data);
        }
    }

    protected void m_181908_() {
        super.m_181908_();
        this.searchBox.m_94120_();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.hoveredRecipe = this.getBlueprintAt(mouseX, mouseY);
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        pGuiGraphics.m_280614_(this.f_96547_, (Component)this.f_96539_.m_6881_().m_130946_(": ").m_7220_((Component)Component.m_237115_((String)("menu.valoria.category." + this.chosen.category))), this.f_97728_, this.f_97729_ + 2, -6250336, false);
        pGuiGraphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_ + 30, 0x404040, false);
    }

    protected void m_280072_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280072_(guiGraphics, mouseX, mouseY);
        if (this.hoveredRecipe != null && this.hoveredRecipe.isVisible()) {
            WorkbenchRecipe recipe = this.hoveredRecipe.recipe;
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            Optional<Object> comp = Optional.empty();
            ItemStack result = recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_);
            tooltip.add(result.m_41786_().m_6881_().m_130948_(result.m_41611_().m_7383_()));
            tooltip.add(Component.m_237119_());
            tooltip.add(Component.m_237110_((String)"tooltip.tridot.shift_for_details", (Object[])new Object[]{Component.m_237115_((String)"key.keyboard.left.shift").getString()}).m_130940_(ChatFormatting.GRAY));
            if (!recipe.getInputs().isEmpty()) {
                ((HeavyWorkbenchMenu)this.f_97732_).checkAndSetAvailability(recipe);
                comp = Optional.of(new MaterialListComponent(recipe.getInputs()));
            } else {
                Valoria.LOGGER.warn("Recipe - {}, has no Inputs", (Object)this.hoveredRecipe.recipe.m_6423_());
            }
            if (!Screen.m_96638_()) {
                guiGraphics.m_280677_(this.f_96547_, tooltip, comp, mouseX, mouseY);
            } else {
                guiGraphics.renderTooltip(this.f_96547_, result.m_41651_(null, (TooltipFlag)TooltipFlag.f_256752_), Optional.empty(), result, mouseX, mouseY);
            }
        }
        for (Categories category : Categories.values()) {
            int y;
            int x = this.getGuiLeft() - 19;
            if (!this.isHover(mouseX, mouseY, x, y = this.getGuiTop() + 6 + category.ordinal() * 22, 22, 20)) continue;
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.m_237115_((String)("menu.valoria.category." + category.category)));
            guiGraphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    protected void m_7286_(GuiGraphics gui, float partialTick, int mouseX, int mouseY) {
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        int scrollbarTop = top + 8;
        int scrollbarLeft = left + 163;
        gui.m_280218_(TEXTURE, left, top, 0, 0, this.f_97726_, this.f_97727_);
        this.renderScroll(gui, scrollbarLeft, scrollbarTop, mouseX, mouseY);
        this.searchBox.m_88315_(gui, mouseX, mouseY, partialTick);
        int recipeAreaX = this.getRecipeAreaX(left);
        int recipeAreaY = this.getRecipeAreaY(top);
        this.scissorsOn(gui, gui.m_280168_(), recipeAreaX, recipeAreaY + 25, this.recipeAreaWidth, this.recipeAreaHeight);
        this.renderGrid(gui, left, top);
        this.scissorsOff(gui);
        String s = this.getSearchValue();
        if (this.renderedRecipes.isEmpty()) {
            int x = this.f_96543_ / 2;
            int y = this.f_96544_ / 2;
            if (!this.lastSearch.equals(s)) {
                this.errorVariant = Tmp.rnd.nextInt(0, 11);
                this.lastSearch = s;
            }
            gui.m_280653_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)("tooltip.valoria.not_found." + this.errorVariant)), x - 5, y - 50, -1);
        }
        Categories[] categoriesArray = Categories.values();
        int n = categoriesArray.length;
        for (int i = 0; i < n; ++i) {
            int x = left - 19;
            Categories category = categoriesArray[i];
            int y = top + 6 + category.ordinal() * 22;
            boolean flag = this.isHover(mouseX, mouseY, x, y, 22, 20);
            if (!flag && this.chosen != category) {
                gui.m_280218_(TEXTURE, x, y, 234, 0, 22, 20);
                gui.m_280203_(category.item.m_7968_(), x + 3, y + 2);
                continue;
            }
            gui.m_280218_(TEXTURE, x - 6, y, 228, 20, 28, 20);
            gui.m_280203_(category.item.m_7968_(), x - 3, y + 2);
        }
    }

    public boolean insideScrollbar(int scrollbarLeft, int scrollbarTop, int mouseX, int mouseY) {
        int maxScroll = this.getMaxScroll();
        float scrollPercentage = maxScroll > 0 ? this.getScrollPercent() / (float)maxScroll : 0.0f;
        int scrollbarThumbY = (int)(scrollPercentage * 74.0f);
        return this.isHover(mouseX, mouseY, scrollbarLeft, scrollbarTop + scrollbarThumbY, 7, 15);
    }

    public void renderScroll(GuiGraphics gui, int scrollbarLeft, int scrollbarTop, int mouseX, int mouseY) {
        gui.m_280218_(TEXTURE, scrollbarLeft, scrollbarTop, 176, 0, 7, 84);
        int maxScroll = this.getMaxScroll();
        float scrollPercentage = maxScroll > 0 ? this.getScrollPercent() / (float)maxScroll : 0.0f;
        int scrollbarThumbY = (int)(scrollPercentage * 74.0f);
        if (this.insideScrollbar(scrollbarLeft, scrollbarTop, mouseX, mouseY)) {
            gui.m_280218_(TEXTURE, scrollbarLeft, scrollbarTop + scrollbarThumbY, 190, 0, 7, 15);
        } else {
            gui.m_280218_(TEXTURE, scrollbarLeft, scrollbarTop + scrollbarThumbY, 183, 0, 7, 15);
        }
    }

    public boolean isHover(double mouseX, double mouseY, int x, int y, int width, int height) {
        return mouseX >= (double)x && mouseX <= (double)(x + width) && mouseY >= (double)y && mouseY <= (double)(y + height);
    }

    public boolean isVisible(GuiGraphics gui, int x, int y) {
        return ValoriaUtils.isVisibleInScissor(gui, x, y, 20, 19, this.getRecipeAreaX(this.getGuiLeft()), this.getRecipeAreaY(this.getGuiTop()), 175, 85);
    }

    private void renderGrid(GuiGraphics gui, int left, int top) {
        for (int i = 0; i < this.renderedRecipes.size; ++i) {
            int row = i / this.visible;
            int col = i % this.visible;
            BlueprintData blueprintData = (BlueprintData)this.renderedRecipes.get(i);
            WorkbenchRecipe recipe = blueprintData.recipe;
            Objects.requireNonNull(this);
            int x = left + this.recipesOffsetX + col * (this.recipeSlotWidth + 2);
            int y = top + this.recipesOffsetY + row * this.recipeRowHeight - (int)this.scrollDistance;
            if (this.isVisible(gui, x, y)) {
                boolean isClicked;
                blueprintData.setVisible(true);
                if (this.hoveredRecipe != null && recipe.equals(this.hoveredRecipe.recipe)) {
                    gui.m_280218_(TEXTURE, x - 1, y - 1, 0, 215, this.recipeSlotWidth + 2, this.recipeSlotHeight + 2);
                }
                boolean bl = isClicked = this.clickedBlueprintO == blueprintData;
                gui.m_280218_(TEXTURE, x, y, isClicked ? 0 : (((HeavyWorkbenchMenu)this.f_97732_).checkAndSetAvailability(recipe) ? 20 : 40), 196, this.recipeSlotWidth, this.recipeSlotHeight);
                ItemStack result = recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_);
                gui.m_280203_(result, x + 2, y + 2);
                continue;
            }
            blueprintData.setVisible(false);
        }
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0) {
            this.scrolling = false;
        }
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrolling) {
            int scrollStepHeight = 22;
            int maxScrollSteps = this.getMaxScroll();
            double maxScrollPixels = maxScrollSteps * 22;
            this.scrollDistance += (float)pDragY;
            this.scrollDistance = (float)Math.max(0.0, (double)this.scrollDistance);
            this.scrollDistance = (float)Math.min((double)this.scrollDistance, maxScrollPixels);
            return true;
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int maxScroll = this.getMaxScroll();
        if (this.getScrollPercent() < (float)maxScroll && delta == -1.0) {
            this.scrollDistance += 22.0f;
        } else if (this.scrollDistance > 0.0f && delta == 1.0) {
            this.scrollDistance -= 22.0f;
        }
        if (this.getScrollPercent() > (float)maxScroll) {
            this.scrollDistance = maxScroll * 22;
        } else if (this.scrollDistance < 0.0f) {
            this.scrollDistance = 0.0f;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        BlueprintData clickedBlueprint = this.hoveredRecipe;
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        if (button == 0) {
            int scrollbarTop;
            int scrollbarLeft;
            if (clickedBlueprint != null && clickedBlueprint.isVisible()) {
                if (this.clickedBlueprintO == clickedBlueprint && ((HeavyWorkbenchMenu)this.f_97732_).checkAndSetAvailability(clickedBlueprint.recipe)) {
                    this.playSound(SoundEvents.f_12471_);
                    PacketHandler.sendToServer(new HeavyWorkbenchCraftPacket(this.hoveredRecipe.recipe));
                    return true;
                }
                this.clickedBlueprintO = this.hoveredRecipe;
                this.playSound((SoundEvent)SoundsRegistry.UI_CLICK.get(), 0.15f, 2.0f);
            }
            if (this.insideScrollbar(scrollbarLeft = left + 163, scrollbarTop = top + 8, (int)mouseX, (int)mouseY)) {
                this.scrolling = true;
            }
            Categories[] categoriesArray = Categories.values();
            int n = categoriesArray.length;
            for (int i = 0; i < n; ++i) {
                int x = left - 19;
                Categories category = categoriesArray[i];
                int y = top + 6 + category.ordinal() * 22;
                if (!this.isHover(mouseX, mouseY, x, y, 24, 20)) continue;
                this.chosen = category;
                this.scrollDistance = 0.0f;
                this.playSound((SoundEvent)SoundsRegistry.UI_CLICK.get(), 0.25f, 1.65f);
                this.updateCraftableRecipes();
            }
        }
        if (this.searchBox != null && this.searchBox.m_142518_()) {
            this.searchBox.m_93692_(false);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void scissorsOn(GuiGraphics gui, PoseStack pose, int x, int y, int w, int h) {
        AbsRect r = AbsRect.xywhDef((float)x, (float)y, (float)w, (float)h).pose(pose);
        gui.m_280588_((int)r.x, (int)r.y + 2, (int)r.x2, (int)r.y2 - 8);
    }

    public void scissorsOff(GuiGraphics gui) {
        gui.m_280618_();
    }

    private BlueprintData getBlueprintAt(double mouseX, double mouseY) {
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        int mouseXRelative = (int)mouseX - left;
        int mouseYRelative = (int)mouseY - top;
        int viewportX = this.recipesOffsetX;
        int viewportY = this.recipesOffsetY;
        Objects.requireNonNull(this);
        int viewportWidth = this.visible * (this.recipeSlotWidth + 2);
        if (mouseXRelative < viewportX || mouseXRelative >= viewportX + viewportWidth || mouseYRelative < viewportY || mouseYRelative >= viewportY + this.recipeAreaHeight) {
            return null;
        }
        for (int i = 0; i < this.renderedRecipes.size; ++i) {
            int row = i / this.visible;
            int col = i % this.visible;
            Objects.requireNonNull(this);
            int itemX = this.recipesOffsetX + col * (this.recipeSlotWidth + 2);
            int itemY = this.recipesOffsetY + row * this.recipeRowHeight - (int)this.scrollDistance;
            if (mouseXRelative < itemX || mouseXRelative >= itemX + this.recipeSlotWidth || mouseYRelative < itemY || mouseYRelative >= itemY + this.recipeSlotHeight) continue;
            return (BlueprintData)this.renderedRecipes.get(i);
        }
        return null;
    }

    public int getMaxScroll() {
        int total = (int)Math.ceil((double)this.renderedRecipes.size / (double)this.visible);
        return Math.max(0, total - 1);
    }

    public int getRecipeAreaY(int top) {
        return top + 33;
    }

    public int getRecipeAreaX(int left) {
        return left + 88;
    }

    public void playSound(SoundEvent soundEvent) {
        this.f_96541_.f_91074_.m_216990_(soundEvent);
    }

    public void playSound(SoundEvent soundEvent, float vol, float pitch) {
        this.f_96541_.f_91074_.m_5496_(soundEvent, vol, pitch);
    }

    public static class BlueprintData {
        private final WorkbenchRecipe recipe;
        private boolean visible = true;

        public BlueprintData(WorkbenchRecipe recipe) {
            this.recipe = recipe;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }
    }
}

