/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.client.ui.screen.book.codex;

import com.idark.valoria.Valoria;
import com.idark.valoria.api.events.CodexEvent;
import com.idark.valoria.api.unlockable.types.Unlockable;
import com.idark.valoria.client.ui.screen.book.BookGui;
import com.idark.valoria.client.ui.screen.book.Chapter;
import com.idark.valoria.client.ui.screen.book.codex.CodexEntries;
import com.idark.valoria.client.ui.screen.book.codex.CodexEntry;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import pro.komaru.tridot.api.render.DotScreen;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.math.Interp;
import pro.komaru.tridot.util.math.Mathf;

@OnlyIn(value=Dist.CLIENT)
public class Codex
extends DotScreen {
    public static Codex screen;
    public int backgroundWidth = 1024;
    public int backgroundHeight = 1024;
    public int frameWidth = 276;
    public int frameHeight = 180;
    public int insideWidth = 262;
    public int insideHeight = 164;
    public float xModifier = 0.75f;
    public float yModifier = 0.75f;
    public float xOffset;
    public float yOffset;
    public int entries = 104;
    public float animTime = 10.0f;
    public Player player;
    public ResourceLocation FRAME = Valoria.loc("textures/gui/book/frame.png");
    private float openedAtTick = -1.0f;
    private float hoverProgress = 0.0f;
    private long lastTime = 0L;

    public Codex() {
        this.assetsId = "valoria";
    }

    public static Codex getInstance() {
        if (screen == null) {
            CodexEntries.initChapters();
            screen = new Codex();
        }
        return screen;
    }

    public void sound(Supplier<SoundEvent> soundEvent, float volume, float pitch) {
        Minecraft.m_91087_().f_91074_.m_6330_(soundEvent.get(), SoundSource.PLAYERS, volume, pitch);
    }

    public void open(Player player) {
        this.player = player;
        CodexEntries.init();
        Codex codex = Codex.getInstance();
        codex.openedAtTick = (float)codex.tick + codex.mc().getPartialTick();
        Minecraft.m_91087_().m_91152_((Screen)codex);
        codex.sound(() -> SoundEvents.f_11713_, 1.0f, 1.0f);
    }

    public float time() {
        return (float)this.tick + this.mc().getPartialTick() - this.openedAtTick;
    }

    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(gui, mouseX, mouseY, partialTicks);
        float t = this.time();
        Interp.PowOut interp = Interp.pow2Out;
        float progress = interp.apply(Mathf.clamp((float)(t / this.animTime)));
        this.color(Mathf.clamp((float)(progress / 0.9f)));
        this.m_280273_(gui);
        this.color(progress);
        this.push();
        float y = Mth.m_14179_((float)progress, (float)this.f_96544_, (float)0.0f);
        this.move(0.0f, y);
        float scaleProgress = Mth.m_14036_((float)progress, (float)0.0f, (float)1.0f);
        float s = Mth.m_14179_((float)scaleProgress, (float)0.0f, (float)1.0f);
        this.scale(s, s, this.cx(), this.cy());
        this.render(gui, mouseX, mouseY);
        this.pop();
    }

    public void render(GuiGraphics gui, int mouseX, int mouseY) {
        this.push();
        this.layer(600.0f);
        gui.m_280163_(this.FRAME, this.guiLeft(), this.guiTop(), 0.0f, 0.0f, this.frameWidth, this.frameHeight, 512, 512);
        this.layer(0.0f);
        this.pop();
        this.push();
        this.renderBackground(gui, "textures/gui/book/background.png", mouseX, mouseY);
        this.layer(601.0f);
        if (this.isHover(mouseX, mouseY, (int)(this.cx() - 10.0f), this.guiTop() + this.frameHeight - 15, 20, 20)) {
            gui.m_280163_(this.FRAME, (int)(this.cx() - 5.0f - 1.0f), this.guiTop() + this.frameHeight - 10 - 1, 10.0f, 191.0f, 12, 12, 512, 512);
        } else {
            gui.m_280163_(this.FRAME, (int)(this.cx() - 5.0f), this.guiTop() + this.frameHeight - 10, 0.0f, 192.0f, 10, 10, 512, 512);
        }
        this.pop();
        this.push();
        this.renderBossChecklist(gui, mouseX, mouseY);
        this.pop();
    }

    public void renderBossChecklist(GuiGraphics gui, int mouseX, int mouseY) {
        long currentTime = System.currentTimeMillis();
        float deltaTime = (float)(currentTime - this.lastTime) / 100.0f;
        this.lastTime = currentTime;
        boolean isHovered = this.isHover(mouseX, mouseY, this.guiLeft() - 25, this.guiTop() + 20, 35, 39);
        float targetProgress = isHovered ? 1.0f : 0.0f;
        this.hoverProgress = Mth.m_14179_((float)(0.5f * deltaTime), (float)this.hoverProgress, (float)targetProgress);
        float x = Mth.m_14179_((float)this.hoverProgress, (float)0.0f, (float)-20.0f);
        this.layer(100.0f);
        this.move(x, 0.0f, 0.0f);
        gui.m_280163_(this.FRAME, this.guiLeft() - 10, this.guiTop() + 20, 288.0f, 0.0f, 35, 39, 512, 512);
        gui.m_280203_(Items.f_42750_.m_7968_(), this.guiLeft() + 2, this.guiTop() + 30);
        if (isHovered) {
            this.layer(100.0f);
            gui.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"tooltip.valoria.boss_checklist"), mouseX, mouseY - 15);
        }
    }

    public void drawDebug(double mouseX, double mouseY) {
        this.push();
        this.localPose.m_252880_(0.0f, 0.0f, 600.0f);
        this.localG.m_280509_((int)mouseX, (int)mouseY, (int)(mouseX - 8.0), (int)(mouseY - 8.0), -1);
        float uOffset = this.getuOffset();
        float vOffset = this.getvOffset();
        for (CodexEntry entry : CodexEntries.entries) {
            int x = (this.backgroundWidth - this.insideWidth) / 2 - (entry.x - this.guiLeft()) - (int)uOffset;
            int y = (this.backgroundHeight - this.insideHeight) / 2 - (entry.y - this.guiTop()) - (int)vOffset;
            this.localG.m_280509_(x + 8, y + 8, x + 28, y + 28, -1);
        }
        this.localG.m_280509_((int)(this.cx() - 7.0f), this.guiTop() + this.frameHeight - 15, (int)(this.cx() - 6.0f) + 15, this.guiTop() + this.frameHeight + 5, -1);
        this.pop();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        float uOffset = this.getuOffset();
        float vOffset = this.getvOffset();
        if (button == 0) {
            for (CodexEntry entry : CodexEntries.entries) {
                entry.onClick(this, mouseX, mouseY, (int)uOffset, (int)vOffset);
            }
            if (this.isHover(mouseX, mouseY, this.guiLeft() - 25, this.guiTop() + 20, 35, 39)) {
                this.hoverProgress = 0.0f;
                this.lastTime = 0L;
                this.changeChapter(CodexEntries.BOSS_CHECKLIST);
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public static boolean onClaim(CodexEntry entry, Unlockable unlockable) {
        return MinecraftForge.EVENT_BUS.post((Event)new CodexEvent.OnRewardClaim(entry, unlockable));
    }

    public boolean isOnScreen(double mouseX, double mouseY) {
        return mouseX >= (double)this.insideLeft() && mouseY >= (double)this.insideTop() && mouseX <= (double)(this.insideLeft() + this.insideWidth) && mouseY <= (double)(this.insideTop() + this.insideHeight);
    }

    public boolean isHover(double mouseX, double mouseY, int x, int y, int width, int height) {
        return mouseX >= (double)x && mouseX <= (double)(x + width) && mouseY >= (double)y && mouseY <= (double)(y + height);
    }

    public void changeChapter(Chapter chapter) {
        Minecraft.m_91087_().m_91152_((Screen)new BookGui(chapter, false));
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0) {
            float maxXOffset = (float)this.backgroundWidth / (2.0f * this.xModifier);
            float maxYOffset = (float)this.backgroundHeight / (2.0f * this.yModifier);
            this.xOffset = Mth.m_14036_((float)(this.xOffset + (float)(-dragX)), (float)(-maxXOffset), (float)maxXOffset);
            this.yOffset = Mth.m_14036_((float)(this.yOffset + (float)(-dragY)), (float)(-maxYOffset), (float)maxYOffset);
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public void renderBackground(GuiGraphics gui, String texture, float mouseX, float mouseY) {
        float uOffset = this.getuOffset();
        float vOffset = this.getvOffset();
        gui.m_280163_(Valoria.loc(texture), this.insideLeft(), this.insideTop(), (float)((int)uOffset), (float)((int)vOffset), this.insideWidth, this.insideHeight, this.backgroundWidth, this.backgroundHeight);
        this.push();
        this.layer(this.entries);
        this.renderEntries(gui, uOffset, vOffset, mouseX, mouseY);
        this.pop();
        this.renderCorners(gui, this.insideLeft(), this.insideTop());
    }

    public void renderCorners(GuiGraphics gui, int insideLeft, int insideTop) {
        this.push();
        RenderSystem.enableBlend();
        this.layer(300.0f);
        gui.m_280163_(Valoria.loc("textures/gui/book/frame_blur.png"), insideLeft, insideTop, 0.0f, 0.0f, this.insideWidth, this.insideHeight, this.insideWidth, this.insideHeight);
        RenderSystem.disableBlend();
        this.pop();
    }

    public void renderEntries(GuiGraphics gui, float uOffset, float vOffset, float mouseX, float mouseY) {
        this.scissorsOn((int)this.cx(), (int)this.cy(), this.insideWidth, this.insideHeight);
        for (CodexEntry entry : CodexEntries.entries) {
            if (entry.isHidden()) {
                return;
            }
            entry.node.children.each(c -> {
                if (c.entry.isHidden() || !entry.isUnlocked()) {
                    return;
                }
                float chx = c.entry.x;
                float chy = c.entry.y;
                float x = entry.x;
                float y = entry.y;
                float deltaY = chy - y;
                float y2 = y + deltaY * 0.5f;
                int color = c.entry.isUnlocked() ? Col.intArgb((Col)Col.fromHex((String)"7A5577")) : Col.intArgb((Col)Col.gray);
                this.push();
                this.move((float)(this.backgroundWidth - this.insideWidth) / 2.0f, (float)(this.backgroundHeight - this.insideHeight) / 2.0f);
                this.move(this.guiLeft(), this.guiTop());
                this.move(-uOffset, -vOffset);
                this.move(18.0f, 18.0f);
                this.layer(this.entries - 105);
                gui.m_280509_((int)(-x - 1.0f), (int)(-y) - 1 + 11, (int)(-x) + 2, (int)(-y) + 2 + 11, color);
                gui.m_280315_((int)(-x), (int)(-y), (int)(-y2), color);
                gui.m_280656_((int)(-x), (int)(-chx), (int)(-y2), color);
                gui.m_280315_((int)(-chx), (int)(-y2), (int)(-chy), color);
                this.pop();
                entry.render(this, gui, uOffset, vOffset, this.insideLeft(), this.insideTop(), mouseX, mouseY);
                c.entry.render(this, gui, uOffset, vOffset, this.insideLeft(), this.insideTop(), mouseX, mouseY);
            });
        }
        this.scissorsOff();
    }

    public float getvOffset() {
        return Mth.m_14036_((float)((float)this.backgroundHeight / 2.0f - (float)this.insideHeight + this.yOffset * this.yModifier), (float)0.0f, (float)(this.backgroundHeight - this.insideHeight));
    }

    public float getuOffset() {
        return Mth.m_14036_((float)((float)this.backgroundWidth / 2.0f - (float)this.insideWidth + this.xOffset * this.xModifier), (float)0.0f, (float)(this.backgroundWidth - this.insideWidth));
    }

    public int insideLeft() {
        return (this.f_96543_ - this.insideWidth) / 2;
    }

    public int insideTop() {
        return (this.f_96544_ - this.insideHeight) / 2;
    }

    public int guiLeft() {
        return (this.f_96543_ - this.frameWidth) / 2;
    }

    public int guiTop() {
        return (this.f_96544_ - this.frameHeight) / 2;
    }
}

