/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class CommonConfig {
    public static ForgeConfigSpec.ConfigValue<Integer> ATTACK_NECROMANCER_CASTING_TIME;
    public static ForgeConfigSpec.ConfigValue<Integer> ATTACK_NECROMANCER_CASTING_INTERVAL;
    public static ForgeConfigSpec.ConfigValue<Integer> ATTACK_NECROMANCER_DAMAGE;
    public static ForgeConfigSpec.ConfigValue<Integer> SUMMON_NECROMANCER_CASTING_TIME;
    public static ForgeConfigSpec.ConfigValue<Integer> SUMMON_NECROMANCER_CASTING_INTERVAL;
    public static ForgeConfigSpec.ConfigValue<Integer> KNOCKBACK_NECROMANCER_CASTING_TIME;
    public static ForgeConfigSpec.ConfigValue<Integer> KNOCKBACK_NECROMANCER_CASTING_INTERVAL;
    public static ForgeConfigSpec.ConfigValue<Integer> KNOCKBACK_NECROMANCER_RADIUS;
    public static ForgeConfigSpec.ConfigValue<Integer> KNOCKBACK_NECROMANCER_RADIUS_STRONG;
    public static ForgeConfigSpec.ConfigValue<Integer> TARGET_HEAL_NECROMANCER_CASTING_TIME;
    public static ForgeConfigSpec.ConfigValue<Integer> TARGET_HEAL_NECROMANCER_CASTING_INTERVAL;
    public static ForgeConfigSpec.ConfigValue<Integer> SELF_HEAL_NECROMANCER_CASTING_TIME;
    public static ForgeConfigSpec.ConfigValue<Integer> SELF_HEAL_NECROMANCER_CASTING_INTERVAL;
    public static ForgeConfigSpec.ConfigValue<Integer> EFFECT_NECROMANCER_CASTING_TIME;
    public static ForgeConfigSpec.ConfigValue<Integer> EFFECT_NECROMANCER_CASTING_INTERVAL;
    public static ForgeConfigSpec.ConfigValue<Integer> WOLOLO_NECROMANCER_CASTING_TIME;
    public static ForgeConfigSpec.ConfigValue<Integer> WOLOLO_NECROMANCER_CASTING_INTERVAL;
    public static ForgeConfigSpec.ConfigValue<Integer> SHIELDS_WICKED_CRYSTAL_CASTING_TIME;
    public static ForgeConfigSpec.ConfigValue<Integer> SHIELDS_WICKED_CRYSTAL_CASTING_INTERVAL;
    public static ForgeConfigSpec.ConfigValue<Integer> SHIELDS_WICKED_CRYSTAL_COUNT_PHASE1;
    public static ForgeConfigSpec.ConfigValue<Integer> SHIELDS_WICKED_CRYSTAL_COUNT_PHASE2;
    public static ForgeConfigSpec.ConfigValue<Integer> SHIELDS_WICKED_CRYSTAL_LIMIT;
    public static ForgeConfigSpec.ConfigValue<Integer> SUMMON_WICKED_CRYSTAL_CASTING_TIME;
    public static ForgeConfigSpec.ConfigValue<Integer> SUMMON_WICKED_CRYSTAL_CASTING_INTERVAL;
    public static ForgeConfigSpec.ConfigValue<Integer> RADIAL_WICKED_CRYSTAL_CASTING_TIME;
    public static ForgeConfigSpec.ConfigValue<Integer> RADIAL_WICKED_CRYSTAL_CASTING_INTERVAL;
    public static ForgeConfigSpec.ConfigValue<Integer> RADIAL_WICKED_CRYSTAL_DAMAGE;
    public static ForgeConfigSpec.ConfigValue<Integer> CRYSTAL_STORM_WICKED_CRYSTAL_CASTING_TIME;
    public static ForgeConfigSpec.ConfigValue<Integer> CRYSTAL_STORM_WICKED_CRYSTAL_CASTING_INTERVAL;
    public static ForgeConfigSpec.ConfigValue<Float> TARGET_HEAL_NECROMANCER_AMOUNT;
    public static ForgeConfigSpec.ConfigValue<Float> SELF_HEAL_NECROMANCER_AMOUNT;
    public static ForgeConfigSpec.ConfigValue<Boolean> FOOD_ROT;
    public static ForgeConfigSpec.ConfigValue<Boolean> NIHILITY;
    public static final CommonConfig INSTANCE;
    public static final ForgeConfigSpec SPEC;

    public CommonConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Gameplay").push("gameplay");
        NIHILITY = builder.comment("Nihility System in Valoria, Default: true)").define("nihility", true);
        FOOD_ROT = builder.comment("Food spoiling on entering Valoria dimension, Default: true)").define("foodRot", true);
        this.setupBosses(builder);
        builder.pop();
    }

    private void setupBosses(ForgeConfigSpec.Builder builder) {
        builder.comment("Bosses").push("bosses");
        builder.comment("Necromancer").push("necromancer");
        ATTACK_NECROMANCER_CASTING_TIME = builder.comment("Casting time").define("devourerCastingTime", (Object)40);
        ATTACK_NECROMANCER_CASTING_INTERVAL = builder.comment("Casting interval").define("devourerCastingInterval", (Object)150);
        ATTACK_NECROMANCER_DAMAGE = builder.comment("Damage of summoned devourer").define("devourerDamage", (Object)5);
        SUMMON_NECROMANCER_CASTING_TIME = builder.comment("Casting time").define("summonCastingTime", (Object)40);
        SUMMON_NECROMANCER_CASTING_INTERVAL = builder.comment("Casting interval").define("summonCastingInterval", (Object)200);
        KNOCKBACK_NECROMANCER_CASTING_TIME = builder.comment("Casting time").define("knockbackCastingTime", (Object)20);
        KNOCKBACK_NECROMANCER_CASTING_INTERVAL = builder.comment("Casting interval").define("knockbackCastingInterval", (Object)65);
        KNOCKBACK_NECROMANCER_RADIUS = builder.comment("Radius of knockback").define("knockbackRadius", (Object)3);
        KNOCKBACK_NECROMANCER_RADIUS_STRONG = builder.comment("Radius of strong knockback casted when Necromancer HP is lower than 100").define("knockbackRadiusStrong", (Object)6);
        TARGET_HEAL_NECROMANCER_CASTING_TIME = builder.comment("Casting time").define("targetHealCastingTtime", (Object)60);
        TARGET_HEAL_NECROMANCER_CASTING_INTERVAL = builder.comment("Casting interval").define("targetHealCastingInterval", (Object)200);
        TARGET_HEAL_NECROMANCER_AMOUNT = builder.comment("Amount of healed hp").define("targetHeal", (Object)Float.valueOf(12.0f));
        SELF_HEAL_NECROMANCER_CASTING_TIME = builder.comment("Casting time").define("selfHealCastingTime", (Object)60);
        SELF_HEAL_NECROMANCER_CASTING_INTERVAL = builder.comment("Casting interval").define("selfHealCastingInterval", (Object)300);
        SELF_HEAL_NECROMANCER_AMOUNT = builder.comment("Amount of healed hp").define("self_heal", (Object)Float.valueOf(25.0f));
        EFFECT_NECROMANCER_CASTING_TIME = builder.comment("Casting time").define("effectCastingTime", (Object)20);
        EFFECT_NECROMANCER_CASTING_INTERVAL = builder.comment("Casting interval").define("effectCastingInterval", (Object)150);
        WOLOLO_NECROMANCER_CASTING_TIME = builder.comment("Casting time").define("wololo_casting_time", (Object)60);
        WOLOLO_NECROMANCER_CASTING_INTERVAL = builder.comment("Casting interval").define("wololoCastingInterval", (Object)180);
        builder.pop();
        builder.comment("Wicked Crystal").push("wicked_crystal");
        SHIELDS_WICKED_CRYSTAL_CASTING_TIME = builder.comment("Casting time").define("shieldsCastingTime", (Object)25);
        SHIELDS_WICKED_CRYSTAL_CASTING_INTERVAL = builder.comment("Casting interval").define("shieldsCastingInterval", (Object)1200);
        SHIELDS_WICKED_CRYSTAL_COUNT_PHASE1 = builder.comment("Count of summoned shields").define("shieldsCountPhase_1", (Object)2);
        SHIELDS_WICKED_CRYSTAL_COUNT_PHASE2 = builder.comment("Count of summoned shields").define("shieldsCountPhase_2", (Object)4);
        SHIELDS_WICKED_CRYSTAL_LIMIT = builder.comment("Limit of shields").define("shieldsLimit", (Object)8);
        SUMMON_WICKED_CRYSTAL_CASTING_TIME = builder.comment("Casting time").define("crystalSummonCastingTime", (Object)20);
        SUMMON_WICKED_CRYSTAL_CASTING_INTERVAL = builder.comment("Casting interval").define("crystalSummonCastingInterval", (Object)425);
        RADIAL_WICKED_CRYSTAL_CASTING_TIME = builder.comment("Casting time").define("radialCrystalsCastingTime", (Object)20);
        RADIAL_WICKED_CRYSTAL_CASTING_INTERVAL = builder.comment("Casting interval").define("radialCrystalsCastingInterval", (Object)160);
        RADIAL_WICKED_CRYSTAL_DAMAGE = builder.comment("Damage of crystals").define("radialCrystalsDamage", (Object)4);
        CRYSTAL_STORM_WICKED_CRYSTAL_CASTING_TIME = builder.comment("Casting time").define("crystalStormCastingTime", (Object)25);
        CRYSTAL_STORM_WICKED_CRYSTAL_CASTING_INTERVAL = builder.comment("Casting interval").define("crystalStormCastingInterval", (Object)400);
        builder.pop();
        builder.pop();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        SPEC = (ForgeConfigSpec)specPair.getRight();
        INSTANCE = (CommonConfig)specPair.getLeft();
    }
}

