/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.network.packets;

import com.idark.valoria.client.ui.menus.AlchemyStationMenu;
import com.idark.valoria.registries.BlockRegistry;
import com.idark.valoria.registries.block.types.AlchemyStationBlock;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class AlchemyUpgradePacket {
    public int level;

    public AlchemyUpgradePacket(int level) {
        this.level = level;
    }

    public static void encode(AlchemyUpgradePacket object, FriendlyByteBuf buffer) {
        buffer.writeInt(object.level);
    }

    public static AlchemyUpgradePacket decode(FriendlyByteBuf buffer) {
        return new AlchemyUpgradePacket(buffer.m_130242_());
    }

    public static void handle(AlchemyUpgradePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            Level level = player.m_9236_();
            AbstractContainerMenu patt1151$temp = player.f_36096_;
            if (patt1151$temp instanceof AlchemyStationMenu) {
                AlchemyStationMenu heavyMenu = (AlchemyStationMenu)patt1151$temp;
                player.m_6915_();
                level.m_247517_(null, heavyMenu.getPos(), SoundEvents.f_12496_, SoundSource.BLOCKS);
                BlockState state = level.m_8055_(heavyMenu.getPos());
                Block patt1467$temp = state.m_60734_();
                if (patt1467$temp instanceof AlchemyStationBlock) {
                    AlchemyStationBlock stationBlock = (AlchemyStationBlock)patt1467$temp;
                    BlockState toState = switch (stationBlock.level) {
                        case 1 -> ((Block)BlockRegistry.alchemyStationTier2.get()).m_49966_();
                        case 2 -> ((Block)BlockRegistry.alchemyStationTier3.get()).m_49966_();
                        case 3 -> ((Block)BlockRegistry.alchemyStationTier4.get()).m_49966_();
                        default -> ((Block)BlockRegistry.alchemyStationTier1.get()).m_49966_();
                    };
                    stationBlock.upgrade(heavyMenu.getPos(), state, level, toState);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

